/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.AbstractComponentTreeNode;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.componenttree.ComponentProperties;
import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.ProxyComponentTreeNode;
import jadex.base.gui.componenttree.ServiceContainerNode;
import jadex.base.gui.componenttree.ServiceNode;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.concurrent.DelegationResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.service.IService;
import jadex.commons.service.IServiceContainer;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;

public class ComponentTreeNode
extends AbstractComponentTreeNode
implements IActiveComponentTreeNode {
    protected IComponentDescription desc;
    protected final IComponentManagementService cms;
    protected final ComponentIconCache iconcache;
    protected ComponentProperties propcomp;

    public ComponentTreeNode(IComponentTreeNode parent, ComponentTreeModel model, JTree tree, IComponentDescription desc, IComponentManagementService cms, ComponentIconCache iconcache) {
        super(parent, model, tree);
        this.desc = desc;
        this.cms = cms;
        this.iconcache = iconcache;
        model.registerNode(this);
    }

    public Object getId() {
        return this.desc.getName();
    }

    public Icon getIcon() {
        return this.iconcache.getIcon(this, this.desc.getType());
    }

    public void refresh(boolean recurse, boolean force) {
        this.cms.getComponentDescription(this.desc.getName()).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                ComponentTreeNode.this.desc = (IComponentDescription)result;
                ComponentTreeNode.this.getModel().fireNodeChanged(ComponentTreeNode.this);
            }

            public void customExceptionOccurred(Object source, Exception exception) {
            }
        });
        super.refresh(recurse, force);
    }

    protected void searchChildren(boolean force) {
        final ArrayList children = new ArrayList();
        final boolean[] ready = new boolean[2];
        final Future future = new Future();
        this.cms.getChildren(this.desc.getName()).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                final IComponentIdentifier[] achildren = (IComponentIdentifier[])result;
                final int[] childcnt = new int[]{0};
                if (achildren != null && achildren.length > 0) {
                    for (int i = 0; i < achildren.length; ++i) {
                        ComponentTreeNode.this.cms.getComponentDescription(achildren[i]).addResultListener((IResultListener)new SwingDefaultResultListener(){

                            public void customResultAvailable(Object source, Object result) {
                                IComponentDescription desc = (IComponentDescription)result;
                                IComponentTreeNode node = ComponentTreeNode.this.getModel().getNode(desc.getName());
                                if (node == null) {
                                    ComponentTreeNode.this.createComponentNode(desc).addResultListener((IResultListener)new SwingDefaultResultListener(){

                                        public void customResultAvailable(Object source, Object result) {
                                            children.add(result);
                                            int[] nArray = childcnt;
                                            nArray[0] = nArray[0] + 1;
                                            if (childcnt[0] == achildren.length) {
                                                ((this).this).ready[0] = true;
                                                if (ready[0] && ready[1]) {
                                                    ComponentTreeNode.this.setChildren(children).addResultListener((IResultListener)new DelegationResultListener(future));
                                                }
                                            }
                                        }

                                        public void customExceptionOccurred(Object source, Exception exception) {
                                            int[] nArray = childcnt;
                                            nArray[0] = nArray[0] + 1;
                                            if (childcnt[0] == achildren.length) {
                                                ((this).this).ready[0] = true;
                                                if (ready[0] && ready[1]) {
                                                    ComponentTreeNode.this.setChildren(children).addResultListener((IResultListener)new DelegationResultListener(future));
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    children.add(node);
                                    childcnt[0] = childcnt[0] + 1;
                                    if (childcnt[0] == achildren.length) {
                                        (this).ready[0] = true;
                                        if (ready[0] && ready[1]) {
                                            ComponentTreeNode.this.setChildren(children).addResultListener((IResultListener)new DelegationResultListener(future));
                                        }
                                    }
                                }
                            }

                            public void customExceptionOccurred(Object source, Exception exception) {
                                childcnt[0] = childcnt[0] + 1;
                                if (childcnt[0] == achildren.length) {
                                    (this).ready[0] = true;
                                    if (ready[0] && ready[1]) {
                                        ComponentTreeNode.this.setChildren(children).addResultListener((IResultListener)new DelegationResultListener(future));
                                    }
                                }
                            }
                        });
                    }
                } else {
                    ready[0] = true;
                    if (ready[0] && ready[1]) {
                        ComponentTreeNode.this.setChildren(children).addResultListener((IResultListener)new DelegationResultListener(future));
                    }
                }
            }

            public void customExceptionOccurred(Object source, Exception exception) {
            }
        });
        this.cms.getExternalAccess(this.desc.getName()).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                final IExternalAccess ea = (IExternalAccess)result;
                SServiceProvider.getDeclaredServices((IServiceProvider)ea.getServiceProvider()).addResultListener((IResultListener)new SwingDefaultResultListener(){

                    public void customResultAvailable(Object source, Object result) {
                        List services = (List)result;
                        if (services != null && !services.isEmpty()) {
                            ServiceContainerNode scn = (ServiceContainerNode)ComponentTreeNode.this.getModel().getNode((this).ComponentTreeNode.this.desc.getName().getName() + "ServiceContainer");
                            if (scn == null) {
                                scn = new ServiceContainerNode(ComponentTreeNode.this, ComponentTreeNode.this.getModel(), ComponentTreeNode.this.getTree(), (IServiceContainer)ea.getServiceProvider());
                            }
                            children.add(0, scn);
                            final ArrayList<ServiceNode> subchildren = new ArrayList<ServiceNode>();
                            for (int i = 0; i < services.size(); ++i) {
                                IService service = (IService)services.get(i);
                                ServiceNode sn = (ServiceNode)ComponentTreeNode.this.getModel().getNode(service.getServiceIdentifier());
                                if (sn == null) {
                                    sn = new ServiceNode(scn, ComponentTreeNode.this.getModel(), ComponentTreeNode.this.getTree(), service);
                                }
                                subchildren.add(sn);
                            }
                            final ServiceContainerNode node = scn;
                            future.addResultListener((IResultListener)new SwingDefaultResultListener(){

                                public void customResultAvailable(Object source, Object result) {
                                    node.setChildren(subchildren);
                                }

                                public void customExceptionOccurred(Object source, Exception exception) {
                                }
                            });
                        }
                        (this).ready[1] = true;
                        if (ready[0] && ready[1]) {
                            ComponentTreeNode.this.setChildren(children).addResultListener((IResultListener)new DelegationResultListener(future));
                        }
                    }

                    public void customExceptionOccurred(Object source, Exception exception) {
                        (this).ready[1] = true;
                        if (ready[0] && ready[1]) {
                            ComponentTreeNode.this.setChildren(children).addResultListener((IResultListener)new DelegationResultListener(future));
                        }
                    }
                });
            }

            public void customExceptionOccurred(Object source, Exception exception) {
            }
        });
    }

    public IFuture createComponentNode(final IComponentDescription desc) {
        final Future ret = new Future();
        this.cms.getExternalAccess(desc.getName()).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                IComponentTreeNode node = ComponentTreeNode.this.getModel().getNode(desc.getName());
                if (node == null) {
                    IExternalAccess exta = (IExternalAccess)result;
                    boolean proxy = "jadex.base.service.remote.Proxy".equals(exta.getModel().getFullName());
                    node = proxy ? new ProxyComponentTreeNode(ComponentTreeNode.this, ComponentTreeNode.this.getModel(), ComponentTreeNode.this.getTree(), desc, ComponentTreeNode.this.cms, ComponentTreeNode.this.iconcache) : new ComponentTreeNode(ComponentTreeNode.this, ComponentTreeNode.this.getModel(), ComponentTreeNode.this.getTree(), desc, ComponentTreeNode.this.cms, ComponentTreeNode.this.iconcache);
                }
                ret.setResult((Object)node);
            }

            public void customExceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public String toString() {
        return this.desc.getName().getLocalName();
    }

    public IComponentDescription getDescription() {
        return this.desc;
    }

    public void setDescription(IComponentDescription desc) {
        this.desc = desc;
        if (this.propcomp != null) {
            this.propcomp.setDescription(desc);
            this.propcomp.repaint();
        }
    }

    public boolean hasProperties() {
        return true;
    }

    public JComponent getPropertiesComponent() {
        if (this.propcomp == null) {
            this.propcomp = new ComponentProperties();
        }
        this.propcomp.setDescription(this.desc);
        return this.propcomp;
    }
}

