/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.ObjectInspectorPanel;
import jadex.base.gui.componenttree.AbstractComponentTreeNode;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.componenttree.ComponentTreeCellRenderer;
import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.ComponentTreeNode;
import jadex.base.gui.componenttree.ComponentTreePopupListener;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.INodeHandler;
import jadex.base.gui.componenttree.ProxyComponentTreeNode;
import jadex.base.gui.componenttree.ServiceContainerNode;
import jadex.base.gui.componenttree.ServiceNode;
import jadex.base.gui.componenttree.VirtualComponentTreeNode;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentListener;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IRemoteServiceManagementService;
import jadex.commons.SGUI;
import jadex.commons.TreeExpansionHandler;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.gui.CombiIcon;
import jadex.commons.service.IService;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreePath;

public class ComponentTreePanel
extends JSplitPane {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"component_suspended", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_szzz.png"), "kill_component", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/new_killagent.png"), "suspend_component", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/new_agent_szzz_big.png"), "resume_component", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/resume_component.png"), "step_component", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/step_component.png"), "refresh", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/refresh_component.png"), "refresh_tree", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/refresh_tree.png"), "show_properties", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/new_agent_props.png"), "show_details", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/new_agent_details.png"), "overlay_kill", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_kill.png"), "overlay_suspend", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_szzz.png"), "overlay_resume", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_wakeup.png"), "overlay_step", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_step.png"), "overlay_ready", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_busy.png"), "overlay_running", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_gearwheel.png"), "overlay_refresh", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_refresh.png"), "overlay_refreshtree", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_refresh.png"), "overlay_showprops", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_doc.png"), "overlay_showobject", SGUI.makeIcon((Class)ComponentTreePanel.class, (String)"/jadex/base/gui/images/overlay_bean.png")});
    private final IServiceProvider provider;
    private final ComponentTreeModel model;
    private final JTree tree;
    private IComponentManagementService cms;
    private final Action kill;
    private final Action proxykill;
    private final Action suspend;
    private final Action resume;
    private final Action step;
    private final Action refresh;
    private final Action refreshtree;
    private final Action showprops;
    private final Action showobject;
    private final Action removeservice;
    private final IComponentListener listener;
    private final JScrollPane proppanel;
    static /* synthetic */ Class class$jadex$bridge$IRemoteServiceManagementService;

    public ComponentTreePanel(IServiceProvider provider) {
        this(provider, 0);
    }

    public ComponentTreePanel(final IServiceProvider provider, int orientation) {
        super(orientation);
        this.setOneTouchExpandable(true);
        this.provider = provider;
        this.model = new ComponentTreeModel();
        this.tree = new JTree(this.model);
        this.tree.setCellRenderer(new ComponentTreeCellRenderer());
        this.tree.addMouseListener(new ComponentTreePopupListener());
        this.tree.setShowsRootHandles(true);
        this.tree.setToggleClickCount(0);
        final ComponentIconCache cic = new ComponentIconCache(provider, this.tree);
        JScrollPane scroll = new JScrollPane(this.tree);
        this.add(scroll);
        this.proppanel = new JScrollPane();
        this.proppanel.setMinimumSize(new Dimension(0, 0));
        this.proppanel.setPreferredSize(new Dimension(0, 0));
        this.add(this.proppanel);
        this.setResizeWeight(1.0);
        this.listener = new IComponentListener(){

            public void componentRemoved(IComponentDescription desc, Map results) {
                final IComponentTreeNode node = ComponentTreePanel.this.model.getNodeOrAddZombie(desc.getName());
                if (node != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (node.getParent() != null) {
                                ((AbstractComponentTreeNode)node.getParent()).removeChild(node);
                            }
                        }
                    });
                }
            }

            public void componentChanged(final IComponentDescription desc) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ComponentTreeNode node = (ComponentTreeNode)ComponentTreePanel.this.model.getAddedNode(desc.getName());
                        if (node != null) {
                            node.setDescription(desc);
                            ComponentTreePanel.this.model.fireNodeChanged(node);
                        }
                    }
                });
            }

            public void componentAdded(final IComponentDescription desc) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ComponentTreeNode parentnode;
                        ComponentTreeNode componentTreeNode = parentnode = desc.getParent() == null ? null : (ComponentTreeNode)ComponentTreePanel.this.model.getAddedNode(desc.getParent());
                        if (parentnode != null) {
                            parentnode.createComponentNode(desc).addResultListener((IResultListener)new SwingDefaultResultListener(){

                                public void customResultAvailable(Object source, Object result) {
                                    IComponentTreeNode node = (IComponentTreeNode)result;
                                    try {
                                        if (parentnode.getIndexOfChild(node) == -1) {
                                            parentnode.addChild(node);
                                        }
                                    }
                                    catch (Exception e) {
                                        System.err.println("" + ComponentTreePanel.this.model.hashCode() + " Broken node: " + node);
                                        System.err.println("" + ComponentTreePanel.this.model.hashCode() + " Parent: " + parentnode + ", " + parentnode.getCachedChildren());
                                        e.printStackTrace();
                                    }
                                }

                                public void customExceptionOccurred(Object source, Exception exception) {
                                }
                            });
                        }
                    }
                });
            }
        };
        this.kill = new AbstractAction("Kill component", icons.getIcon("kill_component")){

            public void actionPerformed(ActionEvent e) {
                if (ComponentTreePanel.this.cms != null) {
                    TreePath[] paths = ComponentTreePanel.this.tree.getSelectionPaths();
                    for (int i = 0; paths != null && i < paths.length; ++i) {
                        final IComponentIdentifier cid = ((IActiveComponentTreeNode)paths[i].getLastPathComponent()).getDescription().getName();
                        final IComponentTreeNode sel = (IComponentTreeNode)paths[i].getLastPathComponent();
                        ComponentTreePanel.this.cms.resumeComponent(cid).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                            public void customResultAvailable(Object source, Object result) {
                                ComponentTreePanel.this.cms.destroyComponent(cid).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                                    public void customResultAvailable(Object source, Object result) {
                                        if (sel instanceof VirtualComponentTreeNode && sel.getParent() != null) {
                                            ((AbstractComponentTreeNode)sel.getParent()).removeChild(sel);
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            }
        };
        this.proxykill = new AbstractAction("Kill also remote component", icons.getIcon("kill_component")){

            public void actionPerformed(ActionEvent e) {
                if (ComponentTreePanel.this.cms != null) {
                    TreePath[] paths = ComponentTreePanel.this.tree.getSelectionPaths();
                    for (int i = 0; paths != null && i < paths.length; ++i) {
                        ProxyComponentTreeNode sel = (ProxyComponentTreeNode)paths[i].getLastPathComponent();
                        sel.getRemoteComponentIdentifier().addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                            public void customResultAvailable(Object source, Object result) {
                                final IComponentIdentifier cid = (IComponentIdentifier)result;
                                SServiceProvider.getService((IServiceProvider)provider, (Class)(class$jadex$bridge$IRemoteServiceManagementService == null ? (class$jadex$bridge$IRemoteServiceManagementService = ComponentTreePanel.class$("jadex.bridge.IRemoteServiceManagementService")) : class$jadex$bridge$IRemoteServiceManagementService)).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                                    public void customResultAvailable(Object source, Object result) {
                                        IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                                        rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentTreePanel.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                                            public void customResultAvailable(Object source, Object result) {
                                                IComponentManagementService rcms = (IComponentManagementService)result;
                                                rcms.destroyComponent(cid);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                }
            }
        };
        this.suspend = new AbstractAction("Suspend component", icons.getIcon("suspend_component")){

            public void actionPerformed(ActionEvent e) {
                if (ComponentTreePanel.this.cms != null) {
                    TreePath[] paths = ComponentTreePanel.this.tree.getSelectionPaths();
                    for (int i = 0; paths != null && i < paths.length; ++i) {
                        IComponentIdentifier cid = ((IActiveComponentTreeNode)paths[i].getLastPathComponent()).getDescription().getName();
                        final IComponentTreeNode sel = (IComponentTreeNode)paths[i].getLastPathComponent();
                        ComponentTreePanel.this.cms.suspendComponent(cid).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                            public void customResultAvailable(Object source, Object result) {
                                if (sel instanceof VirtualComponentTreeNode) {
                                    sel.refresh(false, false);
                                }
                            }
                        });
                    }
                }
            }
        };
        this.resume = new AbstractAction("Resume component", icons.getIcon("resume_component")){

            public void actionPerformed(ActionEvent e) {
                if (ComponentTreePanel.this.cms != null) {
                    TreePath[] paths = ComponentTreePanel.this.tree.getSelectionPaths();
                    for (int i = 0; paths != null && i < paths.length; ++i) {
                        IComponentIdentifier cid = ((IActiveComponentTreeNode)paths[i].getLastPathComponent()).getDescription().getName();
                        final IComponentTreeNode sel = (IComponentTreeNode)paths[i].getLastPathComponent();
                        ComponentTreePanel.this.cms.resumeComponent(cid).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                            public void customResultAvailable(Object source, Object result) {
                                if (sel instanceof VirtualComponentTreeNode) {
                                    sel.refresh(false, false);
                                }
                            }
                        });
                    }
                }
            }
        };
        this.step = new AbstractAction("Step component", icons.getIcon("step_component")){

            public void actionPerformed(ActionEvent e) {
                if (ComponentTreePanel.this.cms != null) {
                    TreePath[] paths = ComponentTreePanel.this.tree.getSelectionPaths();
                    for (int i = 0; paths != null && i < paths.length; ++i) {
                        IComponentIdentifier cid = ((IActiveComponentTreeNode)paths[i].getLastPathComponent()).getDescription().getName();
                        final IComponentTreeNode sel = (IComponentTreeNode)paths[i].getLastPathComponent();
                        ComponentTreePanel.this.cms.stepComponent(cid).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                            public void customResultAvailable(Object source, Object result) {
                                if (sel instanceof VirtualComponentTreeNode) {
                                    sel.refresh(false, false);
                                }
                            }
                        });
                    }
                }
            }
        };
        this.refresh = new AbstractAction("Refresh", icons.getIcon("refresh")){

            public void actionPerformed(ActionEvent e) {
                TreePath[] paths = ComponentTreePanel.this.tree.getSelectionPaths();
                for (int i = 0; paths != null && i < paths.length; ++i) {
                    ((IComponentTreeNode)paths[i].getLastPathComponent()).refresh(false, true);
                }
            }
        };
        this.refreshtree = new AbstractAction("Refresh subtree", icons.getIcon("refresh_tree")){

            public void actionPerformed(ActionEvent e) {
                TreePath[] paths = ComponentTreePanel.this.tree.getSelectionPaths();
                for (int i = 0; paths != null && i < paths.length; ++i) {
                    ((IComponentTreeNode)paths[i].getLastPathComponent()).refresh(true, true);
                }
            }
        };
        this.showprops = new AbstractAction("Show properties", icons.getIcon("show_properties")){

            public void actionPerformed(ActionEvent e) {
                TreePath path = ComponentTreePanel.this.tree.getSelectionPath();
                if (path != null && ((IComponentTreeNode)path.getLastPathComponent()).hasProperties()) {
                    ComponentTreePanel.this.showProperties(((IComponentTreeNode)path.getLastPathComponent()).getPropertiesComponent());
                }
            }
        };
        this.removeservice = new AbstractAction("Remove service", icons.getIcon("show_properties")){

            public void actionPerformed(ActionEvent e) {
                TreePath path = ComponentTreePanel.this.tree.getSelectionPath();
                if (path != null) {
                    final ServiceContainerNode scn = (ServiceContainerNode)path.getPathComponent(path.getPathCount() - 2);
                    final ServiceNode sn = (ServiceNode)path.getLastPathComponent();
                    scn.getContainer().removeService(sn.getService().getServiceIdentifier()).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this.proppanel){

                        public void customResultAvailable(Object source, Object result) {
                            scn.removeChild(sn);
                        }
                    });
                }
            }
        };
        this.showobject = new AbstractAction("Show object details", icons.getIcon("show_details")){

            public void actionPerformed(ActionEvent e) {
                TreePath path = ComponentTreePanel.this.tree.getSelectionPath();
                if (path != null) {
                    IComponentTreeNode node = (IComponentTreeNode)path.getLastPathComponent();
                    if (node instanceof ServiceNode) {
                        IService obj = ((ServiceNode)node).getService();
                        ObjectInspectorPanel panel = new ObjectInspectorPanel(obj);
                        ComponentTreePanel.this.showProperties(panel);
                    } else if (node instanceof IActiveComponentTreeNode) {
                        IComponentDescription desc = ((IActiveComponentTreeNode)node).getDescription();
                        ComponentTreePanel.this.cms.getExternalAccess(desc.getName()).addResultListener((IResultListener)new SwingDefaultResultListener(null){

                            public void customResultAvailable(Object source, Object result) {
                                IExternalAccess ea = (IExternalAccess)result;
                                ObjectInspectorPanel panel = new ObjectInspectorPanel(ea);
                                ComponentTreePanel.this.showProperties(panel);
                            }
                        });
                    }
                }
            }
        };
        this.model.addNodeHandler(new INodeHandler(){

            public Icon getOverlay(IComponentTreeNode node) {
                return null;
            }

            public Action[] getPopupActions(IComponentTreeNode[] nodes) {
                ArrayList<AbstractAction> ret = new ArrayList<AbstractAction>();
                Icon base = nodes[0].getIcon();
                if (nodes.length == 1) {
                    if (nodes[0].hasProperties()) {
                        AbstractAction pshowprops = new AbstractAction((String)ComponentTreePanel.this.showprops.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_showprops")}) : (Icon)ComponentTreePanel.this.showprops.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                ComponentTreePanel.this.showprops.actionPerformed(e);
                            }
                        };
                        ret.add(pshowprops);
                    }
                    if (nodes[0] instanceof ServiceNode || nodes[0] instanceof IActiveComponentTreeNode) {
                        AbstractAction pshowobject = new AbstractAction((String)ComponentTreePanel.this.showobject.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_showobject")}) : (Icon)ComponentTreePanel.this.showprops.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                ComponentTreePanel.this.showobject.actionPerformed(e);
                            }
                        };
                        ret.add(pshowobject);
                    }
                    if (nodes[0] instanceof ServiceNode && !Proxy.isProxyClass(((ServiceNode)nodes[0]).getService().getClass())) {
                        AbstractAction premoveservice = new AbstractAction((String)ComponentTreePanel.this.removeservice.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_kill")}) : (Icon)ComponentTreePanel.this.showprops.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                ComponentTreePanel.this.removeservice.actionPerformed(e);
                            }
                        };
                        ret.add(premoveservice);
                    }
                }
                AbstractAction prefresh = new AbstractAction((String)ComponentTreePanel.this.refresh.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_refresh")}) : (Icon)ComponentTreePanel.this.refresh.getValue("SmallIcon"))){

                    public void actionPerformed(ActionEvent e) {
                        ComponentTreePanel.this.refresh.actionPerformed(e);
                    }
                };
                ret.add(prefresh);
                AbstractAction prefreshtree = new AbstractAction((String)ComponentTreePanel.this.refreshtree.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_refreshtree")}) : (Icon)ComponentTreePanel.this.refreshtree.getValue("SmallIcon"))){

                    public void actionPerformed(ActionEvent e) {
                        ComponentTreePanel.this.refreshtree.actionPerformed(e);
                    }
                };
                ret.add(prefreshtree);
                return ret.toArray(new Action[0]);
            }

            public Action getDefaultAction(IComponentTreeNode node) {
                Action ret = null;
                if (node.hasProperties()) {
                    ret = ComponentTreePanel.this.showprops;
                }
                return ret;
            }
        });
        this.model.addNodeHandler(new INodeHandler(){

            public Icon getOverlay(IComponentTreeNode node) {
                Icon ret = null;
                IComponentDescription desc = null;
                if (node instanceof IActiveComponentTreeNode) {
                    desc = ((IActiveComponentTreeNode)node).getDescription();
                    if ("ready".equals(desc.getProcessingState())) {
                        ret = icons.getIcon("overlay_ready");
                    } else if ("running".equals(desc.getProcessingState())) {
                        ret = icons.getIcon("overlay_running");
                    } else if ("idle".equals(desc.getProcessingState()) && "suspended".equals(desc.getState())) {
                        ret = icons.getIcon("component_suspended");
                    }
                }
                return ret;
            }

            public Action[] getPopupActions(IComponentTreeNode[] nodes) {
                ArrayList<AbstractAction> ret = new ArrayList<AbstractAction>();
                boolean allcomp = true;
                for (int i = 0; allcomp && i < nodes.length; ++i) {
                    allcomp = nodes[i] instanceof IActiveComponentTreeNode;
                }
                boolean allproxy = true;
                for (int i = 0; allproxy && i < nodes.length; ++i) {
                    allproxy = nodes[i] instanceof ProxyComponentTreeNode && ((ProxyComponentTreeNode)nodes[i]).isConnected();
                }
                if (allcomp) {
                    boolean allsusp = true;
                    for (int i = 0; allsusp && i < nodes.length; ++i) {
                        allsusp = "suspended".equals(((IActiveComponentTreeNode)nodes[i]).getDescription().getState());
                    }
                    boolean allact = true;
                    for (int i = 0; allact && i < nodes.length; ++i) {
                        allact = "active".equals(((IActiveComponentTreeNode)nodes[i]).getDescription().getState());
                    }
                    Icon base = nodes[0].getIcon();
                    AbstractAction pkill = new AbstractAction((String)ComponentTreePanel.this.kill.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_kill")}) : (Icon)ComponentTreePanel.this.kill.getValue("SmallIcon"))){

                        public void actionPerformed(ActionEvent e) {
                            ComponentTreePanel.this.kill.actionPerformed(e);
                        }
                    };
                    ret.add(pkill);
                    if (allproxy) {
                        AbstractAction prkill = new AbstractAction((String)ComponentTreePanel.this.proxykill.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_kill")}) : (Icon)ComponentTreePanel.this.proxykill.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                ComponentTreePanel.this.proxykill.actionPerformed(e);
                            }
                        };
                        ret.add(prkill);
                    }
                    if (allact) {
                        AbstractAction psuspend = new AbstractAction((String)ComponentTreePanel.this.suspend.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_suspend")}) : (Icon)ComponentTreePanel.this.suspend.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                ComponentTreePanel.this.suspend.actionPerformed(e);
                            }
                        };
                        ret.add(psuspend);
                    } else if (allsusp) {
                        AbstractAction presume = new AbstractAction((String)ComponentTreePanel.this.resume.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_resume")}) : (Icon)ComponentTreePanel.this.resume.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                ComponentTreePanel.this.resume.actionPerformed(e);
                            }
                        };
                        AbstractAction pstep = new AbstractAction((String)ComponentTreePanel.this.step.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_step")}) : (Icon)ComponentTreePanel.this.step.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                ComponentTreePanel.this.step.actionPerformed(e);
                            }
                        };
                        ret.add(presume);
                        ret.add(pstep);
                    }
                }
                return ret.toArray(new Action[ret.size()]);
            }

            public Action getDefaultAction(IComponentTreeNode node) {
                return null;
            }
        });
        SServiceProvider.getServiceUpwards((IServiceProvider)provider, (Class)IComponentManagementService.class).addResultListener((IResultListener)new SwingDefaultResultListener(this){

            public void customResultAvailable(Object source, Object result) {
                ComponentTreePanel.this.cms = (IComponentManagementService)result;
                ComponentTreePanel.this.cms.getComponentDescriptions().addResultListener((IResultListener)new SwingDefaultResultListener(ComponentTreePanel.this){

                    public void customResultAvailable(Object source, Object result) {
                        IComponentDescription[] descriptions = (IComponentDescription[])result;
                        IComponentDescription root = null;
                        for (int i = 0; root == null && i < descriptions.length; ++i) {
                            if (descriptions[i].getParent() != null) continue;
                            root = descriptions[i];
                        }
                        ComponentTreePanel.this.model.setRoot(new ComponentTreeNode(null, ComponentTreePanel.this.model, ComponentTreePanel.this.tree, root, ComponentTreePanel.this.cms, cic));
                        TreeExpansionHandler teh = new TreeExpansionHandler(ComponentTreePanel.this.tree);
                        teh.treeExpanded(new TreeExpansionEvent(ComponentTreePanel.this.tree, new TreePath(ComponentTreePanel.this.model.getRoot())));
                    }
                });
                ComponentTreePanel.this.cms.addComponentListener(null, ComponentTreePanel.this.listener);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (ComponentTreePanel.this.tree.getPathForLocation(e.getX(), e.getY()) == null) {
                    ComponentTreePanel.this.tree.clearSelection();
                }
            }
        });
    }

    public Action getKillAction() {
        return this.kill;
    }

    public Action getSuspendAction() {
        return this.suspend;
    }

    public Action getResumeAction() {
        return this.resume;
    }

    public Action getStepAction() {
        return this.step;
    }

    public Action getRefreshAction() {
        return this.refresh;
    }

    public Action getRefreshTreeAction() {
        return this.refreshtree;
    }

    public Action getShowPropertiesAction() {
        return this.showprops;
    }

    public Action getShowObjectDetailsAction() {
        return this.showobject;
    }

    public void addNodeHandler(INodeHandler handler) {
        this.model.addNodeHandler(handler);
    }

    public ComponentTreeModel getModel() {
        return this.model;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void dispose() {
        SServiceProvider.getServiceUpwards((IServiceProvider)this.provider, (Class)IComponentManagementService.class).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                ComponentTreePanel.this.cms = (IComponentManagementService)result;
                ComponentTreePanel.this.cms.removeComponentListener(null, ComponentTreePanel.this.listener);
            }

            public void customExceptionOccurred(Object source, Exception exception) {
            }
        });
        this.getModel().dispose();
    }

    public void showProperties(JComponent content) {
        int currentloc;
        this.proppanel.setViewportView(content);
        this.proppanel.repaint();
        Insets insets = this.getInsets();
        int lastloc = this.getLastDividerLocation();
        int newloc = currentloc = this.getUI().getDividerLocation(this);
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        boolean adjust = false;
        if (this.getOrientation() == 0) {
            if (currentloc >= this.getHeight() - insets.bottom - divider.getHeight()) {
                adjust = true;
                int maxloc = this.getMaximumDividerLocation();
                newloc = lastloc >= 0 && lastloc < maxloc ? lastloc : maxloc * 1 / 2;
            }
        } else if (currentloc >= this.getWidth() - insets.right - divider.getWidth()) {
            adjust = true;
            int maxloc = this.getMaximumDividerLocation();
            int n = newloc = lastloc >= 0 && lastloc < maxloc ? lastloc : maxloc * 1 / 2;
        }
        if (adjust && currentloc != newloc) {
            this.setDividerLocation(newloc);
            this.setLastDividerLocation(currentloc);
        }
    }
}

