/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.INodeHandler;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ComponentTreePopupListener
extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
        this.doPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.doPopup(e);
    }

    public void mouseClicked(MouseEvent e) {
        ComponentTreeModel model;
        INodeHandler[] handlers;
        JTree tree;
        TreePath[] paths;
        if (!this.doPopup(e) && e.getClickCount() == 2 && (paths = (tree = (JTree)e.getSource()).getSelectionPaths()) != null && (handlers = (model = (ComponentTreeModel)tree.getModel()).getNodeHandlers()) != null) {
            for (int i = 0; paths != null && i < paths.length; ++i) {
                ActionListener a = null;
                for (int j = handlers.length - 1; a == null && j >= 0; --j) {
                    a = handlers[j].getDefaultAction((IComponentTreeNode)paths[i].getLastPathComponent());
                }
                if (a == null) continue;
                a.actionPerformed(new ActionEvent(tree, 0, null));
            }
        }
    }

    protected boolean doPopup(MouseEvent e) {
        JTree tree;
        int row;
        boolean ret = false;
        if (e.isPopupTrigger() && (row = (tree = (JTree)e.getSource()).getRowForLocation(e.getX(), e.getY())) != -1) {
            TreePath[] paths;
            int[] selrows = tree.getSelectionRows();
            boolean newsel = true;
            for (int i = 0; newsel && selrows != null && i < selrows.length; ++i) {
                if (selrows[i] != row) continue;
                newsel = false;
            }
            if (newsel) {
                tree.clearSelection();
                tree.addSelectionRow(row);
            }
            if ((paths = tree.getSelectionPaths()) != null) {
                IComponentTreeNode[] nodes = new IComponentTreeNode[paths.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = (IComponentTreeNode)paths[i].getLastPathComponent();
                }
                ComponentTreeModel model = (ComponentTreeModel)tree.getModel();
                INodeHandler[] handlers = model.getNodeHandlers();
                if (handlers != null) {
                    ArrayList<Object> actions = null;
                    for (int i = handlers.length - 1; i >= 0; --i) {
                        Action[] acts = handlers[i].getPopupActions(nodes);
                        if (acts == null || acts.length <= 0) continue;
                        if (actions == null) {
                            actions = new ArrayList<Object>();
                        }
                        if (!actions.isEmpty() && !(actions.get(actions.size() - 1) instanceof JPopupMenu.Separator)) {
                            actions.add(new JPopupMenu.Separator());
                        }
                        actions.addAll(Arrays.asList(acts));
                    }
                    if (actions != null) {
                        JPopupMenu menu = new JPopupMenu("Actions");
                        for (int i = 0; i < actions.size(); ++i) {
                            if (actions.get(i) instanceof JPopupMenu.Separator) {
                                menu.add((JPopupMenu.Separator)actions.get(i));
                                continue;
                            }
                            JMenuItem item = new JMenuItem((Action)actions.get(i));
                            menu.add(item);
                        }
                        Point loc = tree.getPopupLocation(e);
                        if (loc == null) {
                            loc = e.getPoint();
                        }
                        menu.show(tree, loc.x, loc.y);
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }
}

