/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.ComponentTreeNode;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.ServiceContainerNode;
import jadex.base.gui.componenttree.ServiceNode;
import jadex.base.gui.componenttree.VirtualComponentTreeNode;
import jadex.base.service.remote.ProxyAgent;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.commons.Future;
import jadex.commons.ICommand;
import jadex.commons.IFuture;
import jadex.commons.SGUI;
import jadex.commons.concurrent.DelegationResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.gui.CombiIcon;
import jadex.commons.service.IService;
import jadex.micro.IMicroExternalAccess;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIDefaults;

public class ProxyComponentTreeNode
extends ComponentTreeNode {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"overlay_proxy_noconnection", SGUI.makeIcon((Class)ProxyComponentTreeNode.class, (String)"/jadex/base/gui/images/overlay_proxy_noconnection.png"), "overlay_proxy_connection", SGUI.makeIcon((Class)ProxyComponentTreeNode.class, (String)"/jadex/base/gui/images/overlay_proxy_connection.png")});
    protected IComponentIdentifier cid;
    protected boolean connected = false;
    protected Timer timer = new Timer(10000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ProxyComponentTreeNode.this.refresh(true, false);
        }
    });

    public ProxyComponentTreeNode(IComponentTreeNode parent, ComponentTreeModel model, JTree tree, IComponentDescription desc, IComponentManagementService cms, ComponentIconCache iconcache) {
        super(parent, model, tree, desc, cms, iconcache);
        this.timer.start();
    }

    public void dispose() {
        this.timer.stop();
    }

    public Icon getIcon() {
        CombiIcon ret = null;
        Icon base = super.getIcon();
        if (base != null) {
            ret = new CombiIcon(new Icon[]{base, this.connected ? icons.getIcon("overlay_proxy_connection") : icons.getIcon("overlay_proxy_noconnection")});
        }
        return ret;
    }

    protected void searchChildren(final boolean force) {
        this.getRemoteComponentIdentifier().addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                final Future future = new Future();
                ProxyComponentTreeNode.searchChildren(ProxyComponentTreeNode.this.cms, ProxyComponentTreeNode.this, ProxyComponentTreeNode.this.desc, ProxyComponentTreeNode.this.cid, ProxyComponentTreeNode.this.iconcache, future, force).addResultListener((IResultListener)new SwingDefaultResultListener(){

                    public void customResultAvailable(Object source, Object result) {
                        ProxyComponentTreeNode.this.setChildren((List)result).addResultListener((IResultListener)new DelegationResultListener(future));
                        (this).ProxyComponentTreeNode.this.connected = true;
                    }

                    public void customExceptionOccurred(Object source, Exception exception) {
                        ProxyComponentTreeNode.this.setChildren(Collections.EMPTY_LIST);
                        (this).ProxyComponentTreeNode.this.connected = false;
                    }
                });
            }

            public void customExceptionOccurred(Object source, Exception exception) {
                ProxyComponentTreeNode.this.setChildren(Collections.EMPTY_LIST);
                ProxyComponentTreeNode.this.connected = false;
            }
        });
    }

    public String toString() {
        return this.cid == null ? this.desc.getName().getLocalName() : this.desc.getName().getLocalName() + "(" + this.cid + ")";
    }

    protected static IFuture searchChildren(final IComponentManagementService cms, final IComponentTreeNode parentnode, final IComponentDescription desc, final IComponentIdentifier cid, final ComponentIconCache iconcache, final Future future, final boolean force) {
        final Future ret = new Future();
        final ArrayList children = new ArrayList();
        final boolean[] ready = new boolean[2];
        IComponentTreeNode tmp = parentnode;
        while (!(tmp instanceof ProxyComponentTreeNode)) {
            tmp = tmp.getParent();
        }
        final ProxyComponentTreeNode proxy = (ProxyComponentTreeNode)tmp;
        cms.getExternalAccess(proxy.getDescription().getName()).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IMicroExternalAccess exta = (IMicroExternalAccess)result;
                exta.scheduleStep(new ICommand(){

                    public void execute(Object agent) {
                        ProxyAgent pa = (ProxyAgent)((Object)agent);
                        pa.getVirtualChildren(cid, force).addResultListener((IResultListener)new SwingDefaultResultListener(){

                            public void customResultAvailable(Object source, Object result) {
                                IComponentDescription[] descs = ((Collection)result).toArray(new IComponentDescription[((Collection)result).size()]);
                                for (int i = 0; i < descs.length; ++i) {
                                    IComponentTreeNode node = proxy.getModel().getNode(descs[i].getName());
                                    if (node == null) {
                                        node = new VirtualComponentTreeNode(parentnode, proxy.getModel(), proxy.getTree(), descs[i], cms, iconcache);
                                    }
                                    children.add(node);
                                }
                                ((this).this).ready[0] = true;
                                if (ready[0] && ready[1]) {
                                    ret.setResult((Object)children);
                                }
                            }

                            public void customExceptionOccurred(Object source, Exception exception) {
                                ret.setExceptionIfUndone(exception);
                            }
                        });
                    }
                });
                exta.scheduleStep(new ICommand(){

                    public void execute(Object agent) {
                        ProxyAgent pa = (ProxyAgent)((Object)agent);
                        pa.getRemoteServices(cid).addResultListener((IResultListener)new SwingDefaultResultListener(){

                            public void customResultAvailable(Object source, Object result) {
                                List services = (List)result;
                                if (services != null && !services.isEmpty()) {
                                    ServiceContainerNode scn = (ServiceContainerNode)proxy.getModel().getNode(desc.getName().getName() + "ServiceContainer");
                                    if (scn == null) {
                                        scn = new ServiceContainerNode(parentnode, proxy.getModel(), proxy.getTree(), null);
                                    }
                                    children.add(0, scn);
                                    final ArrayList<ServiceNode> subchildren = new ArrayList<ServiceNode>();
                                    for (int i = 0; i < services.size(); ++i) {
                                        IService service = (IService)services.get(i);
                                        ServiceNode sn = (ServiceNode)proxy.getModel().getNode(service.getServiceIdentifier());
                                        if (sn == null) {
                                            sn = new ServiceNode(scn, proxy.getModel(), proxy.getTree(), service);
                                        }
                                        subchildren.add(sn);
                                    }
                                    final ServiceContainerNode node = scn;
                                    future.addResultListener((IResultListener)new SwingDefaultResultListener(){

                                        public void customResultAvailable(Object source, Object result) {
                                            node.setChildren(subchildren);
                                        }

                                        public void customExceptionOccurred(Object source, Exception exception) {
                                        }
                                    });
                                }
                                ((this).this).ready[1] = true;
                                if (ready[0] && ready[1]) {
                                    ret.setResult((Object)children);
                                }
                            }

                            public void customExceptionOccurred(Object source, Exception exception) {
                                ret.setExceptionIfUndone(exception);
                            }
                        });
                    }
                });
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public IFuture getRemoteComponentIdentifier() {
        final Future ret = new Future();
        if (this.cid == null) {
            this.cms.getExternalAccess(this.desc.getName()).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    IMicroExternalAccess exta = (IMicroExternalAccess)result;
                    exta.scheduleStep(new ICommand(){

                        public void execute(Object agent) {
                            ProxyAgent pa = (ProxyAgent)((Object)agent);
                            (this).ProxyComponentTreeNode.this.cid = pa.getRemotePlatformIdentifier();
                            ret.setResult((Object)(this).ProxyComponentTreeNode.this.cid);
                        }
                    });
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            ret.setResult((Object)this.cid);
        }
        return ret;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

