/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.AbstractComponentTreeNode;
import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.ServiceProperties;
import jadex.commons.SGUI;
import jadex.commons.SReflect;
import jadex.commons.service.IService;
import java.lang.reflect.Proxy;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIDefaults;

public class ServiceNode
extends AbstractComponentTreeNode {
    private static final UIDefaults icons = new UIDefaults(new Object[]{"service", SGUI.makeIcon((Class)ServiceNode.class, (String)"/jadex/base/gui/images/configure_16.png")});
    private final IService service;
    protected ServiceProperties propcomp;

    public ServiceNode(IComponentTreeNode parent, ComponentTreeModel model, JTree tree, IService service) {
        super(parent, model, tree);
        this.service = service;
        model.registerNode(this);
    }

    public IService getService() {
        return this.service;
    }

    public Object getId() {
        return this.service.getServiceIdentifier();
    }

    public Icon getIcon() {
        return icons.getIcon("service");
    }

    protected void searchChildren(boolean force) {
    }

    public String toString() {
        return Proxy.isProxyClass(this.service.getClass()) ? SReflect.getUnqualifiedClassName((Class)this.service.getServiceIdentifier().getServiceType()) + " (" + this.service.getServiceIdentifier().getProviderId() + ")" : SReflect.getUnqualifiedClassName(this.service.getClass());
    }

    public boolean hasProperties() {
        return true;
    }

    public JComponent getPropertiesComponent() {
        if (this.propcomp == null) {
            this.propcomp = new ServiceProperties();
        }
        this.propcomp.setService(this.service);
        return this.propcomp;
    }
}

