/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.PropertiesPanel;
import jadex.commons.SGUI;
import jadex.commons.SReflect;
import jadex.commons.jtable.ResizeableTableHeader;
import jadex.commons.service.IService;
import jadex.commons.service.IServiceIdentifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class ServiceProperties
extends PropertiesPanel {
    public ServiceProperties() {
        super(" Service Properties ");
        this.createTextField("Name");
        this.createTextField("Type");
        this.createTextField("Provider");
        this.addFullLineComponent("Methods_label", new JLabel("Methods"));
        JTable table = SGUI.createReadOnlyTable();
        table.setTableHeader((JTableHeader)new ResizeableTableHeader(table.getColumnModel()));
        JPanel scroll = new JPanel(new BorderLayout());
        scroll.add((Component)table, "Center");
        scroll.add((Component)table.getTableHeader(), "North");
        this.addFullLineComponent("Methods", scroll);
    }

    public void setService(IService service) {
        IServiceIdentifier sid = service.getServiceIdentifier();
        this.getTextField("Name").setText(sid.getServiceName());
        this.getTextField("Type").setText(sid.getServiceType().getName());
        this.getTextField("Provider").setText(sid.getProviderId().toString());
        JTable list = (JTable)this.getComponent("Methods").getComponent(0);
        Method[] methods = sid.getServiceType().getMethods();
        Object[] returntypes = new String[methods.length];
        Object[] names = new String[methods.length];
        Object[] parameters = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            returntypes[i] = SReflect.getUnqualifiedClassName(methods[i].getReturnType());
            names[i] = methods[i].getName();
            Class<?>[] params = methods[i].getParameterTypes();
            String pstring = "";
            for (int j = 0; j < params.length; ++j) {
                pstring = j == 0 ? SReflect.getUnqualifiedClassName(params[j]) : pstring + ", " + SReflect.getUnqualifiedClassName(params[j]);
            }
            parameters[i] = pstring;
        }
        DefaultTableModel dtm = new DefaultTableModel();
        dtm.addColumn((Object)"Return Type", returntypes);
        dtm.addColumn((Object)"Method Name", names);
        dtm.addColumn((Object)"Parameters", parameters);
        list.setModel(dtm);
    }
}

