/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componenttree;

import jadex.base.gui.componenttree.AbstractComponentTreeNode;
import jadex.base.gui.componenttree.ComponentIconCache;
import jadex.base.gui.componenttree.ComponentProperties;
import jadex.base.gui.componenttree.ComponentTreeModel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.ProxyComponentTreeNode;
import jadex.base.service.remote.ProxyAgent;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.commons.Future;
import jadex.commons.ICommand;
import jadex.commons.concurrent.DelegationResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.micro.IMicroExternalAccess;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;

public class VirtualComponentTreeNode
extends AbstractComponentTreeNode
implements IActiveComponentTreeNode {
    protected IComponentDescription desc;
    protected final IComponentManagementService cms;
    protected final ComponentIconCache iconcache;
    protected IExternalAccess proxy;
    protected ComponentProperties propcomp;

    public VirtualComponentTreeNode(IComponentTreeNode parent, ComponentTreeModel model, JTree tree, IComponentDescription desc, IComponentManagementService cms, ComponentIconCache iconcache) {
        super(parent, model, tree);
        this.desc = desc;
        this.cms = cms;
        this.iconcache = iconcache;
        model.registerNode(this);
    }

    protected void searchChildren(boolean force) {
        final Future future = new Future();
        ProxyComponentTreeNode.searchChildren(this.cms, this, this.desc, this.desc.getName(), this.iconcache, future, force).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                VirtualComponentTreeNode.this.setChildren((List)result).addResultListener((IResultListener)new DelegationResultListener(future));
            }

            public void customExceptionOccurred(Object source, Exception exception) {
                VirtualComponentTreeNode.this.setChildren(Collections.EMPTY_LIST);
            }
        });
    }

    public void refresh(boolean recurse, boolean force) {
        IComponentTreeNode tmp = this.getParent();
        while (!(tmp instanceof ProxyComponentTreeNode)) {
            tmp = tmp.getParent();
        }
        ProxyComponentTreeNode proxy = (ProxyComponentTreeNode)tmp;
        this.cms.getExternalAccess(proxy.getDescription().getName()).addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object source, Object result) {
                IMicroExternalAccess exta = (IMicroExternalAccess)result;
                exta.scheduleStep(new ICommand(){

                    public void execute(Object agent) {
                        ProxyAgent pa = (ProxyAgent)((Object)agent);
                        pa.getRemoteComponentDescription((this).VirtualComponentTreeNode.this.desc.getName()).addResultListener((IResultListener)new SwingDefaultResultListener(){

                            public void customResultAvailable(Object source, Object result) {
                                VirtualComponentTreeNode.this.setDescription((IComponentDescription)result);
                                VirtualComponentTreeNode.this.getModel().fireNodeChanged(VirtualComponentTreeNode.this);
                            }

                            public void customExceptionOccurred(Object source, Exception exception) {
                                AbstractComponentTreeNode parent = (AbstractComponentTreeNode)VirtualComponentTreeNode.this.getParent();
                                parent.removeChild(VirtualComponentTreeNode.this);
                            }
                        });
                    }
                });
            }

            public void customExceptionOccurred(Object source, Exception exception) {
                AbstractComponentTreeNode parent = (AbstractComponentTreeNode)VirtualComponentTreeNode.this.getParent();
                parent.removeChild(VirtualComponentTreeNode.this);
            }
        });
        super.refresh(recurse, force);
    }

    public Object getId() {
        return this.desc.getName();
    }

    public Icon getIcon() {
        return this.iconcache.getIcon(this, this.desc.getType());
    }

    public IComponentDescription getDescription() {
        return this.desc;
    }

    public String toString() {
        return this.desc.getName().toString();
    }

    public void setDescription(IComponentDescription desc) {
        this.desc = desc;
        if (this.propcomp != null) {
            this.propcomp.setDescription(desc);
            this.propcomp.repaint();
        }
    }

    public boolean hasProperties() {
        return true;
    }

    public JComponent getPropertiesComponent() {
        if (this.propcomp == null) {
            this.propcomp = new ComponentProperties();
        }
        this.propcomp.setDescription(this.desc);
        return this.propcomp;
    }
}

