/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componentviewer;

import jadex.base.gui.componenttree.ComponentTreePanel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.componenttree.IComponentTreeNode;
import jadex.base.gui.componenttree.INodeHandler;
import jadex.base.gui.componenttree.INodeListener;
import jadex.base.gui.componenttree.ServiceNode;
import jadex.base.gui.componentviewer.IAbstractViewerPanel;
import jadex.base.gui.componentviewer.IComponentViewerPanel;
import jadex.base.gui.componentviewer.IServiceViewerPanel;
import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.commons.Properties;
import jadex.commons.SGUI;
import jadex.commons.SReflect;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.gui.CombiIcon;
import jadex.commons.gui.ObjectCardLayout;
import jadex.commons.service.IService;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.commons.service.library.ILibraryService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ComponentViewerPlugin
extends AbstractJCCPlugin {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"componentviewer", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/base/gui/images/configure.png"), "componentviewer_sel", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/tools/common/images/configure_sel.png"), "open_viewer", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/base/gui/images/new_introspector.png"), "close_viewer", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/base/gui/images/close_introspector.png"), "viewer_empty", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/base/gui/images/viewer_empty.png"), "overlay_viewable", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/base/gui/images/overlay_edit.png"), "overlay_viewed", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/base/gui/images/overlay_introspected.png"), "overlay_notviewed", SGUI.makeIcon((Class)ComponentViewerPlugin.class, (String)"/jadex/base/gui/images/overlay_notintrospected.png")});
    protected JSplitPane split;
    protected ComponentTreePanel comptree;
    protected JPanel detail;
    protected ObjectCardLayout cards;
    protected Map panels;
    protected Properties props;
    protected Map viewables;
    final AbstractAction START_VIEWER = new AbstractAction("Open service viewer", icons.getIcon("open_viewer")){

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ComponentViewerPlugin.this.comptree.getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                IComponentTreeNode node;
                if (!ComponentViewerPlugin.this.isNodeViewable((IComponentTreeNode)paths[i].getLastPathComponent())) continue;
                Object tmp = paths[i].getLastPathComponent();
                if (tmp instanceof ServiceNode) {
                    node = (ServiceNode)tmp;
                    final IService service = ((ServiceNode)node).getService();
                    final String classname = (String)service.getPropertyMap().get("componentviewer.viewerclass");
                    if (classname == null) continue;
                    SServiceProvider.getService((IServiceProvider)ComponentViewerPlugin.this.getJCC().getServiceProvider(), (Class)(class$jadex$commons$service$library$ILibraryService == null ? ComponentViewerPlugin.class$("jadex.commons.service.library.ILibraryService") : class$jadex$commons$service$library$ILibraryService)).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentViewerPlugin.this.comptree, (ServiceNode)node){
                        private final /* synthetic */ ServiceNode val$node;
                        {
                            this.val$node = serviceNode;
                            super(x0);
                        }

                        public void customResultAvailable(Object source, Object result) {
                            ILibraryService libservice = (ILibraryService)result;
                            try {
                                ComponentViewerPlugin.this.storeCurrentPanelSettings();
                                Class clazz = SReflect.classForName((String)classname, (ClassLoader)libservice.getClassLoader());
                                final IServiceViewerPanel panel = (IServiceViewerPanel)clazz.newInstance();
                                panel.init(ComponentViewerPlugin.this.getJCC(), service).addResultListener((IResultListener)new SwingDefaultResultListener((this).ComponentViewerPlugin.this.comptree){

                                    public void customResultAvailable(Object source, Object result) {
                                        Properties sub = ((this).this).ComponentViewerPlugin.this.props != null ? ((this).this).ComponentViewerPlugin.this.props.getSubproperty(panel.getId()) : null;
                                        panel.setProperties(sub);
                                        JComponent comp = panel.getComponent();
                                        ((this).this).ComponentViewerPlugin.this.panels.put(service.getServiceIdentifier(), panel);
                                        ((this).this).ComponentViewerPlugin.this.detail.add((Component)comp, service.getServiceIdentifier());
                                        ((this).this).ComponentViewerPlugin.this.comptree.getModel().fireNodeChanged(val$node);
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ComponentViewerPlugin.this.getJCC().displayError("Error initializing service viewer panel.", "Service viewer panel class: " + classname, e);
                            }
                        }
                    });
                    continue;
                }
                if (!(tmp instanceof IActiveComponentTreeNode)) continue;
                node = (IActiveComponentTreeNode)tmp;
                final IComponentIdentifier cid = node.getDescription().getName();
                SServiceProvider.getService((IServiceProvider)ComponentViewerPlugin.this.getJCC().getServiceProvider(), (Class)(class$jadex$bridge$IComponentManagementService == null ? ComponentViewerPlugin.class$("jadex.bridge.IComponentManagementService") : class$jadex$bridge$IComponentManagementService)).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentViewerPlugin.this.comptree, (IActiveComponentTreeNode)node){
                    private final /* synthetic */ IActiveComponentTreeNode val$node;
                    {
                        this.val$node = iActiveComponentTreeNode;
                        super(x0);
                    }

                    public void customResultAvailable(Object source, Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        cms.getExternalAccess(cid).addResultListener((IResultListener)new SwingDefaultResultListener((this).ComponentViewerPlugin.this.comptree){

                            public void customResultAvailable(Object source, Object result) {
                                final IExternalAccess exta = (IExternalAccess)result;
                                final String classname = (String)exta.getModel().getProperties().get("componentviewer.viewerclass");
                                if (classname != null) {
                                    SServiceProvider.getService((IServiceProvider)ComponentViewerPlugin.this.getJCC().getServiceProvider(), (Class)(class$jadex$commons$service$library$ILibraryService == null ? (class$jadex$commons$service$library$ILibraryService = ComponentViewerPlugin.class$("jadex.commons.service.library.ILibraryService")) : class$jadex$commons$service$library$ILibraryService)).addResultListener((IResultListener)new SwingDefaultResultListener(((this).this).ComponentViewerPlugin.this.comptree){

                                        public void customResultAvailable(Object source, Object result) {
                                            ILibraryService libservice = (ILibraryService)result;
                                            try {
                                                ComponentViewerPlugin.this.storeCurrentPanelSettings();
                                                Class clazz = SReflect.classForName((String)classname, (ClassLoader)libservice.getClassLoader());
                                                final IComponentViewerPanel panel = (IComponentViewerPanel)clazz.newInstance();
                                                panel.init(ComponentViewerPlugin.this.getJCC(), exta).addResultListener((IResultListener)new SwingDefaultResultListener((((this).this).this).ComponentViewerPlugin.this.comptree){

                                                    public void customResultAvailable(Object source, Object result) {
                                                        Properties sub = ((((this).this).this).this).ComponentViewerPlugin.this.props != null ? ((((this).this).this).this).ComponentViewerPlugin.this.props.getSubproperty(panel.getId()) : null;
                                                        panel.setProperties(sub);
                                                        JComponent comp = panel.getComponent();
                                                        ((((this).this).this).this).ComponentViewerPlugin.this.panels.put(exta.getComponentIdentifier(), panel);
                                                        ((((this).this).this).this).ComponentViewerPlugin.this.detail.add((Component)comp, exta.getComponentIdentifier());
                                                        ((((this).this).this).this).ComponentViewerPlugin.this.comptree.getModel().fireNodeChanged(val$node);
                                                    }
                                                });
                                            }
                                            catch (Exception e) {
                                                ComponentViewerPlugin.this.getJCC().displayError("Error initializing service viewer panel.", "Service viewer panel class: " + classname, e);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        }
    };
    final AbstractAction STOP_VIEWER = new AbstractAction("Close service viewer", icons.getIcon("close_viewer")){

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ComponentViewerPlugin.this.comptree.getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                if (!ComponentViewerPlugin.this.isNodeViewable((IComponentTreeNode)paths[i].getLastPathComponent())) continue;
                ComponentViewerPlugin.this.storeCurrentPanelSettings();
                final IComponentTreeNode node = (IComponentTreeNode)paths[i].getLastPathComponent();
                Object nodeid = node.getId();
                ComponentViewerPlugin.this.detail.remove(ComponentViewerPlugin.this.cards.getComponent(nodeid));
                IAbstractViewerPanel panel = (IAbstractViewerPanel)ComponentViewerPlugin.this.panels.remove(nodeid);
                panel.shutdown().addResultListener((IResultListener)new SwingDefaultResultListener(ComponentViewerPlugin.this.comptree){

                    public void customResultAvailable(Object source, Object result) {
                        (this).ComponentViewerPlugin.this.comptree.getModel().fireNodeChanged(node);
                    }
                });
            }
        }
    };
    static /* synthetic */ Class class$jadex$commons$service$library$ILibraryService;

    public ComponentViewerPlugin() {
        this.panels = new HashMap();
        this.viewables = Collections.synchronizedMap(new HashMap());
    }

    public String getName() {
        return "Service Viewer";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("componentviewer_sel") : icons.getIcon("componentviewer");
    }

    public JComponent[] createToolBar() {
        JButton b1 = new JButton(this.START_VIEWER);
        b1.setBorder(null);
        b1.setToolTipText(b1.getText());
        b1.setText(null);
        b1.setEnabled(true);
        JButton b2 = new JButton(this.STOP_VIEWER);
        b2.setBorder(null);
        b2.setToolTipText(b2.getText());
        b2.setText(null);
        b2.setEnabled(true);
        return new JComponent[]{b1, b2};
    }

    public JComponent createView() {
        this.split = new JSplitPane(1, true);
        this.split.setOneTouchExpandable(true);
        this.comptree = new ComponentTreePanel(this.getJCC().getServiceProvider());
        this.comptree.setMinimumSize(new Dimension(0, 0));
        this.split.add(this.comptree);
        this.comptree.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                IComponentTreeNode node;
                Object nodeid;
                JTree tree = ComponentViewerPlugin.this.comptree.getTree();
                if (tree.getSelectionPath() != null && (nodeid = (node = (IComponentTreeNode)tree.getSelectionPath().getLastPathComponent()).getId()) != null && ComponentViewerPlugin.this.cards.getComponent(nodeid) != null) {
                    ComponentViewerPlugin.this.storeCurrentPanelSettings();
                    IAbstractViewerPanel panel = (IAbstractViewerPanel)ComponentViewerPlugin.this.panels.get(nodeid);
                    panel.setProperties(ComponentViewerPlugin.this.props != null ? ComponentViewerPlugin.this.props.getSubproperty(panel.getId()) : null);
                    ComponentViewerPlugin.this.cards.show(nodeid);
                }
            }
        });
        this.comptree.addNodeHandler(new INodeHandler(){

            public Action[] getPopupActions(IComponentTreeNode[] nodes) {
                Action[] ret = null;
                boolean allviewable = true;
                for (int i = 0; allviewable && i < nodes.length; ++i) {
                    allviewable = ComponentViewerPlugin.this.isNodeViewable(nodes[i]);
                }
                if (allviewable) {
                    boolean allob = true;
                    for (int i = 0; allob && i < nodes.length; ++i) {
                        allob = ComponentViewerPlugin.this.cards.getComponent(nodes[i].getId()) != null;
                    }
                    boolean allig = true;
                    for (int i = 0; allig && i < nodes.length; ++i) {
                        allig = ComponentViewerPlugin.this.cards.getComponent(nodes[i].getId()) == null;
                    }
                    if (allig) {
                        Icon base = nodes[0].getIcon();
                        AbstractAction a = new AbstractAction((String)ComponentViewerPlugin.this.START_VIEWER.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_viewed")}) : (Icon)ComponentViewerPlugin.this.START_VIEWER.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                (this).ComponentViewerPlugin.this.START_VIEWER.actionPerformed(e);
                            }
                        };
                        ret = new Action[]{a};
                    } else if (allob) {
                        Icon base = nodes[0].getIcon();
                        AbstractAction a = new AbstractAction((String)ComponentViewerPlugin.this.STOP_VIEWER.getValue("Name"), (Icon)(base != null ? new CombiIcon(new Icon[]{base, icons.getIcon("overlay_notviewed")}) : (Icon)ComponentViewerPlugin.this.STOP_VIEWER.getValue("SmallIcon"))){

                            public void actionPerformed(ActionEvent e) {
                                (this).ComponentViewerPlugin.this.STOP_VIEWER.actionPerformed(e);
                            }
                        };
                        ret = new Action[]{a};
                    }
                }
                return ret;
            }

            public Icon getOverlay(IComponentTreeNode node) {
                Icon ret = null;
                if (ComponentViewerPlugin.this.cards.getComponent(node.getId()) != null) {
                    ret = icons.getIcon("overlay_viewed");
                } else if (ComponentViewerPlugin.this.isNodeViewable(node)) {
                    ret = icons.getIcon("overlay_viewable");
                }
                return ret;
            }

            public Action getDefaultAction(IComponentTreeNode node) {
                AbstractAction a = null;
                if (ComponentViewerPlugin.this.cards.getComponent(node.getId()) != null) {
                    a = ComponentViewerPlugin.this.STOP_VIEWER;
                } else if (ComponentViewerPlugin.this.isNodeViewable(node)) {
                    a = ComponentViewerPlugin.this.START_VIEWER;
                }
                return a;
            }
        });
        JLabel emptylabel = new JLabel("Select vieweable components or services to activate the viewer", icons.getIcon("viewer_empty"), 0);
        emptylabel.setVerticalAlignment(0);
        emptylabel.setHorizontalTextPosition(0);
        emptylabel.setVerticalTextPosition(3);
        emptylabel.setFont(emptylabel.getFont().deriveFont((float)emptylabel.getFont().getSize() * 1.3f));
        this.cards = new ObjectCardLayout();
        this.detail = new JPanel((LayoutManager)this.cards);
        this.detail.setMinimumSize(new Dimension(0, 0));
        this.detail.add("jtc_ocl_default_component", emptylabel);
        this.split.add(this.detail);
        this.split.setDividerLocation(150);
        this.comptree.getModel().addNodeListener(new INodeListener(){

            public void nodeRemoved(IComponentTreeNode node) {
                Object nodeid = node.getId();
                if (ComponentViewerPlugin.this.panels.containsKey(nodeid)) {
                    ComponentViewerPlugin.this.storeCurrentPanelSettings();
                    ComponentViewerPlugin.this.detail.remove(ComponentViewerPlugin.this.cards.getComponent(nodeid));
                    IAbstractViewerPanel panel = (IAbstractViewerPanel)ComponentViewerPlugin.this.panels.remove(nodeid);
                    panel.shutdown();
                    ComponentViewerPlugin.this.comptree.getModel().fireNodeChanged(node);
                }
            }

            public void nodeAdded(IComponentTreeNode node) {
            }
        });
        return this.split;
    }

    public String getHelpID() {
        return "tools.componentviewer";
    }

    protected boolean isNodeViewable(final IComponentTreeNode node) {
        boolean ret = false;
        if (node instanceof ServiceNode) {
            ret = ((ServiceNode)node).getService().getPropertyMap().get("componentviewer.viewerclass") != null;
        } else if (node instanceof IActiveComponentTreeNode) {
            final IComponentIdentifier cid = ((IActiveComponentTreeNode)node).getDescription().getName();
            Boolean viewable = (Boolean)this.viewables.get(cid);
            if (viewable != null) {
                ret = viewable;
            } else {
                SServiceProvider.getService((IServiceProvider)this.getJCC().getServiceProvider(), (Class)IComponentManagementService.class).addResultListener((IResultListener)new SwingDefaultResultListener(this.comptree){

                    public void customResultAvailable(Object source, Object result) {
                        IComponentManagementService cms = (IComponentManagementService)result;
                        cms.getExternalAccess(cid).addResultListener((IResultListener)new SwingDefaultResultListener(ComponentViewerPlugin.this.comptree){

                            public void customResultAvailable(Object source, Object result) {
                                IExternalAccess exta = (IExternalAccess)result;
                                String classname = (String)exta.getModel().getProperties().get("componentviewer.viewerclass");
                                (this).ComponentViewerPlugin.this.viewables.put(cid, classname == null ? Boolean.FALSE : Boolean.TRUE);
                                node.refresh(false, false);
                            }
                        });
                    }
                });
            }
        }
        return ret;
    }

    public Properties getProperties() {
        this.storeCurrentPanelSettings();
        return this.props;
    }

    public void setProperties(Properties ps) {
        this.props = ps;
        Iterator it = this.panels.values().iterator();
        while (it.hasNext()) {
            IAbstractViewerPanel panel = (IAbstractViewerPanel)it.next();
            Properties sub = this.props != null ? this.props.getSubproperty(panel.getId()) : null;
            panel.setProperties(sub);
        }
    }

    protected void storeCurrentPanelSettings() {
        IAbstractViewerPanel panel;
        Object old = this.cards.getCurrentKey();
        if (old != null && (panel = (IAbstractViewerPanel)this.panels.get(old)) != null) {
            if (this.props == null) {
                this.props = new Properties();
            }
            Properties sub = panel.getProperties();
            this.props.removeSubproperties(panel.getId());
            if (sub != null) {
                sub.setType(panel.getId());
                this.props.addSubproperties(sub);
            }
        }
    }
}

