/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componentviewer.dfservice;

import [Ljadex.base.fipa.IDFServiceDescription;;
import [Ljava.lang.String;;
import jadex.base.fipa.IDFComponentDescription;
import jadex.base.gui.componentviewer.dfservice.ComponentIdentifierRenderer;
import jadex.base.gui.componentviewer.dfservice.ComponentTableModel;
import jadex.base.gui.componentviewer.dfservice.DFBrowserPanel;
import jadex.base.gui.componentviewer.dfservice.LeaseTimeRenderer;
import jadex.base.gui.componentviewer.dfservice.ServiceDescriptionArrayRenderer;
import jadex.base.gui.componentviewer.dfservice.StringArrayRenderer;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SGUI;
import jadex.commons.jtable.TableSorter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DFComponentTable
extends JTable {
    static final IDFComponentDescription[] EMPTY = new IDFComponentDescription[0];
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"remove_component", SGUI.makeIcon((Class)DFComponentTable.class, (String)"/jadex/base/gui/images/new_remove_service.png")});
    protected JPopupMenu popup;
    protected DFBrowserPanel panel;

    public DFComponentTable(DFBrowserPanel panel) {
        super((TableModel)new TableSorter((TableModel)new ComponentTableModel()));
        this.panel = panel;
        TableSorter sorter = (TableSorter)this.getModel();
        sorter.setTableHeader(this.getTableHeader());
        this.setPreferredScrollableViewportSize(new Dimension(800, 70));
        this.setDefaultRenderer(IComponentIdentifier.class, new ComponentIdentifierRenderer());
        this.setDefaultRenderer(String;.class, new StringArrayRenderer());
        this.setDefaultRenderer(IDFServiceDescription;.class, new ServiceDescriptionArrayRenderer());
        this.setDefaultRenderer(Date.class, new LeaseTimeRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DFComponentTable.this.popup.show(DFComponentTable.this, e.getX(), e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DFComponentTable.this.popup.show(DFComponentTable.this, e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DFComponentTable.this.popup.show(DFComponentTable.this, e.getX(), e.getY());
                }
            }
        });
        this.popup = new JPopupMenu();
        this.addMenuItems(this.popup);
    }

    protected void addMenuItems(JPopupMenu menu) {
        menu.add(new JMenuItem(new AbstractAction("Remove component description", icons.getIcon("remove_component")){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = DFComponentTable.this.getSelectedRow();
                if (selectedRow >= 0) {
                    TableSorter sorter = (TableSorter)DFComponentTable.this.getModel();
                    ComponentTableModel model = (ComponentTableModel)sorter.getTableModel();
                    DFComponentTable.this.panel.removeComponentRegistration(model.getComponentDescription(sorter.modelIndex(selectedRow)));
                }
            }
        }));
    }

    public IDFComponentDescription[] getSelectedComponents() {
        IDFComponentDescription[] ret = EMPTY;
        int count = this.getSelectedRowCount();
        if (count > 0) {
            TableSorter sorter = (TableSorter)this.getModel();
            ComponentTableModel model = (ComponentTableModel)sorter.getTableModel();
            ArrayList<IDFComponentDescription> sa = new ArrayList<IDFComponentDescription>();
            int[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                sa.add(model.getComponentDescription(sorter.modelIndex(rows[i])));
            }
            ret = sa.toArray(new IDFComponentDescription[sa.size()]);
        }
        return ret;
    }

    public void setComponentDescriptions(IDFComponentDescription[] ad) {
        TableSorter sorter = (TableSorter)this.getModel();
        ComponentTableModel model = (ComponentTableModel)sorter.getTableModel();
        model.setComponentDescriptions(ad);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        TableColumnModel cm = this.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn column = cm.getColumn(i);
            props.addProperty(new Property("columnwidth", Integer.toString(column.getWidth())));
        }
        return props;
    }

    public void setProperties(Properties props) {
        Property[] columnprops = props.getProperties("columnwidth");
        TableColumnModel cm = this.getColumnModel();
        for (int i = 0; i < cm.getColumnCount() && i < columnprops.length; ++i) {
            cm.getColumn(i).setPreferredWidth(Integer.parseInt(columnprops[i].getValue()));
        }
    }
}

