/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.gui.componentviewer.libservice;

import jadex.base.gui.componentviewer.IServiceViewerPanel;
import jadex.base.gui.plugin.IControlCenter;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.Properties;
import jadex.commons.SGUI;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.gui.EditableList;
import jadex.commons.gui.EditableListEvent;
import jadex.commons.service.IService;
import jadex.commons.service.library.ILibraryService;
import jadex.commons.service.library.ILibraryServiceListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIDefaults;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;

public class LibServiceBrowser
extends JTabbedPane
implements IServiceViewerPanel {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"help", SGUI.makeIcon((Class)LibServiceBrowser.class, (String)"/jadex/base/gui/images/help.gng")});
    protected EditableList classpaths;
    protected ILibraryService libservice;
    protected ILibraryServiceListener listener;

    public IFuture init(final IControlCenter jcc, IService service) {
        this.libservice = (ILibraryService)service;
        final JPanel classview = new JPanel(new BorderLayout());
        this.classpaths = new EditableList("Class Paths", true);
        this.fetchManagedClasspathEntries().addResultListener((IResultListener)new SwingDefaultResultListener(this){

            public void customResultAvailable(Object source, Object result) {
                List entries = (List)result;
                for (int i = 0; i < entries.size(); ++i) {
                    LibServiceBrowser.this.classpaths.addEntry((String)entries.get(i));
                }
            }
        });
        JScrollPane scroll = new JScrollPane((Component)this.classpaths);
        this.classpaths.setPreferredScrollableViewportSize(new Dimension(400, 200));
        JPanel buts = new JPanel(new GridBagLayout());
        JButton add = new JButton("Add ...");
        add.putClientProperty("auto-adjust", Boolean.TRUE);
        JButton remove = new JButton("Remove");
        remove.putClientProperty("auto-adjust", Boolean.TRUE);
        JButton ref = new JButton("Refresh");
        ref.putClientProperty("auto-adjust", Boolean.TRUE);
        add.setToolTipText("Add a class path entry");
        remove.setToolTipText("Remove one or more selected entries from the classpath");
        buts.add((Component)add, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)remove, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)ref, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        final JFileChooser cchooser = new JFileChooser(".");
        cchooser.setFileSelectionMode(2);
        cchooser.setFileFilter(new FileFilter(){

            public boolean accept(File name) {
                return name.isDirectory() || name.getName().endsWith(".jar");
            }

            public String getDescription() {
                return "*.jar";
            }
        });
        cchooser.setMultiSelectionEnabled(true);
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cchooser.showDialog(SGUI.getWindowParent((Component)classview), "Add") == 0) {
                    File[] files = cchooser.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].toURI().toURL();
                            LibServiceBrowser.this.libservice.addURL(url);
                            LibServiceBrowser.this.classpaths.addEntry(url.toString());
                            continue;
                        }
                        catch (MalformedURLException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] sel = LibServiceBrowser.this.classpaths.getSelectedRows();
                String[] entries = LibServiceBrowser.this.classpaths.getEntries();
                for (int i = 0; i < sel.length; ++i) {
                    LibServiceBrowser.this.classpaths.removeEntry(entries[sel[i]]);
                    try {
                        LibServiceBrowser.this.libservice.removeURL(new URL("file:///" + entries[sel[i]]));
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        jcc.displayError("Library error", "Could not remove url", ex);
                    }
                }
            }
        });
        ref.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibServiceBrowser.this.fetchManagedClasspathEntries().addResultListener((IResultListener)new SwingDefaultResultListener(LibServiceBrowser.this){

                    public void customResultAvailable(Object source, Object result) {
                        (this).LibServiceBrowser.this.classpaths.removeEntries();
                        List entries = (List)result;
                        for (int i = 0; i < entries.size(); ++i) {
                            (this).LibServiceBrowser.this.classpaths.addEntry((String)entries.get(i));
                        }
                    }
                });
            }
        });
        this.classpaths.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getType() == -1 && e instanceof EditableListEvent) {
                    EditableListEvent ele = (EditableListEvent)e;
                    int start = e.getFirstRow();
                    int end = e.getLastRow();
                    for (int i = 0; i <= end - start; ++i) {
                        if (ele.getData(i) == null || ((String)ele.getData(i)).length() <= 0) continue;
                        try {
                            LibServiceBrowser.this.libservice.removeURL(new URL(ele.getData(i).toString()));
                            continue;
                        }
                        catch (MalformedURLException ex) {
                            jcc.displayError("Library error", "Could not remove url", ex);
                        }
                    }
                }
            }
        });
        classview.add("Center", scroll);
        classview.add("South", buts);
        JPanel otherview = new JPanel(new BorderLayout());
        final DefaultListModel dlm = new DefaultListModel();
        this.fetchOtherClasspathEntries(this.libservice).addResultListener((IResultListener)new SwingDefaultResultListener(this){

            public void customResultAvailable(Object source, Object result) {
                List entries = (List)result;
                for (int i = 0; i < entries.size(); ++i) {
                    dlm.addElement(entries.get(i));
                }
            }
        });
        final JList otherlist = new JList(dlm);
        JPanel obuts = new JPanel(new BorderLayout());
        JButton refresh = new JButton("Refresh");
        obuts.add("East", refresh);
        refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibServiceBrowser.this.fetchOtherClasspathEntries(LibServiceBrowser.this.libservice).addResultListener((IResultListener)new SwingDefaultResultListener(LibServiceBrowser.this){

                    public void customResultAvailable(Object source, Object result) {
                        List entries = (List)result;
                        DefaultListModel dlm = (DefaultListModel)otherlist.getModel();
                        dlm.removeAllElements();
                        for (int i = 0; i < entries.size(); ++i) {
                            dlm.addElement((String)entries.get(i));
                        }
                    }
                });
            }
        });
        otherview.add("Center", new JScrollPane(otherlist));
        otherview.add("South", obuts);
        this.add("Managed Classpath Entries", classview);
        this.add("System Classpath Entries", otherview);
        this.listener = new ILibraryServiceListener(){

            public void urlAdded(URL url) {
                if (!LibServiceBrowser.this.classpaths.containsEntry(url.toString())) {
                    LibServiceBrowser.this.classpaths.addEntry(url.toString());
                }
            }

            public void urlRemoved(URL url) {
                if (LibServiceBrowser.this.classpaths.containsEntry(url.toString())) {
                    LibServiceBrowser.this.classpaths.removeEntry(url.toString());
                }
            }
        };
        try {
            this.libservice.addLibraryServiceListener(this.listener);
        }
        catch (Exception e) {
            System.out.println("Automatic updates not supported for library service.");
        }
        return new Future(null);
    }

    public IFuture shutdown() {
        try {
            this.libservice.removeLibraryServiceListener(this.listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Future(null);
    }

    public JComponent getComponent() {
        return this;
    }

    public String getId() {
        return "libservicebrowser";
    }

    public void setProperties(Properties ps) {
    }

    public Properties getProperties() {
        return null;
    }

    protected IFuture fetchManagedClasspathEntries() {
        final Future ret = new Future();
        this.libservice.getURLs().addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                List urls = (List)result;
                ArrayList<String> tmp = new ArrayList<String>();
                Iterator it = urls.iterator();
                while (it.hasNext()) {
                    URL url = (URL)it.next();
                    tmp.add(url.toString());
                }
                ret.setResult(tmp);
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    protected IFuture fetchOtherClasspathEntries(ILibraryService ls) {
        final Future ret = new Future();
        this.libservice.getNonManagedURLs().addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                List urls = (List)result;
                ArrayList<String> tmp = new ArrayList<String>();
                Iterator it = urls.iterator();
                while (it.hasNext()) {
                    URL url = (URL)it.next();
                    tmp.add(url.toString());
                }
                ret.setResult(tmp);
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }
}

