/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.awareness;

import jadex.base.service.awareness.AwarenessInfo;
import jadex.base.service.awareness.DiscoveryInfo;
import jadex.bridge.Argument;
import jadex.bridge.CreationInfo;
import jadex.bridge.IArgument;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.commons.Future;
import jadex.commons.ICommand;
import jadex.commons.IFuture;
import jadex.commons.SUtil;
import jadex.commons.concurrent.DefaultResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.commons.service.clock.IClockService;
import jadex.commons.service.library.ILibraryService;
import jadex.commons.service.threadpool.IThreadPoolService;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import jadex.xml.bean.JavaReader;
import jadex.xml.bean.JavaWriter;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AwarenessAgent
extends MicroAgent {
    protected InetAddress address;
    protected int port;
    protected boolean autocreate;
    protected boolean autodelete;
    protected long proxydelay;
    protected Map discovered;
    protected MulticastSocket sendsocket;
    protected long delay;
    protected String sendid;
    protected MulticastSocket receivesocket;
    protected boolean killed;
    protected IClockService clock;
    protected IComponentIdentifier root;
    static /* synthetic */ Class class$jadex$commons$service$threadpool$IThreadPoolService;

    public void agentCreated() {
        try {
            this.address = InetAddress.getByName((String)this.getArgument("address"));
            if (this.address == null) {
                throw new NullPointerException("Cannot get address: " + this.getArgument("address"));
            }
            this.port = ((Number)this.getArgument("port")).intValue();
            this.delay = ((Number)this.getArgument("delay")).longValue();
            this.autocreate = (Boolean)this.getArgument("autocreate");
            this.autodelete = (Boolean)this.getArgument("autodelete");
            this.proxydelay = ((Number)this.getArgument("proxydelay")).longValue();
            this.sendsocket = new MulticastSocket();
            this.sendsocket.setLoopbackMode(true);
            this.discovered = new LinkedHashMap();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void executeBody() {
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IClockService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                AwarenessAgent.this.clock = (IClockService)result;
                AwarenessAgent.this.getRootIdentifier().addResultListener(AwarenessAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        (this).AwarenessAgent.this.root = (IComponentIdentifier)result;
                        (this).AwarenessAgent.this.discovered.put((this).AwarenessAgent.this.root, new DiscoveryInfo((this).AwarenessAgent.this.root, false, false, (this).AwarenessAgent.this.clock.getTime(), (this).AwarenessAgent.this.delay));
                        AwarenessAgent.this.startSendBehaviour();
                        AwarenessAgent.this.startRemoveBehaviour();
                        AwarenessAgent.this.startReceiving();
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }));
            }

            public void exceptionOccurred(Object source, Exception exception) {
                throw new RuntimeException(exception);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agentKilled() {
        AwarenessAgent awarenessAgent = this;
        synchronized (awarenessAgent) {
            this.killed = true;
            if (this.sendsocket != null) {
                this.sendsocket.close();
            }
            if (this.receivesocket != null) {
                try {
                    this.receivesocket.leaveGroup(this.address);
                }
                catch (Exception exception) {
                }
                finally {
                    this.receivesocket.close();
                }
            }
        }
    }

    public void send(final AwarenessInfo info) {
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)ILibraryService.class).addResultListener(this.createResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object source, Object result) {
                try {
                    ILibraryService ls = (ILibraryService)result;
                    byte[] data = JavaWriter.objectToByteArray((Object)info, (ClassLoader)ls.getClassLoader());
                    DatagramPacket packet = new DatagramPacket(data, data.length, AwarenessAgent.this.address, AwarenessAgent.this.port);
                    AwarenessAgent.this.sendsocket.send(packet);
                }
                catch (Exception e) {
                    AwarenessAgent.this.getLogger().warning("Could not send awareness message: " + e);
                }
            }
        }));
    }

    public IFuture getRootIdentifier() {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                AwarenessAgent.this.getRootIdentifier(AwarenessAgent.this.getComponentIdentifier(), (IComponentManagementService)result, ret);
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public void getRootIdentifier(final IComponentIdentifier cid, final IComponentManagementService cms, final Future future) {
        cms.getParent(cid).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                if (result == null) {
                    future.setResult((Object)cid);
                } else {
                    AwarenessAgent.this.getRootIdentifier((IComponentIdentifier)result, cms, future);
                }
            }

            public void exceptionOccurred(Object source, Exception exception) {
                future.setException(exception);
            }
        }));
    }

    public synchronized Object[] getAddressInfo() {
        return new Object[]{this.address, new Integer(this.port)};
    }

    public synchronized void setAddressInfo(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    public synchronized boolean isAutoCreateProxy() {
        return this.autocreate;
    }

    public synchronized void setAutoCreateProxy(boolean autocreate) {
        this.autocreate = autocreate;
    }

    public synchronized boolean isAutoDeleteProxy() {
        return this.autodelete;
    }

    public synchronized void setAutoDeleteProxy(boolean autodelete) {
        this.autodelete = autodelete;
    }

    public synchronized long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        if (this.delay != delay) {
            this.delay = delay;
            this.startSendBehaviour();
        }
    }

    public synchronized long getProxyDelay() {
        return this.proxydelay;
    }

    public synchronized void setProxyDelay(long proxydelay) {
        this.proxydelay = proxydelay;
    }

    public synchronized void setExcluded(IComponentIdentifier cid, boolean excluded) {
        DiscoveryInfo dif = this.getDiscoveryInfo(cid);
        if (dif != null) {
            dif.setExcluded(excluded);
        }
    }

    public synchronized DiscoveryInfo[] getDiscoveryInfos() {
        return this.discovered.values().toArray(new DiscoveryInfo[this.discovered.size()]);
    }

    public String getSendId() {
        return this.sendid;
    }

    public void setSendId(String sendid) {
        this.sendid = sendid;
    }

    protected void startRemoveBehaviour() {
        this.scheduleStep(new ICommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Object args) {
                ArrayList<IComponentIdentifier> todel = AwarenessAgent.this.autodelete ? new ArrayList<IComponentIdentifier>() : null;
                AwarenessAgent awarenessAgent = AwarenessAgent.this;
                synchronized (awarenessAgent) {
                    long time = AwarenessAgent.this.clock.getTime();
                    Iterator it = AwarenessAgent.this.discovered.values().iterator();
                    while (it.hasNext()) {
                        DiscoveryInfo dif = (DiscoveryInfo)it.next();
                        if ((double)time > (double)dif.getTime() + (double)dif.getDelay() * 3.2) {
                            it.remove();
                            if (AwarenessAgent.this.autodelete) {
                                todel.add(dif.getComponentIdentifier());
                            }
                        }
                        AwarenessAgent.this.checkProxy(dif);
                    }
                }
                if (todel != null) {
                    for (int i = 0; i < todel.size(); ++i) {
                        IComponentIdentifier cid = (IComponentIdentifier)todel.get(i);
                        AwarenessAgent.this.deleteProxy(cid).addResultListener(new IResultListener(){

                            public void resultAvailable(Object source, Object result) {
                            }

                            public void exceptionOccurred(Object source, Exception exception) {
                            }
                        });
                    }
                }
                AwarenessAgent.this.waitFor(5000L, this);
            }
        });
    }

    public void checkProxy(final DiscoveryInfo dif) {
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                IComponentIdentifier lcid = cms.createComponentIdentifier(dif.getComponentIdentifier().getLocalName(), true);
                cms.getComponentDescription(lcid).addResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        dif.setProxy(false);
                    }
                });
            }

            public void exceptionOccurred(Object source, Exception exception) {
                AwarenessAgent.this.getLogger().warning("Could not get cms: " + exception);
            }
        }));
    }

    protected void startSendBehaviour() {
        String sendid;
        this.sendid = sendid = SUtil.createUniqueId((String)this.getAgentName());
        this.scheduleStep(new ICommand(){

            public void execute(Object args) {
                if (sendid.equals(AwarenessAgent.this.getSendId())) {
                    AwarenessAgent.this.send(new AwarenessInfo(AwarenessAgent.this.root, AwarenessAgent.this.clock.getTime(), AwarenessAgent.this.delay));
                    if (AwarenessAgent.this.delay > 0L) {
                        AwarenessAgent.this.waitFor(AwarenessAgent.this.delay, this);
                    }
                }
            }
        });
    }

    public synchronized DiscoveryInfo getDiscoveryInfo(IComponentIdentifier cid) {
        return (DiscoveryInfo)this.discovered.get(cid);
    }

    public IFuture createProxy(final IComponentIdentifier cid) {
        final HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("component", cid);
        args.put("delay", new Long(this.proxydelay));
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                if (cid.equals(AwarenessAgent.this.root)) {
                    ret.setException((Exception)new RuntimeException("Proxy for local components not allowed"));
                } else {
                    CreationInfo ci = new CreationInfo(args);
                    cms.createComponent(cid.getLocalName(), "jadex/base/service/remote/ProxyAgent.class", ci, AwarenessAgent.this.createResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            DiscoveryInfo dif = AwarenessAgent.this.getDiscoveryInfo(cid);
                            if (dif != null) {
                                dif.setProxy(false);
                            }
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                        }
                    })).addResultListener(AwarenessAgent.this.createResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            DiscoveryInfo dif = AwarenessAgent.this.getDiscoveryInfo(cid);
                            dif.setProxy(true);
                            ret.setResult(result);
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    }));
                }
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public IFuture deleteProxy(final IComponentIdentifier cid) {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                IComponentIdentifier pcid = cms.createComponentIdentifier(cid.getLocalName(), true);
                cms.destroyComponent(pcid).addResultListener(AwarenessAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        DiscoveryInfo dif = AwarenessAgent.this.getDiscoveryInfo(cid);
                        if (dif != null) {
                            dif.setProxy(false);
                        }
                        ret.setResult(result);
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        ret.setException(exception);
                    }
                }));
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public void startReceiving() {
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)ILibraryService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                final ILibraryService ls = (ILibraryService)result;
                SServiceProvider.getService((IServiceProvider)AwarenessAgent.this.getServiceProvider(), (Class)(class$jadex$commons$service$threadpool$IThreadPoolService == null ? (class$jadex$commons$service$threadpool$IThreadPoolService = AwarenessAgent.class$("jadex.commons.service.threadpool.IThreadPoolService")) : class$jadex$commons$service$threadpool$IThreadPoolService)).addResultListener(AwarenessAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        IThreadPoolService tp = (IThreadPoolService)result;
                        tp.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                byte[] buf = new byte[65535];
                                InetAddress myaddress = null;
                                while (!((this).this).AwarenessAgent.this.killed) {
                                    try {
                                        boolean createproxy;
                                        Object[] ai = AwarenessAgent.this.getAddressInfo();
                                        InetAddress curaddress = (InetAddress)ai[0];
                                        int curport = (Integer)ai[1];
                                        AwarenessAgent awarenessAgent = AwarenessAgent.this;
                                        synchronized (awarenessAgent) {
                                            if (!((this).this).AwarenessAgent.this.killed) {
                                                if (!(((this).this).AwarenessAgent.this.receivesocket == null || ((this).this).AwarenessAgent.this.receivesocket.getPort() == curport && SUtil.equals((Object)curaddress, myaddress))) {
                                                    ((this).this).AwarenessAgent.this.receivesocket.leaveGroup(myaddress);
                                                    ((this).this).AwarenessAgent.this.receivesocket.close();
                                                    ((this).this).AwarenessAgent.this.receivesocket = null;
                                                }
                                                if (((this).this).AwarenessAgent.this.receivesocket == null) {
                                                    try {
                                                        ((this).this).AwarenessAgent.this.receivesocket = new MulticastSocket(curport);
                                                        ((this).this).AwarenessAgent.this.receivesocket.joinGroup(curaddress);
                                                        myaddress = curaddress;
                                                    }
                                                    catch (Exception e) {
                                                        ((this).this).AwarenessAgent.this.receivesocket = null;
                                                        AwarenessAgent.this.getLogger().warning("Awareness error when joining mutlicast group: " + e);
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                        DatagramPacket pack = new DatagramPacket(buf, buf.length);
                                        ((this).this).AwarenessAgent.this.receivesocket.receive(pack);
                                        byte[] target = new byte[pack.getLength()];
                                        System.arraycopy(buf, 0, target, 0, pack.getLength());
                                        AwarenessInfo info = (AwarenessInfo)JavaReader.objectFromByteArray((byte[])target, (ClassLoader)ls.getClassLoader());
                                        IComponentIdentifier sender = info.getSender();
                                        AwarenessAgent awarenessAgent2 = AwarenessAgent.this;
                                        synchronized (awarenessAgent2) {
                                            DiscoveryInfo dif = (DiscoveryInfo)((this).this).AwarenessAgent.this.discovered.get(sender);
                                            if (dif == null) {
                                                createproxy = AwarenessAgent.this.isAutoCreateProxy();
                                                dif = new DiscoveryInfo(sender, createproxy, false, ((this).this).AwarenessAgent.this.clock.getTime(), AwarenessAgent.this.getDelay());
                                                ((this).this).AwarenessAgent.this.discovered.put(sender, dif);
                                            } else {
                                                createproxy = AwarenessAgent.this.isAutoCreateProxy() && !dif.isProxy() && !dif.isExcluded();
                                                dif.setTime(((this).this).AwarenessAgent.this.clock.getTime());
                                            }
                                        }
                                        if (!createproxy) continue;
                                        AwarenessAgent.this.createProxy(sender);
                                    }
                                    catch (Exception exception) {}
                                }
                                AwarenessAgent awarenessAgent = AwarenessAgent.this;
                                synchronized (awarenessAgent) {
                                    if (((this).this).AwarenessAgent.this.receivesocket != null) {
                                        try {
                                            ((this).this).AwarenessAgent.this.receivesocket.leaveGroup(((this).this).AwarenessAgent.this.address);
                                            ((this).this).AwarenessAgent.this.receivesocket.close();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                        });
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        AwarenessAgent.this.getLogger().warning("Awareness agent problem, could not get threadpool service: " + exception);
                    }
                }));
            }

            public void exceptionOccurred(Object source, Exception exception) {
                AwarenessAgent.this.getLogger().warning("Awareness agent problem, could not get library service: " + exception);
            }
        }));
    }

    public static MicroAgentMetaInfo getMetaInfo() {
        Object[] configs = new String[]{"Frequent updates (5s)", "Normal updates (10s)", "Seldom updates (60s)"};
        return new MicroAgentMetaInfo("This agent looks for other awareness agents in the local net.", (String[])configs, new IArgument[]{new Argument("address", "This parameter is the ip multicast address used for finding other agents (range 224.0.0.0-239.255.255.255).", "String", (Object)"224.0.0.0"), new Argument("port", "This parameter is the port used for finding other agents.", "int", (Object)new Integer(55667)), new Argument("delay", "This parameter is the delay between sending awareness infos.", "long", SUtil.createHashMap((Object[])configs, (Object[])new Object[]{new Long(10000L), new Long(20000L), new Long(60000L)})), new Argument("autocreate", "This parameter describes if new proxies should be automatically created when discovering new components.", "boolean", (Object)Boolean.TRUE), new Argument("autodelete", "This parameter describes if proxies should be automatically deleted when not discovered any longer.", "boolean", (Object)Boolean.TRUE), new Argument("proxydelay", "This parameter is the delay used by proxies.", "long", (Object)new Long(15000L))}, null, null, SUtil.createHashMap((Object[])new String[]{"componentviewer.viewerclass"}, (Object[])new Object[]{"jadex.base.service.awareness.AwarenessAgentPanel"}));
    }
}

