/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.awareness;

import jadex.base.gui.componentviewer.IComponentViewerPanel;
import jadex.base.gui.jtable.ComponentIdentifierRenderer;
import jadex.base.gui.plugin.IControlCenter;
import jadex.base.service.awareness.AwarenessAgent;
import jadex.base.service.awareness.DiscoveryInfo;
import jadex.base.service.awareness.DiscoveryTableModel;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.commons.Future;
import jadex.commons.ICommand;
import jadex.commons.IFuture;
import jadex.commons.IResultCommand;
import jadex.commons.Properties;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.SwingDefaultResultListener;
import jadex.commons.jtable.DateTimeRenderer;
import jadex.micro.IMicroExternalAccess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.sql.Date;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;

public class AwarenessAgentPanel
implements IComponentViewerPanel {
    protected IControlCenter jcc;
    protected IMicroExternalAccess component;
    protected Timer timer;
    protected int timerdelay;
    protected InetAddress address;
    protected int port;
    protected long delay;
    protected long proxydelay;
    protected boolean autocreate;
    protected boolean autodelete;
    protected JTextField tfipaddress;
    protected JTextField tfport;
    protected JSpinner spdelay;
    protected JCheckBox cbautocreate;
    protected JCheckBox cbautodelete;
    protected JSpinner sprefresh;
    protected JSpinner spprorefresh;
    protected JPanel panel;

    public IFuture init(final IControlCenter jcc, IExternalAccess component) {
        this.jcc = jcc;
        this.component = (IMicroExternalAccess)component;
        this.panel = new JPanel(new GridBagLayout());
        this.timerdelay = 5000;
        this.tfipaddress = new JTextField(0);
        this.tfport = new JTextField(0);
        this.updateAddress();
        SpinnerNumberModel spmdelay = new SpinnerNumberModel(0, 0, 100000, 1);
        this.spdelay = new JSpinner(spmdelay);
        this.updateDelay();
        SpinnerNumberModel spmrefresh = new SpinnerNumberModel(5, 0, 100000, 1);
        this.sprefresh = new JSpinner(spmrefresh);
        this.cbautocreate = new JCheckBox();
        this.updateAutoCreate(this.cbautocreate);
        this.cbautodelete = new JCheckBox();
        this.updateAutoDelete(this.cbautodelete);
        SpinnerNumberModel spmprorefresh = new SpinnerNumberModel(5, 0, 100000, 1);
        this.spprorefresh = new JSpinner(spmprorefresh);
        this.updateProxyDelay();
        JPanel pdissettings = new JPanel(new GridBagLayout());
        pdissettings.setBorder(new TitledBorder(new EtchedBorder(1), " Discovery Settings "));
        int y = 0;
        pdissettings.add((Component)new JLabel("Multicast address [ip:port]", 2), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pdissettings.add((Component)this.tfipaddress, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        pdissettings.add((Component)this.tfport, new GridBagConstraints(2, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        pdissettings.add((Component)new JLabel("Info send delay (0=off) [s]", 2), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 1));
        pdissettings.add((Component)this.spdelay, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        pdissettings.add((Component)new JLabel("Gui refresh delay (0=off) [s]", 2), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pdissettings.add((Component)this.sprefresh, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        ++y;
        JPanel pprosettings = new JPanel(new GridBagLayout());
        pprosettings.setBorder(new TitledBorder(new EtchedBorder(1), " Proxy Settings "));
        y = 0;
        pprosettings.add((Component)new JLabel("Create on discovery", 2), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)this.cbautocreate, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)new JLabel("Delete on disappearance", 2), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)this.cbautodelete, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)new JLabel("Refresh delay (0=off) [s]", 2), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        pprosettings.add((Component)this.spprorefresh, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        ++y;
        JButton buapply = new JButton("Apply");
        buapply.setToolTipText("Apply setting changes.");
        buapply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AwarenessAgentPanel.this.applySettings(AwarenessAgentPanel.this.panel);
            }
        });
        JButton bucancel = new JButton("Cancel");
        buapply.setToolTipText("Cancel changes and reset original values.");
        bucancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwarenessAgentPanel.this.tfipaddress.setText(AwarenessAgentPanel.this.address.getHostAddress());
                AwarenessAgentPanel.this.tfport.setText("" + AwarenessAgentPanel.this.port);
                AwarenessAgentPanel.this.spdelay.setValue(new Long(AwarenessAgentPanel.this.delay / 1000L));
                AwarenessAgentPanel.this.cbautocreate.setSelected(AwarenessAgentPanel.this.autocreate);
                AwarenessAgentPanel.this.cbautodelete.setSelected(AwarenessAgentPanel.this.autodelete);
                AwarenessAgentPanel.this.spprorefresh.setValue(new Long(AwarenessAgentPanel.this.proxydelay / 1000L));
            }
        });
        JButton burefresh = new JButton("Refresh");
        burefresh.setToolTipText("Refresh settings from underlying component.");
        burefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwarenessAgentPanel.this.updateAddress();
                AwarenessAgentPanel.this.updateDelay();
                AwarenessAgentPanel.this.updateAutoCreate(AwarenessAgentPanel.this.cbautocreate);
                AwarenessAgentPanel.this.updateAutoDelete(AwarenessAgentPanel.this.cbautodelete);
                AwarenessAgentPanel.this.updateProxyDelay();
            }
        });
        buapply.setPreferredSize(burefresh.getPreferredSize());
        buapply.setMinimumSize(burefresh.getMinimumSize());
        bucancel.setPreferredSize(burefresh.getPreferredSize());
        bucancel.setMinimumSize(burefresh.getMinimumSize());
        JPanel pbuts = new JPanel(new FlowLayout(2));
        pbuts.add(burefresh);
        pbuts.add(buapply);
        pbuts.add(bucancel);
        JPanel pdisinfos = new JPanel(new BorderLayout());
        pdisinfos.setBorder(new TitledBorder(new EtchedBorder(1), " Discovery Infos "));
        final DiscoveryTableModel dismodel = new DiscoveryTableModel();
        final JTable jtdis = new JTable(dismodel);
        jtdis.setPreferredScrollableViewportSize(new Dimension(600, 120));
        jtdis.setSelectionMode(0);
        pdisinfos.add("Center", new JScrollPane(jtdis));
        jtdis.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTimeRenderer());
        jtdis.setDefaultRenderer(IComponentIdentifier.class, new ComponentIdentifierRenderer());
        this.updateDiscoveryInfos(jtdis);
        this.timer = new Timer(this.timerdelay, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwarenessAgentPanel.this.updateDiscoveryInfos(jtdis);
            }
        });
        JButton burefreshdis = new JButton("Refresh");
        burefreshdis.setToolTipText("Refresh discovery infos.");
        burefreshdis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwarenessAgentPanel.this.updateDiscoveryInfos(jtdis);
            }
        });
        JButton bucreate = new JButton("Create");
        bucreate.setToolTipText("Create a proxy for the selected component.");
        bucreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int sel = jtdis.getSelectedRow();
                if (sel == -1) {
                    jcc.displayError("Creation Error", "No discovered component selected.", null);
                } else {
                    DiscoveryInfo dif = (DiscoveryInfo)dismodel.getList().get(sel);
                    if (dif.isProxy()) {
                        jcc.displayError("Creation Error", "Component already has proxy.", null);
                    } else {
                        AwarenessAgentPanel.this.component.scheduleResultStep((IResultCommand)new CreateProxyCommand(dif.getComponentIdentifier())).addResultListener((IResultListener)new SwingDefaultResultListener(AwarenessAgentPanel.this.panel){

                            public void customResultAvailable(Object source, Object result) {
                                AwarenessAgentPanel.this.updateDiscoveryInfos(jtdis);
                            }
                        });
                    }
                }
            }
        });
        JButton budelete = new JButton("Delete");
        budelete.setToolTipText("Delete proxy for the selected component.");
        budelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int sel = jtdis.getSelectedRow();
                if (sel == -1) {
                    jcc.displayError("Deletion Error", "No discovered component selected.", null);
                } else {
                    DiscoveryInfo dif = (DiscoveryInfo)dismodel.getList().get(sel);
                    if (!dif.isProxy()) {
                        jcc.displayError("Deletion Error", "Component has no proxy.", null);
                    } else {
                        AwarenessAgentPanel.this.component.scheduleResultStep((IResultCommand)new DeleteProxyCommand(dif.getComponentIdentifier())).addResultListener((IResultListener)new SwingDefaultResultListener(AwarenessAgentPanel.this.panel){

                            public void customResultAvailable(Object source, Object result) {
                                AwarenessAgentPanel.this.updateDiscoveryInfos(jtdis);
                            }
                        });
                    }
                }
            }
        });
        JButton buexclude = new JButton("Exclude");
        buexclude.setToolTipText("Exclude/include from automatic proxy generation.");
        buexclude.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int sel = jtdis.getSelectedRow();
                if (sel == -1) {
                    jcc.displayError("Exclusion Error", "No discovered component selected.", null);
                } else {
                    DiscoveryInfo dif = (DiscoveryInfo)dismodel.getList().get(sel);
                    AwarenessAgentPanel.this.component.scheduleStep((ICommand)new SetExcludedCommand(dif.getComponentIdentifier(), !dif.isExcluded())).addResultListener((IResultListener)new SwingDefaultResultListener(AwarenessAgentPanel.this.panel){

                        public void customResultAvailable(Object source, Object result) {
                            AwarenessAgentPanel.this.updateDiscoveryInfos(jtdis);
                        }
                    });
                }
            }
        });
        bucreate.setPreferredSize(buexclude.getPreferredSize());
        budelete.setMinimumSize(buexclude.getMinimumSize());
        burefreshdis.setPreferredSize(buexclude.getPreferredSize());
        JPanel pbobuts = new JPanel(new FlowLayout(2));
        pbobuts.add(burefreshdis);
        pbobuts.add(bucreate);
        pbobuts.add(budelete);
        pbobuts.add(buexclude);
        this.timer.start();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        this.panel.add((Component)pdissettings, gbc);
        this.panel.add((Component)pprosettings, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        this.panel.add((Component)pbuts, gbc);
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        this.panel.add((Component)pdisinfos, gbc);
        gbc.gridy = 3;
        gbc.weighty = 0.0;
        this.panel.add((Component)pbobuts, gbc);
        return new Future(null);
    }

    public IFuture shutdown() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        return new Future(null);
    }

    public String getId() {
        return "awarenessviewer";
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setProperties(Properties ps) {
    }

    public Properties getProperties() {
        return null;
    }

    protected void updateAddress() {
        this.component.scheduleResultStep((IResultCommand)new GetAddressCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(this.tfipaddress){

            public void customResultAvailable(Object source, Object result) {
                Object[] ai = (Object[])result;
                AwarenessAgentPanel.this.address = (InetAddress)ai[0];
                AwarenessAgentPanel.this.port = ((Number)ai[1]).intValue();
                AwarenessAgentPanel.this.tfipaddress.setText(AwarenessAgentPanel.this.address.getHostAddress());
                AwarenessAgentPanel.this.tfport.setText("" + AwarenessAgentPanel.this.port);
            }
        });
    }

    protected void updateDelay() {
        this.component.scheduleResultStep((IResultCommand)new GetDelayCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(this.spdelay){

            public void customResultAvailable(Object source, Object result) {
                AwarenessAgentPanel.this.delay = ((Number)result).longValue();
                AwarenessAgentPanel.this.spdelay.setValue(new Long(AwarenessAgentPanel.this.delay / 1000L));
            }
        });
    }

    protected void updateProxyDelay() {
        this.component.scheduleResultStep((IResultCommand)new GetProxyDelayCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(this.spprorefresh){

            public void customResultAvailable(Object source, Object result) {
                AwarenessAgentPanel.this.proxydelay = ((Number)result).longValue();
                AwarenessAgentPanel.this.spprorefresh.setValue(new Long(AwarenessAgentPanel.this.proxydelay / 1000L));
            }
        });
    }

    protected void updateAutoCreate(final JCheckBox cbautocreate) {
        this.component.scheduleResultStep((IResultCommand)new GetAutoCreateProxyCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(cbautocreate){

            public void customResultAvailable(Object source, Object result) {
                AwarenessAgentPanel.this.autocreate = (Boolean)result;
                cbautocreate.setSelected(AwarenessAgentPanel.this.autocreate);
            }
        });
    }

    protected void updateAutoDelete(final JCheckBox cbautodelete) {
        this.component.scheduleResultStep((IResultCommand)new GetAutoDeleteProxyCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(cbautodelete){

            public void customResultAvailable(Object source, Object result) {
                AwarenessAgentPanel.this.autodelete = (Boolean)result;
                cbautodelete.setSelected(AwarenessAgentPanel.this.autodelete);
            }
        });
    }

    protected void updateDiscoveryInfos(final JTable jtdis) {
        this.component.scheduleResultStep((IResultCommand)new GetDiscoveryInfosCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(jtdis){

            public void customResultAvailable(Object source, Object result) {
                DiscoveryInfo[] ds = (DiscoveryInfo[])result;
                int sel = jtdis.getSelectedRow();
                DiscoveryTableModel dtm = (DiscoveryTableModel)jtdis.getModel();
                List disinfos = dtm.getList();
                disinfos.clear();
                for (int i = 0; i < ds.length; ++i) {
                    disinfos.add(ds[i]);
                }
                dtm.fireTableDataChanged();
                if (sel != -1 && sel < ds.length) {
                    ((DefaultListSelectionModel)jtdis.getSelectionModel()).setSelectionInterval(sel, sel);
                }
            }

            public void customExceptionOccurred(Object source, Exception exception) {
                AwarenessAgentPanel.this.sprefresh.setValue(new Integer(0));
            }
        });
    }

    protected void applySettings(JComponent ui) {
        int timerdelay;
        long proxydelay;
        boolean autodelete;
        boolean autocreate;
        try {
            final InetAddress address = InetAddress.getByName(this.tfipaddress.getText());
            final int port = Integer.parseInt(this.tfport.getText());
            if (!address.equals(this.address)) {
                this.component.scheduleStep((ICommand)new SetAddressCommand(address, port)).addResultListener((IResultListener)new SwingDefaultResultListener(ui){

                    public void customResultAvailable(Object source, Object result) {
                        AwarenessAgentPanel.this.address = address;
                        AwarenessAgentPanel.this.port = port;
                    }
                });
            }
        }
        catch (Exception e) {
            this.jcc.displayError("Parsing Error", "Could not create address.", e);
        }
        final long delay = ((Number)this.spdelay.getValue()).longValue() * 1000L;
        if (delay != this.delay) {
            this.component.scheduleStep((ICommand)new SetDelayCommand(delay)).addResultListener((IResultListener)new SwingDefaultResultListener(ui){

                public void customResultAvailable(Object source, Object result) {
                    AwarenessAgentPanel.this.delay = delay;
                }
            });
        }
        if ((autocreate = this.cbautocreate.isSelected()) != this.autocreate) {
            this.component.scheduleStep((ICommand)new SetAutoCreateProxyCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(ui){

                public void customResultAvailable(Object source, Object result) {
                    AwarenessAgentPanel.this.autocreate = autocreate;
                }
            });
        }
        if ((autodelete = this.cbautodelete.isSelected()) != this.autodelete) {
            this.component.scheduleStep((ICommand)new SetAutoDeleteProxyCommand()).addResultListener((IResultListener)new SwingDefaultResultListener(ui){

                public void customResultAvailable(Object source, Object result) {
                    AwarenessAgentPanel.this.autodelete = autodelete;
                }
            });
        }
        if ((proxydelay = ((Number)this.spprorefresh.getValue()).longValue() * 1000L) != this.proxydelay) {
            this.component.scheduleStep((ICommand)new SetProxyDelayCommand(proxydelay)).addResultListener((IResultListener)new SwingDefaultResultListener(ui){

                public void customResultAvailable(Object source, Object result) {
                    AwarenessAgentPanel.this.proxydelay = proxydelay;
                }
            });
        }
        if ((timerdelay = ((Number)this.sprefresh.getValue()).intValue() * 1000) != this.timerdelay) {
            this.timerdelay = timerdelay;
            if (timerdelay == 0) {
                this.timer.stop();
            } else {
                this.timer.setDelay(timerdelay);
                if (!this.timer.isRunning()) {
                    this.timer.start();
                }
            }
        }
    }

    public static class SetExcludedCommand
    implements ICommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public IComponentIdentifier cid;
        public boolean excluded;

        public SetExcludedCommand() {
        }

        public SetExcludedCommand(IComponentIdentifier cid, boolean excluded) {
            this.cid = cid;
            this.excluded = excluded;
        }

        public void execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            agent.setExcluded(this.cid, this.excluded);
        }
    }

    public static class DeleteProxyCommand
    implements IResultCommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public IComponentIdentifier cid;

        public DeleteProxyCommand() {
        }

        public DeleteProxyCommand(IComponentIdentifier cid) {
            this.cid = cid;
        }

        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            return agent.deleteProxy(this.cid);
        }
    }

    public static class CreateProxyCommand
    implements IResultCommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public IComponentIdentifier cid;

        public CreateProxyCommand() {
        }

        public CreateProxyCommand(IComponentIdentifier cid) {
            this.cid = cid;
        }

        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            return agent.createProxy(this.cid);
        }
    }

    public static class GetDiscoveryInfosCommand
    implements IResultCommand {
        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            return agent.getDiscoveryInfos();
        }
    }

    public static class SetAutoDeleteProxyCommand
    implements ICommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public boolean autodelete;

        public SetAutoDeleteProxyCommand() {
        }

        public SetAutoDeleteProxyCommand(boolean autodelete) {
            this.autodelete = autodelete;
        }

        public void execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            agent.setAutoDeleteProxy(this.autodelete);
        }
    }

    public static class GetAutoDeleteProxyCommand
    implements IResultCommand {
        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            boolean auto = agent.isAutoDeleteProxy();
            return auto ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class SetAutoCreateProxyCommand
    implements ICommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public boolean autocreate;

        public SetAutoCreateProxyCommand() {
        }

        public SetAutoCreateProxyCommand(boolean autocreate) {
            this.autocreate = autocreate;
        }

        public void execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            agent.setAutoCreateProxy(this.autocreate);
        }
    }

    public static class GetAutoCreateProxyCommand
    implements IResultCommand {
        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            boolean auto = agent.isAutoCreateProxy();
            return auto ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class SetAddressCommand
    implements ICommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public InetAddress address;
        public int port;

        public SetAddressCommand() {
        }

        public SetAddressCommand(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        public void execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            agent.setAddressInfo(this.address, this.port);
        }
    }

    public static class GetAddressCommand
    implements IResultCommand {
        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            return agent.getAddressInfo();
        }
    }

    public static class SetProxyDelayCommand
    implements ICommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public long delay;

        public SetProxyDelayCommand() {
        }

        public SetProxyDelayCommand(long delay) {
            this.delay = delay;
        }

        public void execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            agent.setProxyDelay(this.delay);
        }
    }

    public static class SetDelayCommand
    implements ICommand {
        public static boolean XML_INCLUDE_FIELDS = true;
        public long delay;

        public SetDelayCommand() {
        }

        public SetDelayCommand(long delay) {
            this.delay = delay;
        }

        public void execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            agent.setDelay(this.delay);
        }
    }

    public static class GetProxyDelayCommand
    implements IResultCommand {
        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            long delay = agent.getProxyDelay();
            return new Long(delay);
        }
    }

    public static class GetDelayCommand
    implements IResultCommand {
        public Object execute(Object args) {
            AwarenessAgent agent = (AwarenessAgent)((Object)args);
            long delay = agent.getDelay();
            return new Long(delay);
        }
    }
}

