/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.awareness;

import jadex.base.service.awareness.DiscoveryInfo;
import jadex.bridge.IComponentIdentifier;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class DiscoveryTableModel
extends AbstractTableModel {
    protected List list;

    public DiscoveryTableModel() {
        this(new ArrayList());
    }

    public DiscoveryTableModel(List list) {
        this.list = list;
    }

    public List getList() {
        return this.list;
    }

    public int getRowCount() {
        return this.list.size();
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Component Identifier";
            }
            case 1: {
                return "Delay";
            }
            case 2: {
                return "Time of Last Received Info";
            }
            case 3: {
                return "Has a Proxy";
            }
            case 4: {
                return "Excluded from Proxy Creation";
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        Object value = null;
        DiscoveryInfo dif = (DiscoveryInfo)this.list.get(row);
        if (column == 0) {
            value = dif.getComponentIdentifier();
        } else if (column == 1) {
            value = new Long(dif.getDelay());
        } else if (column == 2) {
            value = new Date(dif.getTime());
        } else if (column == 3) {
            value = dif.isProxy() ? Boolean.TRUE : Boolean.FALSE;
        } else if (column == 4) {
            value = dif.isExcluded() ? Boolean.TRUE : Boolean.FALSE;
        }
        return value;
    }

    public Class getColumnClass(int column) {
        Class ret;
        Class clazz = ret = Object.class;
        if (column == 0) {
            ret = IComponentIdentifier.class;
        } else if (column == 1) {
            ret = Long.class;
        } else if (column == 2) {
            ret = Date.class;
        } else if (column == 3) {
            ret = Boolean.class;
        } else if (column == 4) {
            ret = Boolean.class;
        }
        return ret;
    }
}

