/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.cms;

import jadex.base.fipa.CMSComponentDescription;
import jadex.base.fipa.SearchConstraints;
import jadex.bridge.ComponentFactorySelector;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.CreationInfo;
import jadex.bridge.IComponentAdapter;
import jadex.bridge.IComponentAdapterFactory;
import jadex.bridge.IComponentDescription;
import jadex.bridge.IComponentFactory;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentInstance;
import jadex.bridge.IComponentListener;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IMessageService;
import jadex.bridge.IModelInfo;
import jadex.bridge.IRemoteServiceManagementService;
import jadex.bridge.ISearchConstraints;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.collection.MultiCollection;
import jadex.commons.collection.SCollection;
import jadex.commons.concurrent.CollectionResultListener;
import jadex.commons.concurrent.DefaultResultListener;
import jadex.commons.concurrent.DelegationResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.BasicService;
import jadex.commons.service.IResultSelector;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.commons.service.execution.IExecutionService;
import jadex.commons.service.library.ILibraryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class ComponentManagementService
extends BasicService
implements IComponentManagementService {
    public static int compcnt;
    protected IServiceProvider provider;
    protected Map adapters;
    protected Map descs;
    protected Map ccs;
    protected Logger logger;
    protected MultiCollection listeners;
    protected Map killresultlisteners;
    protected Map exceptions;
    protected IExecutionService exeservice;
    protected IMessageService msgservice;
    protected IComponentAdapter root;
    protected Map initinfos;
    protected Map childcounts;
    static /* synthetic */ Class class$jadex$bridge$IMessageService;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$jadex$commons$service$execution$IExecutionService;

    public ComponentManagementService(IServiceProvider provider) {
        this(provider, null);
    }

    public ComponentManagementService(IServiceProvider provider, IComponentAdapter root) {
        super(provider.getId(), IComponentManagementService.class, null);
        this.provider = provider;
        this.adapters = Collections.synchronizedMap(SCollection.createHashMap());
        this.descs = Collections.synchronizedMap(SCollection.createLinkedHashMap());
        this.ccs = SCollection.createLinkedHashMap();
        this.logger = Logger.getLogger(provider.getId() + ".cms");
        this.listeners = SCollection.createMultiCollection();
        this.killresultlisteners = Collections.synchronizedMap(SCollection.createHashMap());
        this.initinfos = Collections.synchronizedMap(SCollection.createHashMap());
        this.childcounts = SCollection.createHashMap();
        this.root = root;
    }

    public abstract IComponentInstance getComponentInstance(IComponentAdapter var1);

    public abstract IComponentAdapterFactory getComponentAdapterFactory();

    public abstract IFuture killComponent(IComponentAdapter var1);

    public abstract IFuture cancel(IComponentAdapter var1);

    public abstract IFuture doStep(IComponentAdapter var1);

    public abstract IComponentDescription getDescription(IComponentAdapter var1);

    public IFuture createComponent(final String name, final String model, CreationInfo info, final IResultListener killlistener) {
        CreationInfo cinfo;
        final Future inited = new Future();
        CreationInfo creationInfo = cinfo = info != null ? info : new CreationInfo();
        if (name != null && name.indexOf(64) != -1) {
            inited.setException((Exception)new RuntimeException("No '@' allowed in component name."));
            return inited;
        }
        SServiceProvider.getService((IServiceProvider)this.provider, (Class)ILibraryService.class).addResultListener((IResultListener)new DefaultResultListener(){

            public void resultAvailable(Object source, Object result) {
                final ILibraryService ls = (ILibraryService)result;
                SServiceProvider.getService((IServiceProvider)ComponentManagementService.this.provider, (IResultSelector)new ComponentFactorySelector(model, cinfo.getImports(), ls.getClassLoader())).addResultListener(new IResultListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultAvailable(Object source, Object result) {
                        ComponentIdentifier cid;
                        IComponentFactory factory = (IComponentFactory)result;
                        if (factory == null) {
                            inited.setException((Exception)new RuntimeException("No factory found for component: " + model));
                            return;
                        }
                        final IModelInfo lmodel = factory.loadModel(model, cinfo.getImports(), ls.getClassLoader());
                        String type = factory.getComponentType(model, cinfo.getImports(), ls.getClassLoader());
                        Map map = (this).ComponentManagementService.this.adapters;
                        synchronized (map) {
                            Map map2 = (this).ComponentManagementService.this.descs;
                            synchronized (map2) {
                                if (name == null) {
                                    cid = (ComponentIdentifier)ComponentManagementService.this.generateComponentIdentifier(lmodel.getName());
                                } else {
                                    cid = new ComponentIdentifier(name + "@" + ((IComponentIdentifier)(this).ComponentManagementService.this.provider.getId()).getPlatformName());
                                    if ((this).ComponentManagementService.this.adapters.containsKey(cid) || (this).ComponentManagementService.this.initinfos.containsKey(cid)) {
                                        inited.setException((Exception)new RuntimeException("Component name already exists on platform: " + cid));
                                        return;
                                    }
                                    SServiceProvider.getService((IServiceProvider)(this).ComponentManagementService.this.provider, (Class)(class$jadex$bridge$IMessageService == null ? (class$jadex$bridge$IMessageService = ComponentManagementService.class$("jadex.bridge.IMessageService")) : class$jadex$bridge$IMessageService)).addResultListener((IResultListener)new DefaultResultListener(){

                                        public void resultAvailable(Object source, Object result) {
                                            IMessageService ms = (IMessageService)result;
                                            if (ms != null) {
                                                cid.setAddresses(ms.getAddresses());
                                            }
                                        }
                                    });
                                }
                            }
                        }
                        final IComponentAdapter pad = ComponentManagementService.this.getParentAdapter(cinfo);
                        IExternalAccess parent = ComponentManagementService.this.getComponentInstance(pad).getExternalAccess();
                        final CMSComponentDescription ad = new CMSComponentDescription((IComponentIdentifier)cid, type, ComponentManagementService.this.getParentIdentifier(cinfo), cinfo.isMaster(), cinfo.isDaemon(), cinfo.isAutoShutdown(), lmodel.getFullName());
                        Future future = new Future();
                        future.addResultListener(new IResultListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void resultAvailable(Object source, Object result) {
                                IComponentListener[] alisteners;
                                IComponentAdapter adapter;
                                Map map = ((this).this).ComponentManagementService.this.adapters;
                                synchronized (map) {
                                    Map map2 = ((this).this).ComponentManagementService.this.descs;
                                    synchronized (map2) {
                                        if (ComponentManagementService.this.isInitSuspend(cinfo, lmodel)) {
                                            ad.setState("suspended");
                                        } else {
                                            ad.setState("active");
                                        }
                                        adapter = (IComponentAdapter)((Object[])result)[1];
                                        ((this).this).ComponentManagementService.this.descs.put(cid, ad);
                                        ((this).this).ComponentManagementService.this.adapters.put(cid, adapter);
                                        ((this).this).ComponentManagementService.this.initinfos.remove(cid);
                                        Object[] painfo = ComponentManagementService.this.getParentInfo(cinfo);
                                        CMSComponentDescription padesc = painfo != null ? (CMSComponentDescription)painfo[0] : (CMSComponentDescription)((this).this).ComponentManagementService.this.descs.get(ComponentManagementService.this.getParentIdentifier(cinfo));
                                        padesc.addChild((IComponentIdentifier)cid);
                                        if (padesc.isAutoShutdown() && !ad.isDaemon()) {
                                            Integer childcount = (Integer)((this).this).ComponentManagementService.this.childcounts.get(padesc.getName());
                                            ((this).this).ComponentManagementService.this.childcounts.put(padesc.getName(), new Integer(childcount != null ? childcount + 1 : 1));
                                        }
                                    }
                                }
                                ComponentManagementService.this.getComponentInstance(pad).componentCreated((IComponentDescription)ad, lmodel);
                                map = ((this).this).ComponentManagementService.this.listeners;
                                synchronized (map) {
                                    HashSet slisteners = new HashSet(((this).this).ComponentManagementService.this.listeners.getCollection(null));
                                    slisteners.addAll(((this).this).ComponentManagementService.this.listeners.getCollection((Object)cid));
                                    alisteners = slisteners.toArray(new IComponentListener[slisteners.size()]);
                                }
                                for (int i = 0; i < alisteners.length; ++i) {
                                    try {
                                        alisteners[i].componentAdded((IComponentDescription)ad);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (killlistener != null) {
                                    ((this).this).ComponentManagementService.this.killresultlisteners.put(cid, killlistener);
                                }
                                inited.setResult((Object)cid);
                                if (!cinfo.isSuspend()) {
                                    try {
                                        adapter.wakeup();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void exceptionOccurred(Object source, Exception exception) {
                                CleanupCommand cc = null;
                                Map map = ((this).this).ComponentManagementService.this.adapters;
                                synchronized (map) {
                                    Map map2 = ((this).this).ComponentManagementService.this.descs;
                                    synchronized (map2) {
                                        ((this).this).ComponentManagementService.this.adapters.remove(cid);
                                        ((this).this).ComponentManagementService.this.descs.remove(cid);
                                        ((this).this).ComponentManagementService.this.initinfos.remove(cid);
                                        ((this).this).ComponentManagementService.this.exceptions.remove(cid);
                                        cc = (CleanupCommand)((this).this).ComponentManagementService.this.ccs.remove(cid);
                                    }
                                }
                                IResultListener reslis = (IResultListener)((this).this).ComponentManagementService.this.killresultlisteners.remove(cid);
                                if (reslis != null) {
                                    reslis.exceptionOccurred((Object)cid, exception);
                                }
                                if (cc != null && cc.killfutures != null) {
                                    for (int i = 0; i < cc.killfutures.size(); ++i) {
                                        ((Future)cc.killfutures.get(i)).setException(exception);
                                    }
                                }
                                inited.setException(exception);
                            }
                        });
                        String config = cinfo.getConfiguration() != null ? cinfo.getConfiguration() : (lmodel.getConfigurations().length > 0 ? lmodel.getConfigurations()[0] : null);
                        Object[] comp = factory.createComponentInstance((IComponentDescription)ad, ComponentManagementService.this.getComponentAdapterFactory(), lmodel, config, cinfo.getArguments(), parent, future);
                        Map map3 = (this).ComponentManagementService.this.adapters;
                        synchronized (map3) {
                            Map map4 = (this).ComponentManagementService.this.descs;
                            synchronized (map4) {
                                (this).ComponentManagementService.this.initinfos.put(cid, new Object[]{ad, comp[1], cinfo, lmodel, future});
                            }
                        }
                        try {
                            ((IComponentAdapter)comp[1]).wakeup();
                        }
                        catch (Exception e) {
                            inited.setException(e);
                        }
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        inited.setException(exception);
                    }
                });
            }
        });
        return inited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getParentInfo(CreationInfo cinfo) {
        Object[] ret;
        IComponentIdentifier paid = this.getParentIdentifier(cinfo);
        Map map = this.adapters;
        synchronized (map) {
            Map map2 = this.descs;
            synchronized (map2) {
                ret = (Object[])this.initinfos.get(paid);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IComponentAdapter getParentAdapter(CreationInfo cinfo) {
        IComponentAdapter adapter;
        IComponentIdentifier paid = this.getParentIdentifier(cinfo);
        Map map = this.adapters;
        synchronized (map) {
            Map map2 = this.descs;
            synchronized (map2) {
                adapter = (IComponentAdapter)this.adapters.get(paid);
                if (adapter == null) {
                    adapter = (IComponentAdapter)this.getParentInfo(cinfo)[1];
                }
            }
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CMSComponentDescription getParentDescription(CreationInfo cinfo) {
        CMSComponentDescription desc;
        IComponentIdentifier paid = this.getParentIdentifier(cinfo);
        Map map = this.adapters;
        synchronized (map) {
            Map map2 = this.descs;
            synchronized (map2) {
                desc = (CMSComponentDescription)this.descs.get(paid);
                if (desc == null) {
                    desc = (CMSComponentDescription)this.getParentInfo(cinfo)[0];
                }
            }
        }
        return desc;
    }

    protected boolean isRemoteComponent(IComponentIdentifier cid) {
        return !cid.getPlatformName().equals(this.root.getComponentIdentifier().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture destroyComponent(final IComponentIdentifier cid) {
        final Future ret = new Future();
        if (this.isRemoteComponent(cid)) {
            SServiceProvider.getService((IServiceProvider)this.provider, (Class)IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                    rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentManagementService.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            IComponentManagementService rcms = (IComponentManagementService)result;
                            rcms.destroyComponent(cid).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            Map map = this.adapters;
            synchronized (map) {
                Map map2 = this.descs;
                synchronized (map2) {
                    final CMSComponentDescription desc = (CMSComponentDescription)this.descs.get(cid);
                    if (desc == null) {
                        ret.setException((Exception)new RuntimeException("Component " + cid + " does not exist."));
                        return ret;
                    }
                    IComponentIdentifier[] achildren = desc.getChildren();
                    this.destroyComponentLoop(cid, achildren, 0).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            IComponentAdapter component = (IComponentAdapter)ComponentManagementService.this.adapters.get(cid);
                            if (component != null) {
                                if (!ComponentManagementService.this.ccs.containsKey(cid)) {
                                    CleanupCommand cc = new CleanupCommand(cid);
                                    ComponentManagementService.this.ccs.put(cid, cc);
                                    cc.addKillFuture(ret);
                                    ComponentManagementService.this.killComponent(component).addResultListener((IResultListener)cc);
                                } else {
                                    CleanupCommand cc = (CleanupCommand)ComponentManagementService.this.ccs.get(cid);
                                    if (cc == null) {
                                        ret.setException((Exception)new RuntimeException("No cleanup command for component " + cid + ": " + desc.getState()));
                                    }
                                    cc.addKillFuture(ret);
                                }
                            }
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }
            }
        }
        return ret;
    }

    protected IFuture destroyComponentLoop(final IComponentIdentifier cid, final IComponentIdentifier[] achildren, final int i) {
        final Future ret = new Future();
        if (achildren.length > 0) {
            this.destroyComponent(achildren[i]).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    if (i + 1 < achildren.length) {
                        ComponentManagementService.this.destroyComponentLoop(cid, achildren, i + 1).addResultListener((IResultListener)new DelegationResultListener(ret));
                    } else {
                        ret.setResult(null);
                    }
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture suspendComponent(final IComponentIdentifier cid) {
        final Future ret = new Future();
        if (this.isRemoteComponent(cid)) {
            SServiceProvider.getService((IServiceProvider)this.provider, (Class)IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                    rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentManagementService.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            IComponentManagementService rcms = (IComponentManagementService)result;
                            rcms.suspendComponent(cid).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            IComponentListener[] alisteners;
            CMSComponentDescription ad;
            Map map;
            Map map2 = this.adapters;
            synchronized (map2) {
                map = this.descs;
                synchronized (map) {
                    CMSComponentDescription desc = (CMSComponentDescription)this.descs.get(cid);
                    IComponentIdentifier[] achildren = desc.getChildren();
                    for (int i = 0; i < achildren.length; ++i) {
                        if (!"active".equals(((IComponentDescription)this.descs.get(achildren[i])).getState())) continue;
                        this.suspendComponent(achildren[i]);
                    }
                    IComponentAdapter adapter = (IComponentAdapter)this.adapters.get(cid);
                    ad = (CMSComponentDescription)this.descs.get(cid);
                    if (adapter == null || ad == null) {
                        ret.setException((Exception)new RuntimeException("Component identifier not registered: " + cid));
                        return ret;
                    }
                    if (!"active".equals(ad.getState())) {
                        ret.setException((Exception)new RuntimeException("Component identifier not registered: " + cid));
                        return ret;
                    }
                    ad.setState("suspended");
                    this.cancel(adapter).addResultListener((IResultListener)new DelegationResultListener(ret));
                }
            }
            map = this.listeners;
            synchronized (map) {
                HashSet slisteners = new HashSet(this.listeners.getCollection(null));
                slisteners.addAll(this.listeners.getCollection((Object)cid));
                alisteners = slisteners.toArray(new IComponentListener[slisteners.size()]);
            }
            for (int i = 0; i < alisteners.length; ++i) {
                alisteners[i].componentChanged((IComponentDescription)ad);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture resumeComponent(final IComponentIdentifier cid) {
        final Future ret = new Future();
        if (this.isRemoteComponent(cid)) {
            SServiceProvider.getService((IServiceProvider)this.provider, (Class)IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                    rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentManagementService.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            IComponentManagementService rcms = (IComponentManagementService)result;
                            rcms.resumeComponent(cid).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            CMSComponentDescription ad;
            Map map;
            boolean changed = false;
            Map map2 = this.adapters;
            synchronized (map2) {
                map = this.descs;
                synchronized (map) {
                    CMSComponentDescription desc = (CMSComponentDescription)this.descs.get(cid);
                    IComponentIdentifier[] achildren = desc.getChildren();
                    for (int i = 0; i < achildren.length; ++i) {
                        this.resumeComponent(achildren[i]);
                    }
                    IComponentAdapter adapter = (IComponentAdapter)this.adapters.get(cid);
                    ad = (CMSComponentDescription)this.descs.get(cid);
                    if (adapter == null || ad == null) {
                        ret.setException((Exception)new RuntimeException("Component identifier not registered: " + cid));
                        return ret;
                    }
                    if ("suspended".equals(ad.getState())) {
                        ad.setState("active");
                        adapter.wakeup();
                        changed = true;
                    }
                }
            }
            if (changed) {
                IComponentListener[] alisteners;
                map = this.listeners;
                synchronized (map) {
                    HashSet slisteners = new HashSet(this.listeners.getCollection(null));
                    slisteners.addAll(this.listeners.getCollection((Object)cid));
                    alisteners = slisteners.toArray(new IComponentListener[slisteners.size()]);
                }
                for (int i = 0; i < alisteners.length; ++i) {
                    alisteners[i].componentChanged((IComponentDescription)ad);
                }
            }
            ret.setResult((Object)ad);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture stepComponent(final IComponentIdentifier cid) {
        final Future ret = new Future();
        if (this.isRemoteComponent(cid)) {
            SServiceProvider.getService((IServiceProvider)this.provider, (Class)IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                    rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentManagementService.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            IComponentManagementService rcms = (IComponentManagementService)result;
                            rcms.stepComponent(cid).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            Map map = this.adapters;
            synchronized (map) {
                Map map2 = this.descs;
                synchronized (map2) {
                    IComponentAdapter adapter = (IComponentAdapter)this.adapters.get(cid);
                    IComponentDescription cd = (IComponentDescription)this.descs.get(cid);
                    if (adapter == null || cd == null) {
                        ret.setException((Exception)new RuntimeException("Component identifier not registered: " + cid));
                        return ret;
                    }
                    if (!"suspended".equals(cd.getState())) {
                        ret.setException((Exception)new RuntimeException("Only suspended components can be stepped: " + cid + " " + cd.getState()));
                        return ret;
                    }
                    this.doStep(adapter).addResultListener((IResultListener)new DelegationResultListener(ret));
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture setComponentBreakpoints(final IComponentIdentifier cid, final String[] breakpoints) {
        final Future ret = new Future();
        if (this.isRemoteComponent(cid)) {
            SServiceProvider.getService((IServiceProvider)this.provider, (Class)IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                    rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ComponentManagementService.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            IComponentManagementService rcms = (IComponentManagementService)result;
                            rcms.setComponentBreakpoints(cid, breakpoints).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            IComponentListener[] alisteners;
            CMSComponentDescription ad;
            Map map = this.descs;
            synchronized (map) {
                ad = (CMSComponentDescription)this.descs.get(cid);
                ad.setBreakpoints(breakpoints);
            }
            MultiCollection multiCollection = this.listeners;
            synchronized (multiCollection) {
                HashSet slisteners = new HashSet(this.listeners.getCollection(null));
                slisteners.addAll(this.listeners.getCollection((Object)cid));
                alisteners = slisteners.toArray(new IComponentListener[slisteners.size()]);
            }
            for (int i = 0; i < alisteners.length; ++i) {
                alisteners[i].componentChanged((IComponentDescription)ad);
            }
            ret.setResult(null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponentListener(IComponentIdentifier comp, IComponentListener listener) {
        MultiCollection multiCollection = this.listeners;
        synchronized (multiCollection) {
            this.listeners.put((Object)comp, (Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponentListener(IComponentIdentifier comp, IComponentListener listener) {
        MultiCollection multiCollection = this.listeners;
        synchronized (multiCollection) {
            this.listeners.remove((Object)comp, (Object)listener);
        }
    }

    public IFuture getExternalAccess(final IComponentIdentifier cid) {
        final Future ret = new Future();
        if (cid == null) {
            ret.setException((Exception)new IllegalArgumentException("Identifier is null."));
            return ret;
        }
        if (this.isRemoteComponent(cid)) {
            SServiceProvider.getService((IServiceProvider)this.provider, (Class)IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                    rms.getExternalAccessProxy(cid).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            ret.setResult(result);
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            });
        } else {
            IComponentAdapter adapter = (IComponentAdapter)this.adapters.get(cid);
            if (adapter == null) {
                ret.setException((Exception)new RuntimeException("No local component found for component identifier: " + cid));
            } else {
                try {
                    ret.setResult((Object)this.getComponentInstance(adapter).getExternalAccess());
                }
                catch (Exception e) {
                    ret.setException(e);
                }
            }
        }
        return ret;
    }

    public IComponentIdentifier getParentIdentifier(CreationInfo ci) {
        IComponentIdentifier rt = this.root.getComponentIdentifier();
        IComponentIdentifier ret = ci == null ? rt : (ci.getParent() == null ? rt : ci.getParent());
        return ret;
    }

    public IFuture getParent(IComponentIdentifier cid) {
        CMSComponentDescription desc = (CMSComponentDescription)this.descs.get(cid);
        return new Future((Object)(desc != null ? desc.getParent() : null));
    }

    public IFuture getChildren(IComponentIdentifier cid) {
        Future ret = new Future();
        CMSComponentDescription desc = (CMSComponentDescription)this.descs.get(cid);
        IComponentIdentifier[] tmp = desc != null ? (desc.getChildren() != null ? desc.getChildren() : IComponentIdentifier.EMPTY_COMPONENTIDENTIFIERS) : IComponentIdentifier.EMPTY_COMPONENTIDENTIFIERS;
        ret.setResult((Object)tmp);
        return ret;
    }

    public IComponentIdentifier createComponentIdentifier(String name) {
        return this.createComponentIdentifier(name, true);
    }

    public IComponentIdentifier createComponentIdentifier(String name, boolean local) {
        return this.createComponentIdentifier(name, local, this.msgservice != null ? this.msgservice.getAddresses() : null);
    }

    public IComponentIdentifier createComponentIdentifier(String name, boolean local, String[] addresses) {
        if (local) {
            name = name + "@" + ((IComponentIdentifier)this.provider.getId()).getPlatformName();
        }
        return new ComponentIdentifier(name, addresses, null);
    }

    public ISearchConstraints createSearchConstraints(int maxresults, int maxdepth) {
        SearchConstraints ret = new SearchConstraints();
        ret.setMaxResults(maxresults);
        ret.setMaxDepth(maxdepth);
        return ret;
    }

    public IComponentDescription createComponentDescription(IComponentIdentifier id, String state, String ownership, String type, IComponentIdentifier parent, String modelname) {
        CMSComponentDescription ret = new CMSComponentDescription(id, type, parent, false, false, false, modelname);
        ret.setState(state);
        ret.setOwnership(ownership);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture getComponentDescription(IComponentIdentifier cid) {
        IComponentDescription desc;
        Future ret = new Future();
        Map map = this.descs;
        synchronized (map) {
            desc = (IComponentDescription)this.descs.get(cid);
            if (desc != null) {
                desc = (IComponentDescription)((CMSComponentDescription)desc).clone();
            }
        }
        if (desc != null) {
            ret.setResult((Object)desc);
        } else {
            ret.setException((Exception)new RuntimeException("No description available for: " + cid));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture getComponentDescriptions() {
        IComponentDescription[] ret;
        Future fut = new Future();
        Map map = this.descs;
        synchronized (map) {
            ret = new IComponentDescription[this.descs.size()];
            Iterator it = this.descs.values().iterator();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IComponentDescription)((CMSComponentDescription)it.next()).clone();
            }
        }
        fut.setResult((Object)ret);
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture getComponentIdentifiers() {
        IComponentIdentifier[] ret;
        Future fut = new Future();
        Map map = this.adapters;
        synchronized (map) {
            ret = this.adapters.keySet().toArray(new IComponentIdentifier[this.adapters.size()]);
        }
        fut.setResult((Object)ret);
        return fut;
    }

    public IFuture searchComponents(IComponentDescription adesc, ISearchConstraints con) {
        return this.searchComponents(adesc, con, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture searchComponents(final IComponentDescription adesc, final ISearchConstraints con, boolean remote) {
        final Future fut = new Future();
        final ArrayList<CMSComponentDescription> ret = new ArrayList<CMSComponentDescription>();
        if (adesc != null && adesc.getName() != null) {
            CMSComponentDescription ad = (CMSComponentDescription)this.descs.get(adesc.getName());
            if (ad != null && ad.getName().equals(adesc.getName())) {
                CMSComponentDescription desc = (CMSComponentDescription)ad.clone();
                ret.add(desc);
            }
        } else {
            Map map = this.descs;
            synchronized (map) {
                Iterator it = this.descs.values().iterator();
                while (it.hasNext()) {
                    CMSComponentDescription test = (CMSComponentDescription)it.next();
                    if (adesc != null && (adesc.getOwnership() != null && !adesc.getOwnership().equals(test.getOwnership()) || adesc.getParent() != null && !adesc.getParent().equals(test.getParent()) || adesc.getType() != null && !adesc.getType().equals(test.getType()) || adesc.getState() != null && !adesc.getState().equals(test.getState()) || adesc.getProcessingState() != null && !adesc.getProcessingState().equals(test.getProcessingState()) || adesc.getModelName() != null && !adesc.getModelName().equals(test.getModelName()))) continue;
                    ret.add(test);
                }
            }
        }
        if (remote) {
            SServiceProvider.getServices((IServiceProvider)this.provider, (Class)IComponentManagementService.class, (boolean)true, (boolean)true).addResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    Collection coll = (Collection)result;
                    CollectionResultListener lis = new CollectionResultListener(coll.size(), true, new IResultListener(){

                        public void resultAvailable(Object source, Object result) {
                            Iterator it = ((Collection)result).iterator();
                            while (it.hasNext()) {
                                IComponentDescription[] res = (IComponentDescription[])it.next();
                                if (res == null) continue;
                                for (int i = 0; i < res.length; ++i) {
                                    ret.add(res[i]);
                                }
                            }
                            fut.setResult((Object)ret.toArray(new CMSComponentDescription[ret.size()]));
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            fut.setException(exception);
                        }
                    });
                    Iterator it = coll.iterator();
                    while (it.hasNext()) {
                        IComponentManagementService remotecms = (IComponentManagementService)it.next();
                        if (remotecms != ComponentManagementService.this) {
                            remotecms.searchComponents(adesc, con, false).addResultListener((IResultListener)lis);
                            continue;
                        }
                        lis.resultAvailable(null, null);
                    }
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    fut.setResult((Object)ret.toArray(new CMSComponentDescription[ret.size()]));
                }
            });
        } else {
            fut.setResult((Object)ret.toArray(new CMSComponentDescription[ret.size()]));
        }
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentIdentifier generateComponentIdentifier(String name) {
        ComponentIdentifier ret = null;
        Map map = this.adapters;
        synchronized (map) {
            while (this.adapters.containsKey(ret = new ComponentIdentifier(name + compcnt++ + "@" + ((IComponentIdentifier)this.provider.getId()).getPlatformName()))) {
            }
        }
        if (this.msgservice != null) {
            ret.setAddresses(this.msgservice.getAddresses());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessingState(IComponentIdentifier comp, String state) {
        CMSComponentDescription desc = null;
        Map map = this.descs;
        synchronized (map) {
            desc = (CMSComponentDescription)this.descs.get(comp);
            if (desc != null) {
                desc.setProcessingState(state);
            }
        }
        if (desc != null) {
            IComponentListener[] alisteners;
            MultiCollection multiCollection = this.listeners;
            synchronized (multiCollection) {
                HashSet slisteners = new HashSet(this.listeners.getCollection(null));
                slisteners.addAll(this.listeners.getCollection((Object)comp));
                alisteners = slisteners.toArray(new IComponentListener[slisteners.size()]);
            }
            for (int i = 0; i < alisteners.length; ++i) {
                try {
                    alisteners[i].componentChanged((IComponentDescription)desc);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("WARNING: Exception when changing component state: " + desc + ", " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentState(IComponentIdentifier comp, String state) {
        IComponentListener[] alisteners;
        if (!$assertionsDisabled && !"suspended".equals(state)) {
            throw new AssertionError((Object)("wrong state: " + comp + ", " + state));
        }
        CMSComponentDescription desc = null;
        Map map = this.descs;
        synchronized (map) {
            desc = (CMSComponentDescription)this.descs.get(comp);
            desc.setState(state);
        }
        MultiCollection multiCollection = this.listeners;
        synchronized (multiCollection) {
            HashSet slisteners = new HashSet(this.listeners.getCollection(null));
            slisteners.addAll(this.listeners.getCollection((Object)comp));
            alisteners = slisteners.toArray(new IComponentListener[slisteners.size()]);
        }
        for (int i = 0; i < alisteners.length; ++i) {
            try {
                alisteners[i].componentChanged((IComponentDescription)desc);
                continue;
            }
            catch (Exception e) {
                System.out.println("WARNING: Exception when changing component state: " + desc + ", " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentException(IComponentIdentifier comp, Exception e) {
        Map map = this.descs;
        synchronized (map) {
            if (this.exceptions == null) {
                this.exceptions = new HashMap();
            }
            this.exceptions.put(comp, e);
            Object[] infos = (Object[])this.initinfos.get(comp);
            if (infos != null) {
                ((Future)infos[4]).setException(e);
            }
        }
    }

    public IFuture startService() {
        final Future ret = new Future();
        super.startService().addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                final boolean[] services = new boolean[2];
                SServiceProvider.getService((IServiceProvider)ComponentManagementService.this.provider, (Class)(class$jadex$commons$service$execution$IExecutionService == null ? (class$jadex$commons$service$execution$IExecutionService = ComponentManagementService.class$("jadex.commons.service.execution.IExecutionService")) : class$jadex$commons$service$execution$IExecutionService)).addResultListener((IResultListener)new DefaultResultListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultAvailable(Object source, Object result) {
                        (this).ComponentManagementService.this.exeservice = (IExecutionService)result;
                        boolean[] blArray = services;
                        synchronized (services) {
                            services[0] = true;
                            boolean setresult = services[0] && services[1];
                            // ** MonitorExit[var4_3] (shouldn't be in output)
                            if (setresult) {
                                ret.setResult((Object)ComponentManagementService.this);
                            }
                            return;
                        }
                    }
                });
                SServiceProvider.getService((IServiceProvider)ComponentManagementService.this.provider, (Class)(class$jadex$bridge$IMessageService == null ? (class$jadex$bridge$IMessageService = ComponentManagementService.class$("jadex.bridge.IMessageService")) : class$jadex$bridge$IMessageService)).addResultListener((IResultListener)new DefaultResultListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    public void resultAvailable(Object source, Object result) {
                        (this).ComponentManagementService.this.msgservice = (IMessageService)result;
                        Object object = services;
                        // MONITORENTER : services
                        services[1] = true;
                        boolean setresult = services[0] && services[1];
                        // MONITOREXIT : object
                        if ((this).ComponentManagementService.this.root != null) {
                            if ((this).ComponentManagementService.this.msgservice != null) {
                                (this).ComponentManagementService.this.msgservice.signalStarted().addResultListener(new IResultListener(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void resultAvailable(Object source, Object result) {
                                        Map map = ((this).this).ComponentManagementService.this.adapters;
                                        synchronized (map) {
                                            Map map2 = ((this).this).ComponentManagementService.this.descs;
                                            synchronized (map2) {
                                                ((ComponentIdentifier)((this).this).ComponentManagementService.this.root.getComponentIdentifier()).setAddresses(((this).this).ComponentManagementService.this.msgservice.getAddresses());
                                                ((this).this).ComponentManagementService.this.adapters.put(((this).this).ComponentManagementService.this.root.getComponentIdentifier(), ((this).this).ComponentManagementService.this.root);
                                                IComponentDescription desc = ComponentManagementService.this.getDescription(((this).this).ComponentManagementService.this.root);
                                                ((this).this).ComponentManagementService.this.descs.put(((this).this).ComponentManagementService.this.root.getComponentIdentifier(), desc);
                                            }
                                        }
                                    }

                                    public void exceptionOccurred(Object source, Exception exception) {
                                    }
                                });
                            } else {
                                Map map = (this).ComponentManagementService.this.adapters;
                                object = map;
                                // MONITORENTER : map
                                Map map2 = (this).ComponentManagementService.this.descs;
                                // MONITORENTER : map2
                                (this).ComponentManagementService.this.adapters.put((this).ComponentManagementService.this.root.getComponentIdentifier(), (this).ComponentManagementService.this.root);
                                IComponentDescription desc = ComponentManagementService.this.getDescription((this).ComponentManagementService.this.root);
                                (this).ComponentManagementService.this.descs.put((this).ComponentManagementService.this.root.getComponentIdentifier(), desc);
                                // MONITOREXIT : map2
                                // MONITOREXIT : object
                            }
                        }
                        if (!setresult) return;
                        ret.setResult((Object)ComponentManagementService.this);
                    }
                });
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public IFuture shutdownService() {
        return super.shutdownService();
    }

    protected boolean isInitSuspend(CreationInfo cinfo, IModelInfo lmodel) {
        boolean pasuspend = false;
        Object[] painfo = this.getParentInfo(cinfo);
        if (painfo != null) {
            pasuspend = this.isInitSuspend((CreationInfo)painfo[2], (IModelInfo)painfo[3]);
        } else {
            CMSComponentDescription padesc = (CMSComponentDescription)this.descs.get(this.getParentIdentifier(cinfo));
            pasuspend = "suspended".equals(padesc.getState());
        }
        Object debugging = lmodel.getProperties().get("debugging");
        boolean suspend = cinfo.isSuspend() || pasuspend || debugging instanceof Boolean && (Boolean)debugging != false;
        return suspend;
    }

    public IMessageService getMessageService() {
        return this.msgservice;
    }

    public IExecutionService getExecutionService() {
        return this.exeservice;
    }

    static {
        $assertionsDisabled = !ComponentManagementService.class.desiredAssertionStatus();
        compcnt = 0;
    }

    class CleanupCommand
    implements IResultListener {
        protected IComponentIdentifier cid;
        protected List killfutures;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CleanupCommand(IComponentIdentifier cid) {
            this.cid = cid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultAvailable(Object source, Object result) {
            IResultListener reslis;
            IComponentListener[] alisteners;
            CMSComponentDescription desc;
            Map map;
            boolean killparent = false;
            IComponentAdapter adapter = null;
            IComponentAdapter pad = null;
            Map results = null;
            Map map2 = ComponentManagementService.this.adapters;
            synchronized (map2) {
                map = ComponentManagementService.this.descs;
                synchronized (map) {
                    adapter = (IComponentAdapter)ComponentManagementService.this.adapters.remove(this.cid);
                    if (adapter == null) {
                        throw new RuntimeException("Component Identifier not registered: " + this.cid);
                    }
                    results = ComponentManagementService.this.getComponentInstance(adapter).getResults();
                    desc = (CMSComponentDescription)ComponentManagementService.this.descs.remove(this.cid);
                    desc.setState("terminated");
                    ComponentManagementService.this.ccs.remove(this.cid);
                    if (desc.getParent() != null) {
                        ComponentManagementService.this.cancel(adapter);
                        killparent = desc.isMaster();
                        CMSComponentDescription padesc = (CMSComponentDescription)ComponentManagementService.this.descs.get(desc.getParent());
                        if (padesc != null) {
                            padesc.removeChild(desc.getName());
                            if (padesc.isAutoShutdown() && !desc.isDaemon()) {
                                Integer childcount = (Integer)ComponentManagementService.this.childcounts.get(padesc.getName());
                                if (!($assertionsDisabled || childcount != null && childcount > 0)) {
                                    throw new AssertionError();
                                }
                                boolean bl = killparent = childcount == null || childcount <= 1;
                                if (!killparent) {
                                    ComponentManagementService.this.childcounts.put(padesc.getName(), new Integer(childcount - 1));
                                }
                            }
                        }
                        pad = (IComponentAdapter)ComponentManagementService.this.adapters.get(desc.getParent());
                    }
                }
            }
            if (pad != null) {
                ComponentManagementService.this.getComponentInstance(pad).componentDestroyed((IComponentDescription)desc);
            }
            map = ComponentManagementService.this.listeners;
            synchronized (map) {
                HashSet slisteners = new HashSet(ComponentManagementService.this.listeners.getCollection(null));
                slisteners.addAll(ComponentManagementService.this.listeners.getCollection((Object)this.cid));
                alisteners = slisteners.toArray(new IComponentListener[slisteners.size()]);
            }
            for (int i = 0; i < alisteners.length; ++i) {
                try {
                    alisteners[i].componentRemoved((IComponentDescription)desc, results);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("WARNING: Exception when removing component: " + desc + ", " + e);
                }
            }
            Exception ex = null;
            if (ComponentManagementService.this.exceptions != null && ComponentManagementService.this.exceptions.containsKey(this.cid)) {
                ex = (Exception)ComponentManagementService.this.exceptions.get(this.cid);
                ComponentManagementService.this.exceptions.remove(this.cid);
            }
            if ((reslis = (IResultListener)ComponentManagementService.this.killresultlisteners.remove(this.cid)) != null) {
                if (ex != null) {
                    reslis.exceptionOccurred((Object)this.cid, ex);
                } else {
                    reslis.resultAvailable((Object)this.cid, (Object)results);
                }
            } else if (ex != null) {
                adapter.getLogger().severe("Fatal error, component '" + this.cid + "' will be removed.");
                ex.printStackTrace();
            }
            if (this.killfutures != null) {
                for (int i = 0; i < this.killfutures.size(); ++i) {
                    ((Future)this.killfutures.get(i)).setResult(result);
                }
            }
            if (pad != null && killparent) {
                ComponentManagementService.this.destroyComponent(pad.getComponentIdentifier());
            }
        }

        public void exceptionOccurred(Object source, Exception exception) {
            this.resultAvailable(source, this.cid);
        }

        public void addKillFuture(Future killfuture) {
            if (this.killfutures == null) {
                this.killfutures = new ArrayList();
            }
            this.killfutures.add(killfuture);
        }

        static {
            $assertionsDisabled = !(class$jadex$base$service$cms$ComponentManagementService == null ? (class$jadex$base$service$cms$ComponentManagementService = ComponentManagementService.class$("jadex.base.service.cms.ComponentManagementService")) : class$jadex$base$service$cms$ComponentManagementService).desiredAssertionStatus();
        }
    }
}

