/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.base.service.remote.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ExceptionInfo {
    protected Class type;
    protected String message;
    protected List stacktrace;

    public ExceptionInfo() {
    }

    public ExceptionInfo(Exception ex) {
        this.type = ex.getClass();
        this.message = ex.getMessage();
        StackTraceElement[] stes = ex.getStackTrace();
        if (stes != null) {
            for (int i = 0; i < stes.length; ++i) {
                this.addStackTrace(new Object[]{stes[i].getClassName(), stes[i].getMethodName(), stes[i].getFileName(), new Integer(stes[i].getLineNumber())});
            }
        }
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List getStackTrace() {
        return this.stacktrace;
    }

    public void setStackTrace(List stacktrace) {
        this.stacktrace = stacktrace;
    }

    public void addStackTrace(Object[] ste) {
        if (this.stacktrace == null) {
            this.stacktrace = new ArrayList();
        }
        this.stacktrace.add(ste);
    }

    public RemoteException recreateException() {
        RemoteException ret = new RemoteException(this.type, this.message);
        if (this.stacktrace != null) {
            StackTraceElement[] stes = new StackTraceElement[this.stacktrace.size()];
            for (int i = 0; i < stes.length; ++i) {
                Object[] tmp = (Object[])this.stacktrace.get(i);
                stes[i] = new StackTraceElement((String)tmp[0], (String)tmp[1], (String)tmp[2], ((Number)tmp[3]).intValue());
            }
            ret.setStackTrace(stes);
        }
        return ret;
    }
}

