/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.base.service.remote.RemoteServiceContainer;
import jadex.bridge.Argument;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IArgument;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IRemoteServiceManagementService;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.collection.LRU;
import jadex.commons.concurrent.CollectionResultListener;
import jadex.commons.concurrent.DelegationResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.CacheServiceContainer;
import jadex.commons.service.IServiceContainer;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.commons.service.clock.IClockService;
import jadex.micro.MicroAgent;
import jadex.micro.MicroAgentMetaInfo;
import java.util.Collection;

public class ProxyAgent
extends MicroAgent {
    protected long delay;
    protected LRU children;
    static /* synthetic */ Class class$jadex$bridge$IComponentManagementService;

    public IServiceContainer createServiceContainer() {
        this.delay = ((Number)this.getArgument("delay")).longValue();
        int cachesize = ((Number)this.getArgument("cachesize")).intValue();
        this.children = new LRU(cachesize);
        return new CacheServiceContainer((IServiceContainer)new RemoteServiceContainer(this.getRemotePlatformIdentifier(), this.getAgentAdapter()), 25, 30000L);
    }

    public IComponentIdentifier getRemotePlatformIdentifier() {
        return (IComponentIdentifier)this.getArgument("component");
    }

    protected IFuture isInvalid(IComponentIdentifier cid) {
        final Future ret = new Future();
        final Object[] entry = (Object[])this.children.get((Object)cid);
        if (this.delay == 0L) {
            ret.setResult((Object)Boolean.FALSE);
        } else if (entry == null) {
            ret.setResult((Object)Boolean.TRUE);
        } else {
            SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IClockService.class).addResultListener(this.createResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    long lastaccess;
                    IClockService cs = (IClockService)result;
                    long time = cs.getTime();
                    ret.setResult((Object)(time > (lastaccess = ((Long)entry[0]).longValue()) + ProxyAgent.this.delay ? Boolean.TRUE : Boolean.FALSE));
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            }));
        }
        return ret;
    }

    public IFuture getVirtualChildren(final IComponentIdentifier cid, boolean force) {
        final Future ret = new Future();
        if (force) {
            this.searchVirtualChildren(cid).addResultListener(this.createResultListener((IResultListener)new DelegationResultListener(ret)));
        } else {
            this.isInvalid(cid).addResultListener(this.createResultListener(new IResultListener(){

                public void resultAvailable(Object source, Object result) {
                    if (((Boolean)result).booleanValue()) {
                        ProxyAgent.this.searchVirtualChildren(cid).addResultListener(ProxyAgent.this.createResultListener((IResultListener)new DelegationResultListener(ret)));
                    } else {
                        ret.setResult(((Object[])ProxyAgent.this.children.get((Object)cid))[1]);
                    }
                }

                public void exceptionOccurred(Object source, Exception exception) {
                    ret.setException(exception);
                }
            }));
        }
        return ret;
    }

    protected IFuture searchVirtualChildren(final IComponentIdentifier cid) {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IRemoteServiceManagementService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ProxyAgent.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener(ProxyAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        final IComponentManagementService rcms = (IComponentManagementService)result;
                        rcms.getChildren(cid).addResultListener(ProxyAgent.this.createResultListener(new IResultListener(){

                            public void resultAvailable(Object source, Object result) {
                                IComponentIdentifier[] tmp = (IComponentIdentifier[])result;
                                CollectionResultListener crl = new CollectionResultListener(tmp.length, false, (IResultListener)new DelegationResultListener(ret){

                                    public void customResultAvailable(Object source, Object result) {
                                        final Collection vcs = (Collection)result;
                                        SServiceProvider.getService((IServiceProvider)ProxyAgent.this.getServiceProvider(), (Class)(class$jadex$commons$service$clock$IClockService == null ? (class$jadex$commons$service$clock$IClockService = ProxyAgent.class$("jadex.commons.service.clock.IClockService")) : class$jadex$commons$service$clock$IClockService)).addResultListener(ProxyAgent.this.createResultListener(new IResultListener(){

                                            public void resultAvailable(Object source, Object result) {
                                                IClockService cs = (IClockService)result;
                                                long lastaccess = cs.getTime();
                                                ((((this).this).this).this).ProxyAgent.this.children.put((Object)cid, (Object)new Object[]{new Long(lastaccess), vcs});
                                                ret.setResult((Object)vcs);
                                            }

                                            public void exceptionOccurred(Object source, Exception exception) {
                                                ret.setException(exception);
                                            }
                                        }));
                                    }
                                });
                                for (int i = 0; i < tmp.length; ++i) {
                                    rcms.getComponentDescription(tmp[i]).addResultListener(ProxyAgent.this.createResultListener((IResultListener)crl));
                                }
                            }

                            public void exceptionOccurred(Object source, Exception exception) {
                                ret.setException(exception);
                            }
                        }));
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        ret.setException(exception);
                    }
                }));
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public IFuture getRemoteComponentDescription(final IComponentIdentifier cid) {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IRemoteServiceManagementService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                rms.getServiceProxy(cid, class$jadex$bridge$IComponentManagementService == null ? (class$jadex$bridge$IComponentManagementService = ProxyAgent.class$("jadex.bridge.IComponentManagementService")) : class$jadex$bridge$IComponentManagementService).addResultListener(ProxyAgent.this.createResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        IComponentManagementService rcms = (IComponentManagementService)result;
                        rcms.getComponentDescription(cid).addResultListener(ProxyAgent.this.createResultListener((IResultListener)new DelegationResultListener(ret)));
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        ret.setException(exception);
                    }
                }));
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public IFuture getRemoteServices(final IComponentIdentifier cid) {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.getServiceProvider(), (Class)IRemoteServiceManagementService.class).addResultListener(this.createResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IRemoteServiceManagementService rms = (IRemoteServiceManagementService)result;
                rms.getDeclaredServiceProxies(cid).addResultListener(ProxyAgent.this.createResultListener((IResultListener)new DelegationResultListener(ret)));
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public static Object getMetaInfo() {
        return new MicroAgentMetaInfo("This agent represents a proxy for a remote component.", new String[0], new IArgument[]{new Argument("component", "The component id of the remote component/platform", "jadex.bridge.IComponentIdentifier", (Object)new ComponentIdentifier("remote", new String[]{"tcp-mtp://127.0.0.1:11000", "nio-mtp://127.0.0.1:11001"})), new Argument("delay", "The cache delay, determines the time how long a virtual children search is valid", "long", (Object)new Long(10000L)), new Argument("cachesize", "The maximum number of entries in the cache.", "int", (Object)new Integer(1000))}, null, null, null);
    }
}

