/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.base.service.remote.IMethodReplacement;
import jadex.base.service.remote.MethodInfo;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.service.IServiceIdentifier;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProxyInfo {
    protected IComponentIdentifier rms;
    protected IServiceIdentifier sid;
    protected Map cache;
    protected Set excluded;
    protected Set uncached;
    protected Set synchronous;
    protected Map replacements;
    protected IComponentIdentifier cid;
    protected Class targetclass;

    public ProxyInfo() {
    }

    public ProxyInfo(IComponentIdentifier rms, IServiceIdentifier sid) {
        this.rms = rms;
        this.sid = sid;
    }

    public ProxyInfo(IComponentIdentifier rms, IComponentIdentifier cid, Class targetclass) {
        this.rms = rms;
        this.cid = cid;
        this.targetclass = targetclass;
    }

    public IComponentIdentifier getRemoteManagementServiceIdentifier() {
        return this.rms;
    }

    public void setRemoteManagementServiceIdentifier(IComponentIdentifier rms) {
        this.rms = rms;
    }

    public IServiceIdentifier getServiceIdentifier() {
        return this.sid;
    }

    public void setServiceIdentifier(IServiceIdentifier sid) {
        this.sid = sid;
    }

    public Map getCache() {
        return this.cache;
    }

    public void setCache(Map cache) {
        this.cache = cache;
    }

    public void putCache(Object key, Object value) {
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        this.cache.put(key, value);
    }

    public Map getMethodReplacements() {
        return this.replacements;
    }

    public void setMethodReplacements(Map replacements) {
        this.replacements = replacements;
    }

    public void addMethodReplacement(MethodInfo method, IMethodReplacement replacement) {
        if (this.replacements == null) {
            this.replacements = new HashMap();
        }
        this.replacements.put(method, replacement);
    }

    public IMethodReplacement getMethodReplacement(Method method) {
        IMethodReplacement ret = null;
        if (this.replacements != null) {
            ret = (IMethodReplacement)this.replacements.get(new MethodInfo(method));
        }
        return ret;
    }

    public boolean isReplaced(Method m) {
        return this.replacements != null && this.replacements.containsKey(new MethodInfo(m));
    }

    public IComponentIdentifier getComponentIdentifier() {
        return this.cid;
    }

    public void setComponentIdentifier(IComponentIdentifier cid) {
        this.cid = cid;
    }

    public Class getTargetClass() {
        return this.targetclass;
    }

    public void setTargetClass(Class targetclass) {
        this.targetclass = targetclass;
    }

    public Set getExcludedMethods() {
        return this.excluded;
    }

    public void setExcludedMethods(Set excluded) {
        this.excluded = excluded;
    }

    public void addExcludedMethod(MethodInfo m) {
        if (this.excluded == null) {
            this.excluded = new HashSet();
        }
        this.excluded.add(m);
    }

    public boolean isExcluded(Method m) {
        return this.excluded != null && this.excluded.contains(new MethodInfo(m));
    }

    public Set getUncachedMethods() {
        return this.uncached;
    }

    public void setUncachedMethods(Set uncached) {
        this.uncached = uncached;
    }

    public void addUncachedMethod(MethodInfo m) {
        if (this.uncached == null) {
            this.uncached = new HashSet();
        }
        this.uncached.add(m);
    }

    public boolean isUncached(Method m) {
        return this.uncached != null && this.uncached.contains(new MethodInfo(m));
    }

    public Set getSynchronousMethods() {
        return this.synchronous;
    }

    public void setSynchronousMethods(Set synchronous) {
        this.synchronous = synchronous;
    }

    public void addSynchronousMethod(MethodInfo m) {
        if (this.synchronous == null) {
            this.synchronous = new HashSet();
        }
        this.synchronous.add(m);
    }

    public boolean isSynchronous(Method m) {
        return this.synchronous != null && this.synchronous.contains(new MethodInfo(m));
    }

    public String toString() {
        return "ProxyInfo(rms=" + this.rms + ", sid=" + this.sid + ", cache=" + this.cache + ", excluded=" + this.excluded + ", uncached=" + this.uncached + ", synchronous=" + this.synchronous + ", replacements=" + this.replacements + ", cid=" + this.cid + ", targetclass=" + this.targetclass + ")";
    }
}

