/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.base.service.remote.IRemoteCommand;
import jadex.base.service.remote.ProxyInfo;
import jadex.base.service.remote.RemoteGetResultCommand;
import jadex.base.service.remote.RemoteSearchCommand;
import jadex.base.service.remote.RemoteSearchResultCommand;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.SReflect;
import jadex.commons.collection.LRU;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.micro.IMicroExternalAccess;
import java.util.Collections;
import java.util.Map;

public class RemoteGetExternalAccessCommand
implements IRemoteCommand {
    protected static Map proxyinfos = Collections.synchronizedMap(new LRU(200));
    protected IComponentIdentifier cid;
    protected String callid;

    public RemoteGetExternalAccessCommand() {
    }

    public RemoteGetExternalAccessCommand(IComponentIdentifier cid, String callid) {
        this.cid = cid;
        this.callid = callid;
    }

    public IFuture execute(final IMicroExternalAccess component, Map waitingcalls) {
        final Future ret = new Future();
        final IComponentIdentifier compid = this.cid != null ? this.cid : component.getComponentIdentifier();
        SServiceProvider.getServiceUpwards((IServiceProvider)component.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                cms.getExternalAccess(compid).addResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        IExternalAccess exta = (IExternalAccess)result;
                        ProxyInfo pi = RemoteGetExternalAccessCommand.this.getProxyInfo(component.getComponentIdentifier(), exta);
                        ret.setResult((Object)new RemoteGetResultCommand(pi, null, (this).RemoteGetExternalAccessCommand.this.callid));
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        ret.setResult((Object)new RemoteGetResultCommand(null, exception, (this).RemoteGetExternalAccessCommand.this.callid));
                    }
                });
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setResult((Object)new RemoteSearchResultCommand(null, exception, RemoteGetExternalAccessCommand.this.callid));
            }
        });
        return ret;
    }

    public Object getTargetId() {
        return this.cid;
    }

    public void setTargetId(IComponentIdentifier providerid) {
        this.cid = providerid;
    }

    public String getCallId() {
        return this.callid;
    }

    public void setCallId(String callid) {
        this.callid = callid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyInfo getProxyInfo(IComponentIdentifier rms, IExternalAccess target) {
        ProxyInfo ret = (ProxyInfo)proxyinfos.get(target);
        if (ret == null) {
            Map map = proxyinfos;
            synchronized (map) {
                ret = (ProxyInfo)proxyinfos.get(target);
                if (ret == null) {
                    ret = this.createProxyInfo(rms, target);
                }
            }
        }
        return ret;
    }

    protected ProxyInfo createProxyInfo(IComponentIdentifier rms, IExternalAccess target) {
        Class targetclass = null;
        Class<?>[] inter = target.getClass().getInterfaces();
        for (int i = 0; i < inter.length && targetclass == null; ++i) {
            if (SReflect.isSupertype((Class)(class$jadex$bridge$IExternalAccess == null ? RemoteGetExternalAccessCommand.class$("jadex.bridge.IExternalAccess") : class$jadex$bridge$IExternalAccess), inter[0])) {
                // empty if block
            }
            targetclass = inter[i];
        }
        if (targetclass == null) {
            targetclass = IExternalAccess.class;
        }
        ProxyInfo ret = new ProxyInfo(rms, this.cid, targetclass);
        Map props = target.getModel().getProperties();
        RemoteSearchCommand.fillProxyInfo(ret, target, targetclass, props);
        return ret;
    }
}

