/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.base.service.remote.IRemoteCommand;
import jadex.base.service.remote.RemoteResultCommand;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.IServiceIdentifier;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.micro.IMicroExternalAccess;
import java.lang.reflect.Method;
import java.util.Map;

public class RemoteMethodInvocationCommand
implements IRemoteCommand {
    protected IServiceIdentifier sid;
    protected IComponentIdentifier cid;
    protected String methodname;
    protected Class[] parametertypes;
    protected Object[] parametervalues;
    protected String callid;
    protected IComponentIdentifier rms;

    public RemoteMethodInvocationCommand() {
    }

    public RemoteMethodInvocationCommand(IServiceIdentifier sid, String methodname, Class[] parametertypes, Object[] parametervalues, String callid, IComponentIdentifier rms) {
        this.sid = sid;
        this.methodname = methodname;
        this.parametertypes = parametertypes;
        this.parametervalues = parametervalues;
        this.callid = callid;
        this.rms = rms;
    }

    public RemoteMethodInvocationCommand(IComponentIdentifier cid, String methodname, Class[] parametertypes, Object[] parametervalues, String callid, IComponentIdentifier rms) {
        this.cid = cid;
        this.methodname = methodname;
        this.parametertypes = parametertypes;
        this.parametervalues = parametervalues;
        this.callid = callid;
        this.rms = rms;
    }

    public IFuture execute(IMicroExternalAccess component, Map waitingcalls) {
        final Future ret = new Future();
        SServiceProvider.getServiceUpwards((IServiceProvider)component.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                cms.getExternalAccess(RemoteMethodInvocationCommand.this.getTargetId()).addResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        IExternalAccess exta = (IExternalAccess)result;
                        if ((this).RemoteMethodInvocationCommand.this.sid != null) {
                            SServiceProvider.getDeclaredService((IServiceProvider)exta.getServiceProvider(), (IServiceIdentifier)(this).RemoteMethodInvocationCommand.this.sid).addResultListener(new IResultListener(){

                                public void resultAvailable(Object source, Object result) {
                                    RemoteMethodInvocationCommand.this.invokeMethod(result, ret);
                                }

                                public void exceptionOccurred(Object source, Exception exception) {
                                    ret.setResult((Object)new RemoteResultCommand(null, exception, ((this).this).RemoteMethodInvocationCommand.this.callid));
                                }
                            });
                        } else {
                            RemoteMethodInvocationCommand.this.invokeMethod(exta, ret);
                        }
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        ret.setResult((Object)new RemoteResultCommand(null, exception, (this).RemoteMethodInvocationCommand.this.callid));
                    }
                });
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setResult((Object)new RemoteResultCommand(null, exception, RemoteMethodInvocationCommand.this.callid));
            }
        });
        return ret;
    }

    public void invokeMethod(Object target, final Future ret) {
        try {
            Method m = target.getClass().getMethod(this.methodname, this.parametertypes);
            Object res = m.invoke(target, this.parametervalues);
            if (res instanceof IFuture) {
                ((IFuture)res).addResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        ret.setResult((Object)new RemoteResultCommand(result, null, RemoteMethodInvocationCommand.this.callid));
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        ret.setResult((Object)new RemoteResultCommand(null, exception, RemoteMethodInvocationCommand.this.callid));
                    }
                });
            } else {
                ret.setResult((Object)new RemoteResultCommand(res, null, this.callid));
            }
        }
        catch (Exception exception) {
            ret.setResult((Object)new RemoteResultCommand(null, exception, this.callid));
        }
    }

    public IComponentIdentifier getTargetId() {
        return this.sid != null ? (IComponentIdentifier)this.sid.getProviderId() : this.cid;
    }

    public IComponentIdentifier getRemoteManagementServiceIdentifier() {
        return this.rms;
    }

    public IComponentIdentifier getComponentIdentifier() {
        return this.cid;
    }

    public void setComponentIdentifier(IComponentIdentifier cid) {
        this.cid = cid;
    }

    public void setRemoteManagementServiceIdentifier(IComponentIdentifier rms) {
        this.rms = rms;
    }

    public IServiceIdentifier getServiceIdentifier() {
        return this.sid;
    }

    public void setServiceIdentifier(IServiceIdentifier sid) {
        this.sid = sid;
    }

    public String getMethodName() {
        return this.methodname;
    }

    public void setMethodName(String methodname) {
        this.methodname = methodname;
    }

    public Class[] getParameterTypes() {
        return this.parametertypes;
    }

    public void setParameterTypes(Class[] parametertypes) {
        this.parametertypes = parametertypes;
    }

    public Object[] getParameterValues() {
        return this.parametervalues;
    }

    public void setParameterValues(Object[] parametervalues) {
        this.parametervalues = parametervalues;
    }

    public String getCallId() {
        return this.callid;
    }

    public void setCallId(String callid) {
        this.callid = callid;
    }

    public String toString() {
        return "RemoteMethodInvocationCommand(sid=" + this.sid + ", methodname=" + this.methodname + ", callid=" + this.callid + ")";
    }
}

