/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.base.service.remote.IMethodReplacement;
import jadex.base.service.remote.ProxyInfo;
import jadex.base.service.remote.RemoteMethodInvocationCommand;
import jadex.base.service.remote.RemoteServiceManagementService;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.ISuspendable;
import jadex.commons.SUtil;
import jadex.commons.ThreadSuspendable;
import jadex.micro.IMicroExternalAccess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

public class RemoteMethodInvocationHandler
implements InvocationHandler {
    protected IMicroExternalAccess component;
    protected ProxyInfo pi;
    protected Map waitingcalls;

    public RemoteMethodInvocationHandler(IMicroExternalAccess component, ProxyInfo pi, Map waitingcalls) {
        this.component = component;
        this.pi = pi;
        this.waitingcalls = waitingcalls;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Future future;
        IMethodReplacement replacement;
        if (this.pi.isExcluded(method)) {
            throw new UnsupportedOperationException("Method is excluded from interface for remote invocations.");
        }
        if (this.pi.getCache() != null && !this.pi.isUncached(method) && !this.pi.isReplaced(method)) {
            Class<?> rt = method.getReturnType();
            Class<?>[] ar = method.getParameterTypes();
            if (!rt.equals(Void.TYPE) && !rt.isAssignableFrom(IFuture.class) && ar.length == 0) {
                return this.pi.getCache().get(method.getName());
            }
        }
        if ((replacement = this.pi.getMethodReplacement(method)) != null) {
            return replacement.invoke(proxy, args);
        }
        Object ret = future = new Future();
        IComponentIdentifier compid = this.component.getComponentIdentifier();
        String callid = SUtil.createUniqueId((String)compid.getLocalName());
        RemoteMethodInvocationCommand content = this.pi.getServiceIdentifier() != null ? new RemoteMethodInvocationCommand(this.pi.getServiceIdentifier(), method.getName(), (Class[])method.getParameterTypes(), args, callid, compid) : new RemoteMethodInvocationCommand(this.pi.getComponentIdentifier(), method.getName(), (Class[])method.getParameterTypes(), args, callid, compid);
        RemoteServiceManagementService.sendMessage(this.component, this.pi.getRemoteManagementServiceIdentifier(), content, callid, -1L, this.waitingcalls, future);
        if (method.getReturnType().equals(Void.TYPE) && !this.pi.isSynchronous(method)) {
            future.setResult(null);
        } else if (!IFuture.class.isAssignableFrom(method.getReturnType())) {
            System.out.println("Warning, blocking method call: " + method.getDeclaringClass() + " " + method.getName() + " " + Thread.currentThread() + " " + this.pi);
            ret = future.get((ISuspendable)new ThreadSuspendable());
        }
        return ret;
    }
}

