/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.bridge.IComponentAdapter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IRemoteServiceManagementService;
import jadex.commons.Future;
import jadex.commons.IFuture;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.BasicServiceContainer;
import jadex.commons.service.IResultSelector;
import jadex.commons.service.ISearchManager;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.IVisitDecider;
import jadex.commons.service.SServiceProvider;
import java.util.Collection;
import java.util.Iterator;

public class RemoteServiceContainer
extends BasicServiceContainer {
    protected IComponentIdentifier componentid;
    protected IComponentAdapter adapter;
    protected IRemoteServiceManagementService rms;

    public RemoteServiceContainer(IComponentIdentifier componentid, IComponentAdapter adapter) {
        super((Object)adapter.getComponentIdentifier());
        this.adapter = adapter;
        this.componentid = componentid;
    }

    public IFuture getServices(ISearchManager manager, final IVisitDecider decider, final IResultSelector selector, final Collection results) {
        final Future ret = new Future();
        super.getServices(manager, decider, selector, results).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                if (!decider.searchNode(null, (IServiceProvider)RemoteServiceContainer.this, results) || RemoteServiceContainer.this.rms == null || RemoteServiceContainer.this.componentid == null) {
                    ret.setResult(selector.getResult(results));
                } else {
                    RemoteServiceContainer.this.rms.getServiceProxies(RemoteServiceContainer.this.componentid, SServiceProvider.sequentialmanager, decider, selector).addResultListener(new IResultListener(){

                        public void resultAvailable(Object source, Object res) {
                            if (res instanceof Collection) {
                                Iterator it = ((Collection)res).iterator();
                                while (it.hasNext()) {
                                    Object next = it.next();
                                    if (results.contains(next)) continue;
                                    results.add(next);
                                }
                            } else if (res != null && !results.contains(res)) {
                                results.add(res);
                            }
                            ret.setResult(selector.getResult(results));
                        }

                        public void exceptionOccurred(Object source, Exception exception) {
                            ret.setException(exception);
                        }
                    });
                }
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public IFuture getParent() {
        Future ret = new Future();
        ret.setResult(this.adapter.getParent() != null ? this.adapter.getParent().getServiceProvider() : null);
        return ret;
    }

    public IFuture getChildren() {
        Future ret = new Future(null);
        return ret;
    }

    public IFuture start() {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this, (Class)IRemoteServiceManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                RemoteServiceContainer.this.rms = (IRemoteServiceManagementService)result;
                ret.setResult(null);
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public IFuture shutdown() {
        return new Future(null);
    }

    public void addService(Class type, Object service) {
        throw new UnsupportedOperationException("Unsupported operation on remote container.");
    }

    public void removeService(Class type, Object service) {
        throw new UnsupportedOperationException("Unsupported operation on remote container.");
    }

    public String toString() {
        return "RemoteServiceProvider(id=" + this.getId() + ")";
    }
}

