/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.remote;

import jadex.base.fipa.SFipa;
import jadex.base.service.remote.RemoteGetExternalAccessCommand;
import jadex.base.service.remote.RemoteSearchCommand;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IMessageService;
import jadex.bridge.IRemoteServiceManagementService;
import jadex.commons.Future;
import jadex.commons.ICommand;
import jadex.commons.IFuture;
import jadex.commons.SUtil;
import jadex.commons.concurrent.DefaultResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.service.AnyResultSelector;
import jadex.commons.service.BasicService;
import jadex.commons.service.IResultSelector;
import jadex.commons.service.ISearchManager;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.IVisitDecider;
import jadex.commons.service.SServiceProvider;
import jadex.commons.service.TypeResultSelector;
import jadex.commons.service.clock.ITimer;
import jadex.commons.service.library.ILibraryService;
import jadex.micro.IMicroExternalAccess;
import jadex.micro.MicroAgent;
import jadex.xml.bean.JavaWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RemoteServiceManagementService
extends BasicService
implements IRemoteServiceManagementService {
    public static String REMOTE_EXCLUDED = "remote_excluded";
    public static String REMOTE_UNCACHED = "remote_uncached";
    public static String REMOTE_SYNCHRONOUS = "remote_synchronous";
    public static String REMOTE_METHODREPLACEMENT = "remote_methodreplacement";
    public static long DEFAULT_TIMEOUT = 10000L;
    protected IMicroExternalAccess component;
    protected Map waitingcalls;
    static /* synthetic */ Class class$jadex$bridge$IMessageService;

    public RemoteServiceManagementService(IMicroExternalAccess component) {
        super(component.getServiceProvider().getId(), IRemoteServiceManagementService.class, null);
        this.component = component;
        this.waitingcalls = Collections.synchronizedMap(new HashMap());
    }

    public IFuture getServiceProxies(final IComponentIdentifier cid, final ISearchManager manager, final IVisitDecider decider, final IResultSelector selector) {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.component.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                IComponentIdentifier rrms = cms.createComponentIdentifier("rms@" + cid.getPlatformName(), false, cid.getAddresses());
                String callid = SUtil.createUniqueId((String)RemoteServiceManagementService.this.component.getComponentIdentifier().getLocalName());
                RemoteSearchCommand content = new RemoteSearchCommand(cid, manager, decider, selector, callid);
                RemoteServiceManagementService.sendMessage(RemoteServiceManagementService.this.component, rrms, content, callid, -1L, RemoteServiceManagementService.this.waitingcalls, ret);
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public IFuture getServiceProxy(IComponentIdentifier cid, Class service) {
        return this.getServiceProxies(cid, SServiceProvider.sequentialmanager, SServiceProvider.abortdecider, (IResultSelector)new TypeResultSelector(service, true));
    }

    public IFuture getServiceProxies(IComponentIdentifier cid, Class service) {
        return this.getServiceProxies(cid, SServiceProvider.sequentialmanager, SServiceProvider.contdecider, (IResultSelector)new TypeResultSelector(service, true));
    }

    public IFuture getDeclaredServiceProxies(IComponentIdentifier cid) {
        return this.getServiceProxies(cid, SServiceProvider.localmanager, SServiceProvider.contdecider, (IResultSelector)new AnyResultSelector(false, false));
    }

    public IFuture getExternalAccessProxy(final IComponentIdentifier cid) {
        final Future ret = new Future();
        SServiceProvider.getService((IServiceProvider)this.component.getServiceProvider(), (Class)IComponentManagementService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                IComponentIdentifier rrms = cms.createComponentIdentifier("rms@" + cid.getPlatformName(), false, cid.getAddresses());
                String callid = SUtil.createUniqueId((String)RemoteServiceManagementService.this.component.getComponentIdentifier().getLocalName());
                RemoteGetExternalAccessCommand content = new RemoteGetExternalAccessCommand(cid, callid);
                RemoteServiceManagementService.sendMessage(RemoteServiceManagementService.this.component, rrms, content, callid, -1L, RemoteServiceManagementService.this.waitingcalls, ret);
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public IExternalAccess getComponent() {
        return this.component;
    }

    public Map getWaitingCalls() {
        return this.waitingcalls;
    }

    public static void sendMessage(final IMicroExternalAccess component, IComponentIdentifier receiver, final Object content, final String callid, long to, final Map waitingcalls, final Future future) {
        final long timeout = to <= 0L ? DEFAULT_TIMEOUT : to;
        waitingcalls.put(callid, future);
        final HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("sender", component.getComponentIdentifier());
        msg.put("receivers", new IComponentIdentifier[]{receiver});
        msg.put("conversation_id", callid);
        SServiceProvider.getService((IServiceProvider)component.getServiceProvider(), (Class)ILibraryService.class).addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                final ILibraryService ls = (ILibraryService)result;
                SServiceProvider.getService((IServiceProvider)component.getServiceProvider(), (Class)(class$jadex$bridge$IMessageService == null ? (class$jadex$bridge$IMessageService = RemoteServiceManagementService.class$("jadex.bridge.IMessageService")) : class$jadex$bridge$IMessageService)).addResultListener(new IResultListener(){

                    public void resultAvailable(Object source, Object result) {
                        msg.put("content", JavaWriter.objectToXML((Object)content, (ClassLoader)ls.getClassLoader()));
                        IMessageService ms = (IMessageService)result;
                        ms.sendMessage(msg, SFipa.FIPA_MESSAGE_TYPE, component.getComponentIdentifier(), ls.getClassLoader()).addResultListener(new IResultListener(){

                            public void resultAvailable(Object source, Object result) {
                                component.scheduleStep(new ICommand(){

                                    public void execute(Object args) {
                                        MicroAgent pa = (MicroAgent)args;
                                        pa.waitFor(timeout, new ICommand(){

                                            public void execute(Object args) {
                                                waitingcalls.remove(callid);
                                                future.setExceptionIfUndone((Exception)new RuntimeException("No reply received and timeout occurred: " + callid));
                                            }
                                        }).addResultListener((IResultListener)new DefaultResultListener(){

                                            public void resultAvailable(Object source, Object result) {
                                                final ITimer timer = (ITimer)result;
                                                future.addResultListener(new IResultListener(){

                                                    public void resultAvailable(Object source, Object result) {
                                                        waitingcalls.remove(callid);
                                                        timer.cancel();
                                                    }

                                                    public void exceptionOccurred(Object source, Exception exception) {
                                                        waitingcalls.remove(callid);
                                                        timer.cancel();
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }

                            public void exceptionOccurred(Object source, Exception exception) {
                                waitingcalls.remove(callid);
                                future.setException(exception);
                            }
                        });
                    }

                    public void exceptionOccurred(Object source, Exception exception) {
                        waitingcalls.remove(callid);
                        future.setException(exception);
                    }
                });
            }

            public void exceptionOccurred(Object source, Exception exception) {
                waitingcalls.remove(callid);
                future.setException(exception);
            }
        });
    }
}

