/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.service.simulation;

import jadex.base.service.simulation.ISimulationService;
import jadex.commons.ChangeEvent;
import jadex.commons.Future;
import jadex.commons.IChangeListener;
import jadex.commons.ICommand;
import jadex.commons.IFuture;
import jadex.commons.collection.SCollection;
import jadex.commons.concurrent.DefaultResultListener;
import jadex.commons.concurrent.IResultListener;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.service.BasicService;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.commons.service.clock.ClockService;
import jadex.commons.service.clock.IClockService;
import jadex.commons.service.clock.ITimer;
import jadex.commons.service.execution.IExecutionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimulationService
extends BasicService
implements ISimulationService {
    protected IServiceProvider provider;
    protected String mode;
    protected boolean executing;
    protected List listeners;
    protected ICommand simcommand;
    protected long timesteptime;
    protected IClockService clockservice;
    protected IExecutionService exeservice;
    protected List notifications;
    protected int change;
    static /* synthetic */ Class class$jadex$commons$service$execution$IExecutionService;
    static /* synthetic */ Class class$jadex$commons$service$clock$IClockService;

    public SimulationService(IServiceProvider provider) {
        this(provider, null);
    }

    public SimulationService(IServiceProvider provider, Map properties) {
        super(provider.getId(), ISimulationService.class, properties);
        this.provider = provider;
        this.mode = "mode_normal";
        this.listeners = SCollection.createArrayList();
        this.simcommand = new ICommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Object args) {
                IClockService simclock = SimulationService.this.getClockService();
                int choice = 0;
                boolean advance = true;
                int step_time = 2;
                SimulationService simulationService = SimulationService.this;
                synchronized (simulationService) {
                    ITimer t;
                    if (SimulationService.this.isExecuting() && ("mode_time_step".equals(SimulationService.this.getMode()) || "mode_action_step".equals(SimulationService.this.getMode()))) {
                        SimulationService.this.setExecuting(false);
                    }
                    if ("mode_normal".equals(SimulationService.this.getMode()) && SimulationService.this.executing) {
                        choice = 1;
                    } else if ("mode_time_step".equals(SimulationService.this.getMode()) && (t = simclock.getNextTimer()) != null && t.getNotificationTime() <= SimulationService.this.timesteptime) {
                        choice = 2;
                    }
                }
                SimulationService.this.notifyListeners();
                switch (choice) {
                    case 1: {
                        simclock.advanceEvent();
                        break;
                    }
                    case 2: {
                        SimulationService.this.stepTime();
                        break;
                    }
                }
            }
        };
    }

    public IFuture shutdownService() {
        IFuture ret = super.shutdownService();
        this.pause();
        return ret;
    }

    public synchronized IFuture startService() {
        final Future ret = new Future();
        super.startService().addResultListener(new IResultListener(){

            public void resultAvailable(Object source, Object result) {
                final boolean[] services = new boolean[2];
                SServiceProvider.getService((IServiceProvider)SimulationService.this.provider, (Class)(class$jadex$commons$service$execution$IExecutionService == null ? (class$jadex$commons$service$execution$IExecutionService = SimulationService.class$("jadex.commons.service.execution.IExecutionService")) : class$jadex$commons$service$execution$IExecutionService)).addResultListener((IResultListener)new DefaultResultListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultAvailable(Object source, Object result) {
                        (this).SimulationService.this.exeservice = (IExecutionService)result;
                        boolean[] blArray = services;
                        synchronized (services) {
                            services[0] = true;
                            boolean setresult = services[0] && services[1];
                            // ** MonitorExit[var4_3] (shouldn't be in output)
                            if (setresult) {
                                SimulationService.this.init();
                                ret.setResult((Object)SimulationService.this);
                            }
                            return;
                        }
                    }
                });
                SServiceProvider.getService((IServiceProvider)SimulationService.this.provider, (Class)(class$jadex$commons$service$clock$IClockService == null ? (class$jadex$commons$service$clock$IClockService = SimulationService.class$("jadex.commons.service.clock.IClockService")) : class$jadex$commons$service$clock$IClockService)).addResultListener((IResultListener)new DefaultResultListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultAvailable(Object source, Object result) {
                        (this).SimulationService.this.clockservice = (IClockService)result;
                        boolean[] blArray = services;
                        synchronized (services) {
                            services[1] = true;
                            boolean setresult = services[0] && services[1];
                            // ** MonitorExit[var4_3] (shouldn't be in output)
                            if (setresult) {
                                SimulationService.this.init();
                                ret.setResult((Object)SimulationService.this);
                            }
                            return;
                        }
                    }
                });
            }

            public void exceptionOccurred(Object source, Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    protected void init() {
        String type = this.getClockService().getClockType();
        if ("event_driven".equals(type) || "time_driven".equals(type)) {
            this.getExecutorService().addIdleCommand(this.simcommand);
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        boolean dostop = false;
        SimulationService simulationService = this;
        synchronized (simulationService) {
            if (this.isExecuting()) {
                dostop = true;
                this.setExecuting(false);
            }
        }
        this.notifyListeners();
        if (dostop) {
            this.getClockService().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean dostart = false;
        String type = null;
        SimulationService simulationService = this;
        synchronized (simulationService) {
            if (!this.isExecuting()) {
                type = this.getClockService().getClockType();
                this.setMode("mode_normal");
                this.setExecuting(true);
                dostart = true;
            }
        }
        this.notifyListeners();
        if (dostart) {
            this.getClockService().start();
            if ("event_driven".equals(type) || "time_driven".equals(type)) {
                this.getClockService().advanceEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepEvent() {
        int oldchange;
        boolean dostart = false;
        SimulationService simulationService = this;
        synchronized (simulationService) {
            if (!this.isExecuting()) {
                if ("continuous".equals(this.getClockService().getClockType()) || "system".equals(this.getClockService().getClockType())) {
                    throw new RuntimeException("Step only possible in simulation mode.");
                }
                this.setMode("mode_action_step");
                this.setExecuting(true);
                dostart = true;
            }
            oldchange = this.change;
        }
        this.notifyListeners();
        if (dostart) {
            this.getClockService().start();
            boolean advanced = this.getClockService().advanceEvent();
            SimulationService simulationService2 = this;
            synchronized (simulationService2) {
                if (oldchange == this.change && (!advanced || this.getExecutorService().isIdle())) {
                    this.setExecuting(false);
                }
            }
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepTime() {
        ITimer next;
        int oldchange;
        boolean dostart = false;
        SimulationService simulationService = this;
        synchronized (simulationService) {
            if (!this.isExecuting()) {
                if ("continuous".equals(this.getClockService().getClockType()) || "system".equals(this.getClockService().getClockType())) {
                    throw new RuntimeException("Step only possible in simulation mode.");
                }
                this.setMode("mode_time_step");
                this.setExecuting(true);
                dostart = true;
            }
            oldchange = this.change;
        }
        this.notifyListeners();
        if (dostart && (next = this.getClockService().getNextTimer()) != null) {
            this.timesteptime = next.getNotificationTime();
            this.getClockService().start();
            boolean advanced = this.getClockService().advanceEvent();
            SimulationService simulationService2 = this;
            synchronized (simulationService2) {
                if (oldchange == this.change && (!advanced || this.getExecutorService().isIdle())) {
                    this.setExecuting(false);
                }
            }
            this.notifyListeners();
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setClockType(String type, IThreadPool tp) {
        if (this.isExecuting()) {
            throw new RuntimeException("Change clock not allowed during execution.");
        }
        String oldtype = this.clockservice.getClockType();
        if (!type.equals(oldtype)) {
            if ("event_driven".equals(oldtype) || "time_driven".equals(oldtype)) {
                this.getExecutorService().removeIdleCommand(this.simcommand);
            }
            ((ClockService)this.clockservice).setClock(type, tp);
            if ("event_driven".equals(type) || "time_driven".equals(type)) {
                this.getExecutorService().addIdleCommand(this.simcommand);
            }
            if (this.notifications == null) {
                this.notifications = new ArrayList();
            }
            this.notifications.add(new ChangeEvent((Object)this, "clock_type", (Object)type));
            this.notifyListeners();
        }
    }

    public boolean isExecuting() {
        return this.executing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(IChangeListener listener) {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(IChangeListener listener) {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecuting(boolean executing) {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            if (executing != this.executing) {
                ++this.change;
                this.executing = executing;
                if (this.notifications == null) {
                    this.notifications = new ArrayList();
                }
                this.notifications.add(new ChangeEvent((Object)this, "executing", (Object)(executing ? Boolean.TRUE : Boolean.FALSE)));
            } else {
                Thread.dumpStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        IChangeListener[] alisteners;
        ChangeEvent[] events;
        SimulationService simulationService = this;
        synchronized (simulationService) {
            events = this.notifications != null ? this.notifications.toArray(new ChangeEvent[this.notifications.size()]) : null;
            alisteners = this.listeners.isEmpty() ? null : this.listeners.toArray(new IChangeListener[this.listeners.size()]);
            this.notifications = null;
        }
        if (alisteners != null && events != null) {
            for (int i = 0; i < alisteners.length; ++i) {
                for (int j = 0; j < events.length; ++j) {
                    alisteners[i].changeOccurred(events[j]);
                }
            }
        }
    }

    protected IClockService getClockService() {
        return this.clockservice;
    }

    public IExecutionService getExecutorService() {
        return this.exeservice;
    }
}

