/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.test;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentManagementService;
import jadex.commons.concurrent.IResultListener;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;

public class ComponentTest
implements Test {
    protected IComponentManagementService cms;
    protected String comp;

    public ComponentTest(IComponentManagementService cms, String comp) {
        this.cms = cms;
        this.comp = comp;
    }

    public int countTestCases() {
        return 1;
    }

    public void run(TestResult result) {
        result.startTest((Test)this);
        TestResultListener trl = new TestResultListener();
        this.cms.createComponent(null, this.comp, null, (IResultListener)trl);
        try {
            Testcase tc = trl.waitForResult();
            TestReport[] reports = tc.getReports();
            if (tc.getTestCount() != reports.length) {
                result.addFailure((Test)this, new AssertionFailedError("Number of testcases do not match. Expected " + tc.getTestCount() + " but was " + reports.length + "."));
            }
            for (int i = 0; i < reports.length; ++i) {
                if (reports[i].isSucceeded()) continue;
                result.addFailure((Test)this, new AssertionFailedError(reports[i].getDescription() + " Failed with reason: " + reports[i].getReason()));
            }
        }
        catch (Exception e) {
            result.addError((Test)this, (Throwable)e);
        }
        result.endTest((Test)this);
    }

    public String toString() {
        return this.comp;
    }

    class TestResultListener
    implements IResultListener {
        protected boolean finished;
        protected Object result;

        TestResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exceptionOccurred(Object source, Exception exception) {
            TestResultListener testResultListener = this;
            synchronized (testResultListener) {
                this.result = exception;
                this.finished = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultAvailable(Object source, Object res) {
            TestResultListener testResultListener = this;
            synchronized (testResultListener) {
                this.result = res;
                this.finished = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Testcase waitForResult() throws Exception {
            TestResultListener testResultListener = this;
            synchronized (testResultListener) {
                if (!this.finished) {
                    this.wait();
                }
            }
            if (this.result instanceof Exception) {
                throw (Exception)this.result;
            }
            Testcase ret = (Testcase)((Map)this.result).get("testresults");
            return ret;
        }
    }
}

