/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.test;

import jadex.base.SComponentFactory;
import jadex.base.Starter;
import jadex.base.test.ComponentTest;
import jadex.bridge.IArgument;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IModelInfo;
import jadex.commons.ISuspendable;
import jadex.commons.ThreadSuspendable;
import jadex.commons.service.IServiceProvider;
import jadex.commons.service.SServiceProvider;
import jadex.commons.service.library.ILibraryService;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import junit.framework.TestSuite;

public class ComponentTestSuite
extends TestSuite {
    public ComponentTestSuite(File path, File root, String[] excludes) throws Exception {
        super(path.getName());
        ThreadSuspendable ts = new ThreadSuspendable();
        IExternalAccess rootcomp = (IExternalAccess)Starter.createPlatform(new String[]{"-configname", "all_kernels_no_daemons", "-simulation", "true"}).get((ISuspendable)ts);
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getServiceUpwards((IServiceProvider)rootcomp.getServiceProvider(), (Class)IComponentManagementService.class).get((ISuspendable)ts);
        ILibraryService libsrv = (ILibraryService)SServiceProvider.getService((IServiceProvider)rootcomp.getServiceProvider(), (Class)ILibraryService.class).get((ISuspendable)ts);
        try {
            URL url = root.toURI().toURL();
            libsrv.addURL(url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedList<File> todo = new LinkedList<File>();
        todo.add(path);
        while (!todo.isEmpty()) {
            File file = (File)todo.remove(0);
            String abspath = file.getAbsolutePath();
            boolean exclude = false;
            for (int i = 0; !exclude && excludes != null && i < excludes.length; ++i) {
                exclude = abspath.indexOf(excludes[i]) != -1;
            }
            if (exclude) continue;
            if (file.isDirectory()) {
                File[] subs = file.listFiles();
                todo.addAll(Arrays.asList(subs));
                continue;
            }
            if (!((Boolean)SComponentFactory.isLoadable(rootcomp.getServiceProvider(), abspath).get((ISuspendable)ts)).booleanValue()) continue;
            IModelInfo model = (IModelInfo)SComponentFactory.loadModel(rootcomp.getServiceProvider(), abspath).get((ISuspendable)ts);
            boolean istest = false;
            if (model != null && model.getReport() == null) {
                IArgument[] results = model.getResults();
                for (int i = 0; !istest && i < results.length; ++i) {
                    if (!results[i].getName().equals("testresults") || !results[i].getTypename().equals("Testcase")) continue;
                    istest = true;
                }
            }
            if (!istest) continue;
            this.addTest(new ComponentTest(cms, abspath));
        }
    }
}

