/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.test;

import jadex.base.test.TestReport;
import jadex.commons.SUtil;

public class Testcase {
    protected String type;
    protected int cnt;
    protected TestReport[] reports;
    protected long duration;

    public Testcase() {
    }

    public Testcase(String type) {
        this.type = type;
        this.cnt = -1;
    }

    public Testcase(int cnt, TestReport[] reports) {
        this.cnt = cnt;
        this.reports = reports;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getTestCount() {
        return this.cnt;
    }

    public void setTestCount(int cnt) {
        this.cnt = cnt;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public TestReport[] getReports() {
        return this.reports;
    }

    public void addReport(TestReport report) {
        if (this.reports == null) {
            this.reports = new TestReport[]{report};
        } else {
            TestReport[] tmp = new TestReport[this.reports.length + 1];
            System.arraycopy(this.reports, 0, tmp, 0, this.reports.length);
            tmp[this.reports.length] = report;
            this.reports = tmp;
        }
    }

    public void setReports(TestReport[] reports) {
        this.reports = reports;
    }

    public boolean isSucceeded() {
        boolean ret = this.reports != null && this.cnt == this.reports.length;
        for (int i = 0; ret && i < this.reports.length; ++i) {
            ret = this.reports[i].isSucceeded();
        }
        return ret;
    }

    public boolean isPerformed() {
        return this.reports != null;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Testcase type: ");
        ret.append(this.type);
        ret.append(", result: ");
        if (this.isSucceeded()) {
            ret.append("succeeded.");
        }
        if (!this.isSucceeded()) {
            ret.append("failed, reports: ");
            ret.append(SUtil.arrayToString((Object)this.reports));
        }
        return ret.toString();
    }

    public String getHTMLFragment(int number) {
        StringBuffer ret = new StringBuffer();
        ret.append("<h3>");
        if (this.isSucceeded()) {
            ret.append("<strong style=\"color: #00FF00\">O</strong>");
        } else {
            ret.append("<strong style=\"color: #FF0000\">X</strong>");
        }
        ret.append(" Testcase");
        if (number != -1) {
            ret.append(" ");
            ret.append(number);
        }
        ret.append(": ");
        ret.append(this.type);
        ret.append("</h3>\n");
        if (this.reports.length > 0) {
            for (int i = 0; i < this.reports.length; ++i) {
                if (this.reports[i].isSucceeded()) {
                    ret.append("<strong style=\"color: #00FF00\">O</strong> Test: ");
                    ret.append(this.reports[i].getName());
                    ret.append(", ");
                    ret.append(this.reports[i].getDescription());
                } else {
                    ret.append("<strong style=\"color: #FF0000\">X</strong> Test: ");
                    ret.append(this.reports[i].getName());
                    ret.append(", ");
                    ret.append(this.reports[i].getDescription());
                    ret.append("<br>\n&nbsp;&nbsp;&nbsp;&nbsp;Failure reason: ");
                    ret.append(this.reports[i].getReason());
                }
                ret.append("<br>\n");
            }
            if (this.cnt != -1 && this.cnt != this.reports.length) {
                ret.append("<strong style=\"color: #FF0000\">X</strong> Problem: Number of tests does not match. Expected ");
                ret.append(this.cnt);
                if (this.cnt == 1) {
                    ret.append(" report but got ");
                } else {
                    ret.append(" reports but got ");
                }
                ret.append(this.reports.length);
                ret.append(".<br>\n");
            }
            ret.append("Took ");
            ret.append(this.duration);
            ret.append(" ms.<br>\n");
        }
        return ret.toString();
    }
}

