/*
 * Decompiled with CFR 0.152.
 */
package jadex.standalone.service;

import jadex.base.fipa.DFComponentDescription;
import jadex.base.fipa.DFServiceDescription;
import jadex.base.fipa.IDF;
import jadex.base.fipa.IDFComponentDescription;
import jadex.base.fipa.IDFServiceDescription;
import jadex.base.fipa.IProperty;
import jadex.base.fipa.SFipa;
import jadex.base.fipa.SearchConstraints;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentManagementService;
import jadex.bridge.ISearchConstraints;
import jadex.bridge.service.BasicService;
import jadex.bridge.service.IServiceProvider;
import jadex.bridge.service.SServiceProvider;
import jadex.bridge.service.clock.IClockService;
import jadex.commons.collection.IndexMap;
import jadex.commons.future.CollectionResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public class DirectoryFacilitatorService
extends BasicService
implements IDF {
    protected IServiceProvider provider;
    protected IComponentManagementService cms;
    protected IClockService clockservice;
    protected IndexMap components;

    public DirectoryFacilitatorService(IServiceProvider provider) {
        this(provider, null);
    }

    public DirectoryFacilitatorService(IServiceProvider provider, Map properties) {
        super(provider.getId(), IDF.class, properties);
        this.provider = provider;
        this.components = new IndexMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture register(IDFComponentDescription cdesc) {
        Future ret = new Future();
        IDFComponentDescription clone = SFipa.cloneDFComponentDescription((IDFComponentDescription)cdesc, (IComponentManagementService)this.cms, (IDF)this);
        if (clone.getLeaseTime() == null || clone.getLeaseTime().getTime() > this.clockservice.getTime()) {
            IndexMap indexMap = this.components;
            synchronized (indexMap) {
                if (this.components.containsKey((Object)clone.getName())) {
                    throw new RuntimeException("Componentomponent already registered: " + cdesc.getName());
                }
                this.components.add((Object)clone.getName(), (Object)clone);
            }
            ret.setResult((Object)clone);
        } else {
            ret.setException((Exception)new RuntimeException("Componentomponent not registered: " + clone.getName()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture deregister(IDFComponentDescription cdesc) {
        Future ret = new Future();
        IndexMap indexMap = this.components;
        synchronized (indexMap) {
            if (!this.components.containsKey((Object)cdesc.getName())) {
                ret.setException((Exception)new RuntimeException("Component not registered: " + cdesc.getName()));
            } else {
                this.components.removeKey((Object)cdesc.getName());
                ret.setResult(null);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture modify(IDFComponentDescription cdesc) {
        Future ret = new Future();
        IDFComponentDescription clone = SFipa.cloneDFComponentDescription((IDFComponentDescription)cdesc, (IComponentManagementService)this.cms, (IDF)this);
        if (clone.getLeaseTime() == null || clone.getLeaseTime().getTime() > this.clockservice.getTime()) {
            IndexMap indexMap = this.components;
            synchronized (indexMap) {
                this.components.replace((Object)clone.getName(), (Object)clone);
            }
            ret.setResult((Object)clone);
        } else {
            ret.setException((Exception)new RuntimeException("Invalid lease time: " + clone.getLeaseTime()));
        }
        return ret;
    }

    public IFuture search(IDFComponentDescription adesc, ISearchConstraints con) {
        return this.search(adesc, con, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture search(final IDFComponentDescription adesc, final ISearchConstraints con, boolean remote) {
        final Future fut = new Future();
        final ArrayList<DFComponentDescription> ret = new ArrayList<DFComponentDescription>();
        if (adesc.getName() != null) {
            IndexMap indexMap = this.components;
            synchronized (indexMap) {
                if (this.components.containsKey((Object)adesc.getName())) {
                    DFComponentDescription ad = (DFComponentDescription)this.components.get((Object)adesc.getName());
                    if (ad.getLeaseTime() != null && ad.getLeaseTime().getTime() < this.clockservice.getTime()) {
                        this.components.removeKey((Object)ad.getName());
                    } else {
                        ret.add(ad);
                    }
                }
            }
        }
        IndexMap indexMap = this.components;
        synchronized (indexMap) {
            DFComponentDescription[] descs = (DFComponentDescription[])this.components.toArray((Object[])new DFComponentDescription[this.components.size()]);
            for (int i = 0; (con == null || con.getMaxResults() == -1 || ret.size() < con.getMaxResults()) && i < descs.length; ++i) {
                if (descs[i].getLeaseTime() != null && descs[i].getLeaseTime().getTime() < this.clockservice.getTime()) {
                    this.components.removeKey((Object)descs[i].getName());
                    continue;
                }
                if (!this.match((IDFComponentDescription)descs[i], adesc)) continue;
                ret.add(descs[i]);
            }
        }
        if (remote) {
            SServiceProvider.getServices((IServiceProvider)this.provider, IDF.class, (String)"global").addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    Collection coll = (Collection)result;
                    CollectionResultListener lis = new CollectionResultListener(coll.size(), true, new IResultListener(){

                        public void resultAvailable(Object result) {
                            for (IDFComponentDescription[] res : (Collection)result) {
                                if (res == null) continue;
                                for (int i = 0; i < res.length; ++i) {
                                    ret.add(res[i]);
                                }
                            }
                            fut.setResult((Object)ret.toArray(new DFComponentDescription[ret.size()]));
                        }

                        public void exceptionOccurred(Exception exception) {
                            fut.setException(exception);
                        }
                    });
                    for (IDF remotedf : coll) {
                        if (remotedf != DirectoryFacilitatorService.this) {
                            remotedf.search(adesc, con, false).addResultListener((IResultListener)lis);
                            continue;
                        }
                        lis.resultAvailable(null);
                    }
                }

                public void exceptionOccurred(Exception exception) {
                    fut.setResult((Object)ret.toArray(new DFComponentDescription[ret.size()]));
                }
            });
        } else {
            fut.setResult((Object)ret.toArray(new DFComponentDescription[ret.size()]));
        }
        return fut;
    }

    public IDFServiceDescription createDFServiceDescription(String name, String type, String ownership) {
        return new DFServiceDescription(name, type, ownership);
    }

    public IDFServiceDescription createDFServiceDescription(String name, String type, String ownership, String[] languages, String[] ontologies, String[] protocols, IProperty[] properties) {
        int i;
        DFServiceDescription ret = new DFServiceDescription(name, type, ownership);
        for (i = 0; languages != null && i < languages.length; ++i) {
            ret.addLanguage(languages[i]);
        }
        for (i = 0; ontologies != null && i < ontologies.length; ++i) {
            ret.addOntology(ontologies[i]);
        }
        for (i = 0; protocols != null && i < protocols.length; ++i) {
            ret.addProtocol(protocols[i]);
        }
        for (i = 0; properties != null && i < properties.length; ++i) {
            ret.addProperty(properties[i]);
        }
        return ret;
    }

    public IDFComponentDescription createDFComponentDescription(IComponentIdentifier component, IDFServiceDescription service) {
        DFComponentDescription ret = new DFComponentDescription();
        ret.setName(component);
        if (service != null) {
            ret.addService(service);
        }
        return ret;
    }

    public IDFComponentDescription createDFComponentDescription(IComponentIdentifier component, IDFServiceDescription[] services, String[] languages, String[] ontologies, String[] protocols, Date leasetime) {
        int i;
        DFComponentDescription ret = new DFComponentDescription();
        ret.setName(component);
        ret.setLeaseTime(leasetime);
        for (i = 0; services != null && i < services.length; ++i) {
            ret.addService(services[i]);
        }
        for (i = 0; languages != null && i < languages.length; ++i) {
            ret.addLanguage(languages[i]);
        }
        for (i = 0; ontologies != null && i < ontologies.length; ++i) {
            ret.addOntology(ontologies[i]);
        }
        for (i = 0; protocols != null && i < protocols.length; ++i) {
            ret.addProtocol(protocols[i]);
        }
        return ret;
    }

    public ISearchConstraints createSearchConstraints(int maxresults, int maxdepth) {
        SearchConstraints ret = new SearchConstraints();
        ret.setMaxResults(maxresults);
        ret.setMaxDepth(maxdepth);
        return ret;
    }

    public synchronized IFuture startService() {
        final Future ret = new Future();
        super.startService().addResultListener((IResultListener)new DelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                final boolean[] services = new boolean[2];
                SServiceProvider.getServiceUpwards((IServiceProvider)DirectoryFacilitatorService.this.provider, IComponentManagementService.class).addResultListener((IResultListener)new DelegationResultListener(ret){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void customResultAvailable(Object result) {
                        DirectoryFacilitatorService.this.cms = (IComponentManagementService)result;
                        boolean[] blArray = services;
                        synchronized (services) {
                            services[0] = true;
                            boolean setresult = services[0] && services[1];
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            if (setresult) {
                                ret.setResult((Object)DirectoryFacilitatorService.this.getServiceIdentifier());
                            }
                            return;
                        }
                    }
                });
                SServiceProvider.getService((IServiceProvider)DirectoryFacilitatorService.this.provider, IClockService.class, (String)"platform").addResultListener((IResultListener)new DelegationResultListener(ret){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void customResultAvailable(Object result) {
                        DirectoryFacilitatorService.this.clockservice = (IClockService)result;
                        boolean[] blArray = services;
                        synchronized (services) {
                            services[1] = true;
                            boolean setresult = services[0] && services[1];
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            if (setresult) {
                                ret.setResult((Object)DirectoryFacilitatorService.this.getServiceIdentifier());
                            }
                            return;
                        }
                    }
                });
            }
        });
        return ret;
    }

    protected boolean match(IDFComponentDescription desc, IDFComponentDescription template) {
        boolean ret = true;
        ret = this.includes(desc.getLanguages(), template.getLanguages());
        ret = ret && this.includes(desc.getOntologies(), template.getOntologies());
        boolean bl = ret = ret && this.includes(desc.getProtocols(), template.getProtocols());
        if (ret) {
            IDFServiceDescription[] tservices = template.getServices();
            for (int t = 0; ret && t < tservices.length; ++t) {
                ret = false;
                IDFServiceDescription[] dservices = desc.getServices();
                for (int d = 0; !ret && d < dservices.length; ++d) {
                    ret = this.match(dservices[d], tservices[t]);
                }
            }
        }
        return ret;
    }

    protected boolean match(IDFServiceDescription desc, IDFServiceDescription template) {
        boolean ret = template.getName() == null || template.getName().equals(desc.getName());
        ret = ret && (template.getType() == null || template.getType().equals(desc.getType()));
        ret = ret && (template.getOwnership() == null || template.getOwnership().equals(desc.getOwnership()));
        ret = ret && this.includes(desc.getLanguages(), template.getLanguages());
        ret = ret && this.includes(desc.getOntologies(), template.getOntologies());
        ret = ret && this.includes(desc.getProtocols(), template.getProtocols());
        ret = ret && this.includes(desc.getProperties(), template.getProperties());
        return ret;
    }

    protected boolean includes(Object[] a, Object[] b) {
        int i;
        HashSet<Object> entries = new HashSet<Object>();
        for (i = 0; i < b.length; ++i) {
            entries.add(b[i]);
        }
        for (i = 0; i < a.length; ++i) {
            entries.remove(a[i]);
        }
        return entries.isEmpty();
    }
}

