/*
 * Decompiled with CFR 0.152.
 */
package jadex.rules.examples.blocksworld;

import jadex.rules.examples.blocksworld.Block;
import jadex.rules.rulesystem.IAction;
import jadex.rules.rulesystem.ICondition;
import jadex.rules.rulesystem.IPatternMatcherFunctionality;
import jadex.rules.rulesystem.IRule;
import jadex.rules.rulesystem.IRulebase;
import jadex.rules.rulesystem.IVariableAssignments;
import jadex.rules.rulesystem.RuleSystem;
import jadex.rules.rulesystem.RuleSystemExecutor;
import jadex.rules.rulesystem.Rulebase;
import jadex.rules.rulesystem.rete.RetePatternMatcherFunctionality;
import jadex.rules.rulesystem.rete.RetePatternMatcherState;
import jadex.rules.rulesystem.rules.AndCondition;
import jadex.rules.rulesystem.rules.BoundConstraint;
import jadex.rules.rulesystem.rules.IConstraint;
import jadex.rules.rulesystem.rules.IOperator;
import jadex.rules.rulesystem.rules.LiteralConstraint;
import jadex.rules.rulesystem.rules.ObjectCondition;
import jadex.rules.rulesystem.rules.OrConstraint;
import jadex.rules.rulesystem.rules.Rule;
import jadex.rules.rulesystem.rules.Variable;
import jadex.rules.state.IOAVState;
import jadex.rules.state.OAVAttributeType;
import jadex.rules.state.OAVJavaType;
import jadex.rules.state.OAVObjectType;
import jadex.rules.state.OAVTypeModel;
import jadex.rules.state.javaimpl.OAVStateFactory;
import jadex.rules.tools.reteviewer.RuleEnginePanel;

public class Blocksworld {
    public static OAVTypeModel blocksworld_type_model = new OAVTypeModel("blocksworld_type_model");
    public static OAVJavaType java_block_type;
    public static OAVObjectType block_type;
    public static OAVAttributeType block_has_name;
    public static OAVAttributeType block_has_color;
    public static OAVAttributeType block_has_on;
    public static OAVAttributeType block_has_left;
    public static OAVAttributeType block_has_friends;
    public static OAVObjectType ball_type;
    public static OAVAttributeType ball_has_color;
    public static OAVObjectType blockcontainer_type;
    public static OAVAttributeType blockcontainer_has_blocks;

    public static void main(String[] args) {
        Blocksworld.performBlocksWorldStackTest();
    }

    public static void performBlocksWorldStackTest() {
        RuleSystem system = Blocksworld.createReteSystem();
        RuleSystemExecutor exe = new RuleSystemExecutor(system, true);
        RuleEnginePanel.createRuleEngineFrame((RuleSystemExecutor)exe, (String)"Blocksworld Test");
        IOAVState state = system.getState();
        Object b1 = state.createRootObject(block_type);
        Object b2 = state.createRootObject(block_type);
        Object b3 = state.createRootObject(block_type);
        Object b4 = state.createRootObject(block_type);
        Object b5 = state.createRootObject(block_type);
        state.setAttributeValue(b1, block_has_name, (Object)"B1");
        state.setAttributeValue(b1, block_has_color, (Object)"red");
        state.addAttributeValue(b1, block_has_on, b2);
        state.addAttributeValue(b1, block_has_on, b3);
        state.addAttributeValue(b1, block_has_on, b4);
        state.addAttributeValue(b1, block_has_left, b5);
        state.setAttributeValue(b2, block_has_name, (Object)"B2");
        state.setAttributeValue(b2, block_has_color, (Object)"green");
        state.addAttributeValue(b2, block_has_on, b3);
        state.addAttributeValue(b2, block_has_on, b4);
        state.addAttributeValue(b2, block_has_left, b5);
        state.setAttributeValue(b3, block_has_name, (Object)"B3");
        state.setAttributeValue(b3, block_has_color, (Object)"blue");
        state.addAttributeValue(b3, block_has_on, b4);
        state.addAttributeValue(b3, block_has_left, b5);
        state.setAttributeValue(b4, block_has_name, (Object)"B4");
        state.setAttributeValue(b4, block_has_color, (Object)"yellow");
        state.addAttributeValue(b4, block_has_left, b5);
        state.setAttributeValue(b5, block_has_name, (Object)"B5");
        state.setAttributeValue(b5, block_has_color, (Object)"red");
        state.notifyEventListeners();
        System.out.println("Rete memory: " + ((RetePatternMatcherState)system.getMatcherState()).getReteMemory());
    }

    public static RuleSystem createReteSystem() {
        ObjectCondition zc = new ObjectCondition(block_type);
        OrConstraint cc = new OrConstraint((IConstraint)new LiteralConstraint((Object)block_has_color, (Object)"red"), (IConstraint)new LiteralConstraint((Object)block_has_color, (Object)"green"));
        zc.addConstraint((IConstraint)cc);
        zc.addConstraint((IConstraint)new BoundConstraint(null, new Variable("z", block_type)));
        ObjectCondition yc = new ObjectCondition(block_type);
        yc.addConstraint((IConstraint)new BoundConstraint((Object)block_has_left, new Variable("z", block_type), IOperator.CONTAINS));
        yc.addConstraint((IConstraint)new BoundConstraint(null, new Variable("y", block_type)));
        ObjectCondition xc = new ObjectCondition(block_type);
        xc.addConstraint((IConstraint)new BoundConstraint((Object)block_has_on, new Variable("y", block_type), IOperator.CONTAINS));
        xc.addConstraint((IConstraint)new BoundConstraint(null, new Variable("x", block_type)));
        AndCondition cond = new AndCondition(new ICondition[]{zc, yc, xc});
        System.out.println(cond);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assigments) {
                System.out.println("TRIGGERED: x=" + assigments.getVariableValue("x") + ", y=" + assigments.getVariableValue("y") + ", z=" + assigments.getVariableValue("z"));
            }
        };
        Rule rule = new Rule("block", (ICondition)cond, action);
        Rulebase rb = new Rulebase();
        RetePatternMatcherFunctionality pf = new RetePatternMatcherFunctionality((IRulebase)rb);
        RuleSystem system = new RuleSystem(OAVStateFactory.createOAVState((OAVTypeModel)blocksworld_type_model), (IRulebase)rb, (IPatternMatcherFunctionality)pf);
        system.init();
        system.getRulebase().addRule((IRule)rule);
        return system;
    }

    static {
        blocksworld_type_model.addTypeModel(OAVJavaType.java_type_model);
        java_block_type = blocksworld_type_model.createJavaType(Block.class, OAVJavaType.KIND_BEAN);
        block_type = blocksworld_type_model.createType("block");
        block_has_name = block_type.createAttributeType("block_has_name", (OAVObjectType)OAVJavaType.java_string_type);
        block_has_color = block_type.createAttributeType("block_has_color", (OAVObjectType)OAVJavaType.java_string_type);
        block_has_on = block_type.createAttributeType("block_has_on", block_type, "list");
        block_has_left = block_type.createAttributeType("block_has_left", block_type, "list");
        ball_type = blocksworld_type_model.createType("ball");
        ball_has_color = ball_type.createAttributeType("ball_has_color", (OAVObjectType)OAVJavaType.java_string_type);
        blockcontainer_type = blocksworld_type_model.createType("blockcontainer");
        blockcontainer_has_blocks = blockcontainer_type.createAttributeType("blockcontainer_has_blocks", (OAVObjectType)OAVJavaType.java_object_type, "list", null);
    }
}

