/*
 * Decompiled with CFR 0.152.
 */
package jadex.rules.examples.blocksworld;

import jadex.commons.SUtil;
import jadex.rules.examples.blocksworld.Block;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Table
extends Block {
    protected String name;
    protected List blocks;

    public Table() {
        this("Table", new Color(64, 32, 32));
    }

    public Table(String name, Color color) {
        super(-1, color, null);
        this.name = name;
        this.blocks = new ArrayList();
    }

    public boolean isClear() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    public Block[] getAllBlocks() {
        ArrayList<Block> ret = new ArrayList<Block>(this.blocks);
        for (int i = 0; i < ret.size(); ++i) {
            Block b = (Block)ret.get(i);
            if (b.upper == null) continue;
            ret.add(b.upper);
        }
        return ret.toArray(new Block[ret.size()]);
    }

    public Block[][] getStacks() {
        Block[][] stacks = new Block[this.blocks.size()][];
        for (int i = 0; i < stacks.length; ++i) {
            ArrayList<Block> ret = new ArrayList<Block>();
            Block b = (Block)this.blocks.get(i);
            while (b != null) {
                ret.add(b);
                b = b.upper;
            }
            stacks[i] = ret.toArray(new Block[ret.size()]);
        }
        return stacks;
    }

    public void clear() {
        Block[] all = this.getAllBlocks();
        for (int i = all.length - 1; i >= 0; --i) {
            all[i].stackOn(null);
        }
    }

    public boolean configurationEquals(Table table) {
        boolean ret = false;
        if (this.blocks.size() == table.blocks.size()) {
            ret = true;
            Iterator i = this.blocks.iterator();
            while (ret && i.hasNext()) {
                Block block = (Block)i.next();
                int index = table.blocks.indexOf(block);
                if (index != -1) {
                    Block block2 = (Block)table.blocks.get(index);
                    while ((block != null || block2 != null) && (ret = SUtil.equals((Object)block, (Object)block2))) {
                        block = block.upper;
                        block2 = block2.upper;
                    }
                    continue;
                }
                ret = false;
            }
        }
        return ret;
    }

    protected void addBlock(Block block) {
        this.blocks.add(block);
        this.pcs.firePropertyChange("blocks", null, (Object)block);
    }

    protected void removeBlock(Block block) {
        this.blocks.remove(block);
        this.pcs.firePropertyChange("blocks", (Object)block, null);
    }

    public List getBlocks() {
        return this.blocks;
    }
}

