/*
 * Decompiled with CFR 0.152.
 */
package jadex.rules.examples.hanoi;

import jadex.commons.gui.SGUI;
import jadex.rules.rulesystem.IAction;
import jadex.rules.rulesystem.ICondition;
import jadex.rules.rulesystem.IPatternMatcherFunctionality;
import jadex.rules.rulesystem.IRule;
import jadex.rules.rulesystem.IRulebase;
import jadex.rules.rulesystem.IVariableAssignments;
import jadex.rules.rulesystem.RuleSystem;
import jadex.rules.rulesystem.RuleSystemExecutor;
import jadex.rules.rulesystem.Rulebase;
import jadex.rules.rulesystem.rete.RetePatternMatcherFunctionality;
import jadex.rules.rulesystem.rules.AndCondition;
import jadex.rules.rulesystem.rules.BoundConstraint;
import jadex.rules.rulesystem.rules.IConstraint;
import jadex.rules.rulesystem.rules.IOperator;
import jadex.rules.rulesystem.rules.LiteralConstraint;
import jadex.rules.rulesystem.rules.NotCondition;
import jadex.rules.rulesystem.rules.ObjectCondition;
import jadex.rules.rulesystem.rules.Rule;
import jadex.rules.rulesystem.rules.Variable;
import jadex.rules.state.IOAVState;
import jadex.rules.state.IOAVStateListener;
import jadex.rules.state.OAVAttributeType;
import jadex.rules.state.OAVJavaType;
import jadex.rules.state.OAVObjectType;
import jadex.rules.state.OAVTypeModel;
import jadex.rules.state.javaimpl.OAVStateFactory;
import jadex.rules.tools.reteviewer.RuleEnginePanel;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class Hanoi {
    public static OAVTypeModel hanoi_type_model = new OAVTypeModel("hanoi_type_model");
    public static OAVObjectType java_oavattribute_type;
    public static OAVObjectType agent_type;
    public static OAVAttributeType agent_has_tower_a;
    public static OAVAttributeType agent_has_tower_b;
    public static OAVAttributeType agent_has_tower_c;
    public static OAVAttributeType agent_has_movegoals;
    public static OAVObjectType disc_type;
    public static OAVAttributeType disc_has_size;
    public static OAVObjectType movegoal_type;
    public static OAVAttributeType movegoal_is_executing;
    public static OAVAttributeType movegoal_has_precodition;
    public static OAVAttributeType movegoal_has_postcodition;
    public static OAVAttributeType movegoal_has_from;
    public static OAVAttributeType movegoal_has_to;
    public static OAVAttributeType movegoal_has_temp;
    public static OAVAttributeType movegoal_has_number;

    public static void main(String[] args) {
        int discs = 15;
        int impl = 1;
        boolean show_towers = true;
        boolean show_rete = true;
        Hanoi.test(discs, impl, show_towers, show_rete);
    }

    protected static void test(int discs, int impl, boolean showtowers, boolean showrete) {
        switch (impl) {
            case 1: {
                IOAVState state = Hanoi.createState();
                RuleSystem rete = Hanoi.initializeRete(state, showrete);
                Object agent = Hanoi.initState(discs, state, showtowers);
                Hanoi.moveWithRete(state, agent, agent_has_tower_a, agent_has_tower_c, agent_has_tower_b, discs, rete, showrete);
                break;
            }
            case 2: {
                IOAVState state = Hanoi.createState();
                Object agent = Hanoi.initState(discs, state, showtowers);
                Hanoi.moveWithoutRete(state, agent, agent_has_tower_a, agent_has_tower_c, agent_has_tower_b, discs);
                break;
            }
            case 3: {
                IOAVState state = Hanoi.createState();
                Object agent = Hanoi.initState(discs, state, showtowers);
                Hanoi.moveWithState(state, agent, agent_has_tower_a, agent_has_tower_c, agent_has_tower_b, discs);
                break;
            }
            case 4: {
                IOAVState state = Hanoi.createState();
                Object agent = Hanoi.initState(discs, state, showtowers);
                ArrayList from = new ArrayList();
                ArrayList to = new ArrayList();
                ArrayList temp = new ArrayList();
                from.addAll(state.getAttributeValues(agent, agent_has_tower_a));
                Hanoi.moveWithoutState(from, to, temp, discs);
                break;
            }
        }
    }

    protected static IOAVState createState() {
        return OAVStateFactory.createOAVState((OAVTypeModel)hanoi_type_model);
    }

    protected static Object initState(int discs, IOAVState state, boolean showtowers) {
        Object agent = state.createRootObject(agent_type);
        for (int i = discs; i > 0; --i) {
            Object disc = state.createObject(disc_type);
            state.setAttributeValue(disc, disc_has_size, (Object)new Integer(i));
            state.addAttributeValue(agent, agent_has_tower_a, disc);
        }
        if (showtowers) {
            Hanoi.showFrame(state, agent);
        }
        return agent;
    }

    public static void benchmark(int maxdiscs) {
        int times = (int)Math.pow(2.0, maxdiscs);
        int discs = 1;
        while (times > 1) {
            IOAVState state = Hanoi.createState();
            Object agent = Hanoi.initState(discs, state, false);
            ArrayList from = new ArrayList();
            ArrayList to = new ArrayList();
            ArrayList temp = new ArrayList();
            from.addAll(state.getAttributeValues(agent, agent_has_tower_a));
            long nostatestart = System.currentTimeMillis();
            for (int i = 0; i < times * 3; ++i) {
                if (i % 2 == 0) {
                    Hanoi.moveWithoutState(from, to, temp, discs);
                    continue;
                }
                Hanoi.moveWithoutState(to, from, temp, discs);
            }
            double nostatetime = Hanoi.calcTime(nostatestart, times * 3, discs);
            state = Hanoi.createState();
            agent = Hanoi.initState(discs, state, false);
            long statestart = System.currentTimeMillis();
            for (int i = 0; i < times; ++i) {
                if (i % 2 == 0) {
                    Hanoi.moveWithState(state, agent, agent_has_tower_a, agent_has_tower_b, agent_has_tower_c, discs);
                    continue;
                }
                Hanoi.moveWithState(state, agent, agent_has_tower_b, agent_has_tower_a, agent_has_tower_c, discs);
            }
            double statetime = Hanoi.calcTime(statestart, times, discs);
            state = Hanoi.createState();
            agent = Hanoi.initState(discs, state, false);
            long noretestart = System.currentTimeMillis();
            int i = 0;
            while ((double)i < Math.ceil((double)times / 5.0)) {
                if (i % 2 == 0) {
                    Hanoi.moveWithoutRete(state, agent, agent_has_tower_a, agent_has_tower_b, agent_has_tower_c, discs);
                } else {
                    Hanoi.moveWithoutRete(state, agent, agent_has_tower_b, agent_has_tower_a, agent_has_tower_c, discs);
                }
                ++i;
            }
            double noretetime = Hanoi.calcTime(noretestart, (int)Math.ceil((double)times / 5.0), discs);
            state = Hanoi.createState();
            RuleSystem rete = Hanoi.initializeRete(state, false);
            agent = Hanoi.initState(discs, state, false);
            long retestart = System.currentTimeMillis();
            int i2 = 0;
            while ((double)i2 < Math.ceil((double)times / 25.0)) {
                if (i2 % 2 == 0) {
                    Hanoi.moveWithRete(state, agent, agent_has_tower_a, agent_has_tower_b, agent_has_tower_c, discs, rete, false);
                } else {
                    Hanoi.moveWithRete(state, agent, agent_has_tower_b, agent_has_tower_a, agent_has_tower_c, discs, rete, false);
                }
                ++i2;
            }
            double retetime = Hanoi.calcTime(retestart, (int)Math.ceil((double)times / 25.0), discs);
            System.out.println("Discs:" + discs + " \tnostate:" + (int)nostatetime + " \tstate:" + (int)statetime + " \toverhead(%):" + Hanoi.calcOverhead(nostatetime, statetime) + " \tnorete:" + (int)noretetime + " \trete:" + (int)retetime + " \toverhead(%):" + Hanoi.calcOverhead(noretetime, retetime));
            times /= 2;
            ++discs;
        }
    }

    protected static double calcTime(long start, int times, int discs) {
        long elapsed = System.currentTimeMillis() - start;
        return (double)(1000000L * elapsed) / (double)times / Math.pow(2.0, discs);
    }

    protected static String calcOverhead(double benchmark, double value) {
        return benchmark != 0.0 ? "" + (int)(value * 100.0 / benchmark - 100.0) : "n/a";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void moveWithoutRete(IOAVState state, Object agent, OAVAttributeType from, OAVAttributeType to, OAVAttributeType temp, int num) {
        Object rootgoal;
        IOAVState iOAVState = state;
        synchronized (iOAVState) {
            rootgoal = state.createObject(movegoal_type);
            state.setAttributeValue(rootgoal, movegoal_has_from, (Object)from);
            state.setAttributeValue(rootgoal, movegoal_has_to, (Object)to);
            state.setAttributeValue(rootgoal, movegoal_has_temp, (Object)temp);
            state.setAttributeValue(rootgoal, movegoal_has_number, (Object)new Integer(num));
            state.addAttributeValue(agent, agent_has_movegoals, rootgoal);
        }
        Hanoi.performMoveGoalRecursive(state, agent, rootgoal);
    }

    protected static void performMoveGoalRecursive(IOAVState state, Object agent, Object goal) {
        Object[] subgoals = Hanoi.performMoveGoal(state, agent, goal);
        if (subgoals != null) {
            Hanoi.performMoveGoalRecursive(state, agent, subgoals[0]);
            Hanoi.performMoveGoalRecursive(state, agent, subgoals[1]);
            Hanoi.performMoveGoalRecursive(state, agent, subgoals[2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object[] performMoveGoal(IOAVState state, Object agent, Object goal) {
        IOAVState iOAVState = state;
        synchronized (iOAVState) {
            Object[] ret = null;
            state.setAttributeValue(goal, movegoal_is_executing, (Object)Boolean.TRUE);
            OAVAttributeType from = (OAVAttributeType)state.getAttributeValue(goal, movegoal_has_from);
            OAVAttributeType to = (OAVAttributeType)state.getAttributeValue(goal, movegoal_has_to);
            OAVAttributeType temp = (OAVAttributeType)state.getAttributeValue(goal, movegoal_has_temp);
            int number = (Integer)state.getAttributeValue(goal, movegoal_has_number);
            if (number == 1) {
                List fromlist = (List)state.getAttributeValues(agent, from);
                Object disc = fromlist.get(fromlist.size() - 1);
                state.addAttributeValue(agent, to, disc);
                state.removeAttributeValue(agent, from, disc);
                while (goal != null) {
                    Object postcondition = state.getAttributeValue(goal, movegoal_has_postcodition);
                    state.dropObject(goal);
                    goal = postcondition;
                }
            } else {
                Object subgoal1 = state.createObject(movegoal_type);
                state.setAttributeValue(subgoal1, movegoal_has_from, (Object)from);
                state.setAttributeValue(subgoal1, movegoal_has_to, (Object)temp);
                state.setAttributeValue(subgoal1, movegoal_has_temp, (Object)to);
                state.setAttributeValue(subgoal1, movegoal_has_number, (Object)new Integer(number - 1));
                state.addAttributeValue(agent, agent_has_movegoals, subgoal1);
                Object subgoal2 = state.createObject(movegoal_type);
                state.setAttributeValue(subgoal2, movegoal_has_from, (Object)from);
                state.setAttributeValue(subgoal2, movegoal_has_to, (Object)to);
                state.setAttributeValue(subgoal2, movegoal_has_temp, (Object)temp);
                state.setAttributeValue(subgoal2, movegoal_has_number, (Object)new Integer(1));
                state.setAttributeValue(subgoal2, movegoal_has_precodition, subgoal1);
                state.addAttributeValue(agent, agent_has_movegoals, subgoal2);
                Object subgoal3 = state.createObject(movegoal_type);
                state.setAttributeValue(subgoal3, movegoal_has_from, (Object)temp);
                state.setAttributeValue(subgoal3, movegoal_has_to, (Object)to);
                state.setAttributeValue(subgoal3, movegoal_has_temp, (Object)from);
                state.setAttributeValue(subgoal3, movegoal_has_number, (Object)new Integer(number - 1));
                state.setAttributeValue(subgoal3, movegoal_has_precodition, subgoal2);
                state.setAttributeValue(subgoal3, movegoal_has_postcodition, goal);
                state.addAttributeValue(agent, agent_has_movegoals, subgoal3);
                ret = new Object[]{subgoal1, subgoal2, subgoal3};
            }
            return ret;
        }
    }

    protected static void showFrame(IOAVState state, Object agent) {
        JFrame frame = new JFrame("Towers of Hanoi");
        final HanoiComponent comp = new HanoiComponent(state, agent);
        frame.getContentPane().add(comp);
        frame.setSize(800, 250);
        frame.setLocation(SGUI.calculateMiddlePosition((Window)frame).x, 0);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        state.addStateListener(new IOAVStateListener(){

            public void objectModified(Object id, OAVObjectType type, OAVAttributeType attr, Object oldvalue, Object newvalue) {
                comp.repaint();
                Thread.yield();
            }

            public void objectAdded(Object id, OAVObjectType type, boolean root) {
                comp.repaint();
                Thread.yield();
            }

            public void objectRemoved(Object id, OAVObjectType type) {
                comp.repaint();
                Thread.yield();
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void moveWithState(IOAVState state, Object agent, OAVAttributeType from, OAVAttributeType to, OAVAttributeType temp, int num) {
        if (num == 1) {
            IOAVState iOAVState = state;
            synchronized (iOAVState) {
                List fromlist = (List)state.getAttributeValues(agent, from);
                Object disc = fromlist.get(fromlist.size() - 1);
                state.removeAttributeValue(agent, from, disc);
                state.addAttributeValue(agent, to, disc);
            }
            Thread.yield();
        } else {
            Hanoi.moveWithState(state, agent, from, temp, to, num - 1);
            Hanoi.moveWithState(state, agent, from, to, temp, 1);
            Hanoi.moveWithState(state, agent, temp, to, from, num - 1);
        }
    }

    protected static void moveWithoutState(List from, List to, List temp, int num) {
        if (num == 1) {
            to.add(from.remove(from.size() - 1));
            Thread.yield();
        } else {
            Hanoi.moveWithoutState(from, temp, to, num - 1);
            Hanoi.moveWithoutState(from, to, temp, 1);
            Hanoi.moveWithoutState(temp, to, from, num - 1);
        }
    }

    protected static RuleSystem initializeRete(IOAVState state, boolean showrete) {
        ObjectCondition oc1a = new ObjectCondition(movegoal_type);
        oc1a.addConstraint((IConstraint)new LiteralConstraint((Object)movegoal_is_executing, (Object)Boolean.FALSE));
        oc1a.addConstraint((IConstraint)new LiteralConstraint((Object)movegoal_has_precodition, null));
        oc1a.addConstraint((IConstraint)new BoundConstraint(null, new Variable("goal", movegoal_type)));
        ObjectCondition oc1b = new ObjectCondition(movegoal_type);
        oc1b.addConstraint((IConstraint)new LiteralConstraint((Object)movegoal_has_precodition, null));
        oc1b.addConstraint((IConstraint)new BoundConstraint(null, new Variable("goal", movegoal_type)));
        ObjectCondition temp = new ObjectCondition(movegoal_type);
        temp.addConstraint((IConstraint)new BoundConstraint((Object)movegoal_has_postcodition, new Variable("goal", movegoal_type)));
        NotCondition nc1 = new NotCondition((ICondition)temp);
        ObjectCondition oc2b = new ObjectCondition(agent_type);
        oc2b.addConstraint((IConstraint)new BoundConstraint((Object)agent_has_movegoals, new Variable("goal", movegoal_type), IOperator.CONTAINS));
        oc2b.addConstraint((IConstraint)new BoundConstraint(null, new Variable("agent", agent_type)));
        ObjectCondition oc2c = new ObjectCondition(agent_type);
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new Variable("$?g1", movegoal_type, true, false));
        vars.add(new Variable("goal", movegoal_type));
        vars.add(new Variable("$?g2", movegoal_type, true, false));
        oc2c.addConstraint((IConstraint)new BoundConstraint((Object)agent_has_movegoals, vars, IOperator.CONTAINS));
        oc2c.addConstraint((IConstraint)new BoundConstraint(null, new Variable("agent", agent_type)));
        Rulebase rb = new Rulebase();
        RetePatternMatcherFunctionality pf = new RetePatternMatcherFunctionality((IRulebase)rb);
        RuleSystem rete = new RuleSystem(state, (IRulebase)rb, (IPatternMatcherFunctionality)pf);
        rete.init();
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assigments) {
                Object agent = assigments.getVariableValue("agent");
                Object goal = assigments.getVariableValue("goal");
                Hanoi.performMoveGoal(state, agent, goal);
            }
        };
        Rule rule = new Rule("Hanoi", (ICondition)new AndCondition(new ICondition[]{oc1b, nc1, oc2b}), action);
        rete.getRulebase().addRule((IRule)rule);
        return rete;
    }

    protected static void moveWithRete(IOAVState state, Object agent, OAVAttributeType from, OAVAttributeType to, OAVAttributeType temp, int num, RuleSystem rete, boolean showrete) {
        Object rootgoal = state.createObject(movegoal_type);
        state.setAttributeValue(rootgoal, movegoal_has_from, (Object)from);
        state.setAttributeValue(rootgoal, movegoal_has_to, (Object)to);
        state.setAttributeValue(rootgoal, movegoal_has_temp, (Object)temp);
        state.setAttributeValue(rootgoal, movegoal_has_number, (Object)new Integer(num));
        state.addAttributeValue(agent, agent_has_movegoals, rootgoal);
        state.notifyEventListeners();
        if (showrete) {
            RuleSystemExecutor exe = new RuleSystemExecutor(rete, true);
            RuleEnginePanel.createRuleEngineFrame((RuleSystemExecutor)exe, (String)"Hanoi Rete Structure");
        } else {
            while (!rete.getAgenda().isEmpty()) {
                rete.getAgenda().fireRule();
                state.expungeStaleObjects();
                state.notifyEventListeners();
            }
        }
    }

    static {
        hanoi_type_model.addTypeModel(OAVJavaType.java_type_model);
        java_oavattribute_type = hanoi_type_model.createJavaType(OAVAttributeType.class, OAVJavaType.KIND_VALUE);
        disc_type = hanoi_type_model.createType("disc");
        disc_has_size = disc_type.createAttributeType("disc_has_size", (OAVObjectType)OAVJavaType.java_integer_type);
        movegoal_type = hanoi_type_model.createType("movegoal");
        movegoal_is_executing = movegoal_type.createAttributeType("movegoal_is_executing", (OAVObjectType)OAVJavaType.java_boolean_type, "none", (Object)Boolean.FALSE);
        movegoal_has_precodition = movegoal_type.createAttributeType("movegoal_has_precondition", movegoal_type);
        movegoal_has_postcodition = movegoal_type.createAttributeType("movegoal_has_postcondition", movegoal_type);
        movegoal_has_from = movegoal_type.createAttributeType("movegoal_has_from", java_oavattribute_type);
        movegoal_has_to = movegoal_type.createAttributeType("movegoal_has_to", java_oavattribute_type);
        movegoal_has_temp = movegoal_type.createAttributeType("movegoal_has_temp", java_oavattribute_type);
        movegoal_has_number = movegoal_type.createAttributeType("movegoal_has_number", (OAVObjectType)OAVJavaType.java_integer_type);
        agent_type = hanoi_type_model.createType("agent");
        agent_has_tower_a = agent_type.createAttributeType("agent_has_tower_a", disc_type, "list");
        agent_has_tower_b = agent_type.createAttributeType("agent_has_tower_b", disc_type, "list");
        agent_has_tower_c = agent_type.createAttributeType("agent_has_tower_c", disc_type, "list");
        agent_has_movegoals = agent_type.createAttributeType("agent_has_movegoals", movegoal_type, "set");
    }

    protected static class HanoiComponent
    extends JComponent {
        protected IOAVState state;
        protected Object agent;

        public HanoiComponent(IOAVState state, Object agent) {
            this.state = state;
            this.agent = agent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(Graphics g) {
            IOAVState iOAVState = this.state;
            synchronized (iOAVState) {
                int width;
                int size;
                Object disc;
                int i;
                List a = (List)this.state.getAttributeValues(this.agent, agent_has_tower_a);
                List b = (List)this.state.getAttributeValues(this.agent, agent_has_tower_b);
                List c = (List)this.state.getAttributeValues(this.agent, agent_has_tower_c);
                int total = (a != null ? a.size() : 0) + (b != null ? b.size() : 0) + (c != null ? c.size() : 0);
                Rectangle bounds = this.getBounds();
                Insets insets = this.getInsets();
                bounds.x = insets.left;
                bounds.y = insets.top;
                bounds.width -= insets.left + insets.right;
                bounds.height -= insets.top + insets.bottom;
                int towerwidth = bounds.width / 3;
                int discheight = bounds.height / (total + 1) - 2;
                for (i = 0; a != null && i < a.size(); ++i) {
                    disc = a.get(i);
                    size = (Integer)this.state.getAttributeValue(disc, disc_has_size);
                    width = towerwidth * size / (total + 1);
                    g.fillRect(bounds.x + (towerwidth - width) / 2, bounds.height - (i + 1) * (discheight + 1), width, discheight);
                }
                for (i = 0; b != null && i < b.size(); ++i) {
                    disc = b.get(i);
                    size = (Integer)this.state.getAttributeValue(disc, disc_has_size);
                    width = towerwidth * size / (total + 1);
                    g.fillRect(bounds.x + towerwidth + (towerwidth - width) / 2, bounds.height - (i + 1) * (discheight + 1), width, discheight);
                }
                for (i = 0; c != null && i < c.size(); ++i) {
                    disc = c.get(i);
                    size = (Integer)this.state.getAttributeValue(disc, disc_has_size);
                    width = towerwidth * size / (total + 1);
                    g.fillRect(bounds.x + towerwidth * 2 + (towerwidth - width) / 2, bounds.height - (i + 1) * (discheight + 1), width, discheight);
                }
            }
        }
    }
}

