/*
 * Decompiled with CFR 0.152.
 */
package jadex.rules.examples.helloworld;

import jadex.rules.parser.conditions.ParserHelper;
import jadex.rules.rulesystem.AbstractAgenda;
import jadex.rules.rulesystem.IAction;
import jadex.rules.rulesystem.ICondition;
import jadex.rules.rulesystem.IPatternMatcherFunctionality;
import jadex.rules.rulesystem.IRule;
import jadex.rules.rulesystem.IRulebase;
import jadex.rules.rulesystem.IVariableAssignments;
import jadex.rules.rulesystem.LIFOAgenda;
import jadex.rules.rulesystem.RuleSystem;
import jadex.rules.rulesystem.RuleSystemExecutor;
import jadex.rules.rulesystem.Rulebase;
import jadex.rules.rulesystem.rete.RetePatternMatcherFunctionality;
import jadex.rules.rulesystem.rules.Rule;
import jadex.rules.state.IOAVState;
import jadex.rules.state.OAVAttributeType;
import jadex.rules.state.OAVJavaType;
import jadex.rules.state.OAVObjectType;
import jadex.rules.state.OAVTypeModel;
import jadex.rules.state.javaimpl.OAVStateFactory;
import jadex.rules.tools.reteviewer.RuleEnginePanel;

public class OAVHelloWorld {
    public static void main(String[] args) {
        OAVTypeModel helloworld_type_model = new OAVTypeModel("helloworld_type_model");
        helloworld_type_model.addTypeModel(OAVJavaType.java_type_model);
        OAVObjectType message_type = helloworld_type_model.createType("message");
        final OAVAttributeType message_has_text = message_type.createAttributeType("message_has_text", (OAVObjectType)OAVJavaType.java_string_type);
        IOAVState state = OAVStateFactory.createOAVState((OAVTypeModel)helloworld_type_model);
        Rulebase rb = new Rulebase();
        RuleSystem rete = new RuleSystem(state, (IRulebase)rb, (IPatternMatcherFunctionality)new RetePatternMatcherFunctionality((IRulebase)rb), (AbstractAgenda)new LIFOAgenda());
        ICondition msgcon = ParserHelper.parseJavaCondition((String)"message $message", (OAVTypeModel)helloworld_type_model);
        rete.getRulebase().addRule((IRule)new Rule("new_message", msgcon, new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object message = assignments.getVariableValue("$message");
                System.out.println("New message found: " + state.getAttributeValue(message, message_has_text));
            }
        }));
        Object m = state.createRootObject(message_type);
        state.setAttributeValue(m, message_has_text, (Object)"Hello OAV (object, attribute, value) World!");
        rete.init();
        RuleSystemExecutor exe = new RuleSystemExecutor(rete, true);
        RuleEnginePanel.createRuleEngineFrame((RuleSystemExecutor)exe, (String)"HelloWorld");
    }
}

