/*
 * Decompiled with CFR 0.152.
 */
package jadex.rules.examples.manners;

import jadex.rules.examples.manners.IMannersRuleSet;
import jadex.rules.examples.manners.Manners;
import jadex.rules.rulesystem.IAction;
import jadex.rules.rulesystem.ICondition;
import jadex.rules.rulesystem.IRule;
import jadex.rules.rulesystem.IVariableAssignments;
import jadex.rules.rulesystem.rules.AndCondition;
import jadex.rules.rulesystem.rules.BoundConstraint;
import jadex.rules.rulesystem.rules.IConstraint;
import jadex.rules.rulesystem.rules.IOperator;
import jadex.rules.rulesystem.rules.LiteralConstraint;
import jadex.rules.rulesystem.rules.NotCondition;
import jadex.rules.rulesystem.rules.ObjectCondition;
import jadex.rules.rulesystem.rules.Rule;
import jadex.rules.rulesystem.rules.Variable;
import jadex.rules.state.IOAVState;
import jadex.rules.state.OAVJavaType;
import jadex.rules.state.OAVObjectType;

public class MannersRules
implements IMannersRuleSet {
    public IRule createAssignFirstSeatRule() {
        ObjectCondition afs1 = new ObjectCondition(Manners.context_type);
        afs1.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"start"));
        afs1.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f1", Manners.context_type)));
        ObjectCondition afs2 = new ObjectCondition(Manners.guest_type);
        afs2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.guest_has_name, new Variable("?n", (OAVObjectType)OAVJavaType.java_string_type)));
        ObjectCondition afs3 = new ObjectCondition(Manners.count_type);
        afs3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.count_has_c, new Variable("?c", (OAVObjectType)OAVJavaType.java_integer_type)));
        afs3.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f3", Manners.count_type)));
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                Object n = assignments.getVariableValue("?n");
                Object f3 = assignments.getVariableValue("?f3");
                Integer c = (Integer)assignments.getVariableValue("?c");
                System.out.println("Assign first seat: " + f1 + " " + n + " " + f3 + " " + c);
                Object seating = state.createRootObject(Manners.seating_type);
                state.setAttributeValue(seating, Manners.seating_has_seat1, (Object)new Integer(1));
                state.setAttributeValue(seating, Manners.seating_has_name1, n);
                state.setAttributeValue(seating, Manners.seating_has_name2, n);
                state.setAttributeValue(seating, Manners.seating_has_seat2, (Object)new Integer(1));
                state.setAttributeValue(seating, Manners.seating_has_id, (Object)c);
                state.setAttributeValue(seating, Manners.seating_has_pid, (Object)new Integer(0));
                state.setAttributeValue(seating, Manners.seating_has_pathdone, (Object)Boolean.TRUE);
                Object path = state.createRootObject(Manners.path_type);
                state.setAttributeValue(path, Manners.path_has_id, (Object)c);
                state.setAttributeValue(path, Manners.path_has_name, n);
                state.setAttributeValue(path, Manners.path_has_seat, (Object)new Integer(1));
                state.setAttributeValue(f3, Manners.count_has_c, (Object)new Integer(c + 1));
                System.out.println("seat 1: " + n + " " + n + " 1 " + c + " 0 1");
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"assign_seats");
            }
        };
        return new Rule("assign first seat", (ICondition)new AndCondition(new ICondition[]{afs1, afs2, afs3}), action);
    }

    public IRule createFindSeatingRule() {
        ObjectCondition fs1 = new ObjectCondition(Manners.context_type);
        fs1.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"assign_seats"));
        fs1.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f1", Manners.context_type)));
        ObjectCondition fs2 = new ObjectCondition(Manners.seating_type);
        fs2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_seat1, new Variable("?seat1", (OAVObjectType)OAVJavaType.java_integer_type)));
        fs2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_seat2, new Variable("?seat2", (OAVObjectType)OAVJavaType.java_integer_type)));
        fs2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_name2, new Variable("?n2", (OAVObjectType)OAVJavaType.java_string_type)));
        fs2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_id, new Variable("?id", (OAVObjectType)OAVJavaType.java_integer_type)));
        fs2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_pid, new Variable("?pid", (OAVObjectType)OAVJavaType.java_integer_type)));
        fs2.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.seating_has_pathdone, (Object)Boolean.TRUE));
        ObjectCondition fs3 = new ObjectCondition(Manners.guest_type);
        fs3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.guest_has_name, new Variable("?n2", (OAVObjectType)OAVJavaType.java_string_type)));
        fs3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.guest_has_sex, new Variable("?s1", (OAVObjectType)OAVJavaType.java_string_type)));
        fs3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.guest_has_hobby, new Variable("?h1", (OAVObjectType)OAVJavaType.java_string_type)));
        ObjectCondition fs4 = new ObjectCondition(Manners.guest_type);
        fs4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.guest_has_name, new Variable("?g2", (OAVObjectType)OAVJavaType.java_string_type)));
        fs4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.guest_has_sex, new Variable("?s1", (OAVObjectType)OAVJavaType.java_string_type), IOperator.NOTEQUAL));
        fs4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.guest_has_hobby, new Variable("?h1", (OAVObjectType)OAVJavaType.java_string_type)));
        ObjectCondition fs5 = new ObjectCondition(Manners.count_type);
        fs5.addConstraint((IConstraint)new BoundConstraint((Object)Manners.count_has_c, new Variable("?c", (OAVObjectType)OAVJavaType.java_integer_type)));
        fs5.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f5", Manners.count_type)));
        ObjectCondition fs6temp = new ObjectCondition(Manners.path_type);
        fs6temp.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_id, new Variable("?id", (OAVObjectType)OAVJavaType.java_integer_type)));
        fs6temp.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_name, new Variable("?g2", (OAVObjectType)OAVJavaType.java_string_type)));
        NotCondition fs6 = new NotCondition((ICondition)fs6temp);
        ObjectCondition fs7temp = new ObjectCondition(Manners.chosen_type);
        fs7temp.addConstraint((IConstraint)new BoundConstraint((Object)Manners.chosen_has_id, new Variable("?id", (OAVObjectType)OAVJavaType.java_integer_type)));
        fs7temp.addConstraint((IConstraint)new BoundConstraint((Object)Manners.chosen_has_name, new Variable("?g2", (OAVObjectType)OAVJavaType.java_string_type)));
        fs7temp.addConstraint((IConstraint)new BoundConstraint((Object)Manners.chosen_has_hobby, new Variable("?h1", (OAVObjectType)OAVJavaType.java_string_type)));
        NotCondition fs7 = new NotCondition((ICondition)fs7temp);
        AndCondition fs_condition = new AndCondition(new ICondition[]{fs1, fs2, fs3, fs4, fs5, fs6, fs7});
        IAction fs_action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assigments) {
                Integer seat2 = (Integer)assigments.getVariableValue("?seat2");
                String n2 = (String)assigments.getVariableValue("?n2");
                String g2 = (String)assigments.getVariableValue("?g2");
                Integer c = (Integer)assigments.getVariableValue("?c");
                Integer id = (Integer)assigments.getVariableValue("?id");
                Integer pid = (Integer)assigments.getVariableValue("?pid");
                String h1 = (String)assigments.getVariableValue("?h1");
                Object f1 = assigments.getVariableValue("?f1");
                Object f5 = assigments.getVariableValue("?f5");
                Object seating = state.createRootObject(Manners.seating_type);
                state.setAttributeValue(seating, Manners.seating_has_seat1, (Object)seat2);
                state.setAttributeValue(seating, Manners.seating_has_name1, (Object)n2);
                state.setAttributeValue(seating, Manners.seating_has_name2, (Object)g2);
                state.setAttributeValue(seating, Manners.seating_has_seat2, (Object)new Integer(seat2 + 1));
                state.setAttributeValue(seating, Manners.seating_has_id, (Object)c);
                state.setAttributeValue(seating, Manners.seating_has_pid, (Object)id);
                Object path = state.createRootObject(Manners.path_type);
                state.setAttributeValue(path, Manners.path_has_id, (Object)c);
                state.setAttributeValue(path, Manners.path_has_name, (Object)g2);
                state.setAttributeValue(path, Manners.path_has_seat, (Object)new Integer(seat2 + 1));
                Object chosen = state.createRootObject(Manners.chosen_type);
                state.setAttributeValue(chosen, Manners.chosen_has_id, (Object)id);
                state.setAttributeValue(chosen, Manners.chosen_has_name, (Object)g2);
                state.setAttributeValue(chosen, Manners.chosen_has_hobby, (Object)h1);
                state.setAttributeValue(f5, Manners.count_has_c, (Object)new Integer(c + 1));
                if (Manners.print) {
                    System.out.println("find seating: seat2=" + seat2 + ", n2=" + n2 + ", g2=" + g2 + ", pid=" + pid);
                }
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"make_path");
            }
        };
        return new Rule("find seating", (ICondition)fs_condition, fs_action);
    }

    public IRule createMakePathRule() {
        ObjectCondition mk1 = new ObjectCondition(Manners.context_type);
        mk1.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"make_path"));
        ObjectCondition mk2 = new ObjectCondition(Manners.seating_type);
        mk2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_id, new Variable("?id", (OAVObjectType)OAVJavaType.java_integer_type)));
        mk2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_pid, new Variable("?pid", (OAVObjectType)OAVJavaType.java_integer_type)));
        mk2.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.seating_has_pathdone, (Object)Boolean.FALSE));
        ObjectCondition mk3 = new ObjectCondition(Manners.path_type);
        mk3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_id, new Variable("?pid", (OAVObjectType)OAVJavaType.java_integer_type)));
        mk3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_name, new Variable("?n1", (OAVObjectType)OAVJavaType.java_integer_type)));
        mk3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_seat, new Variable("?s", (OAVObjectType)OAVJavaType.java_integer_type)));
        ObjectCondition oc4 = new ObjectCondition(Manners.path_type);
        oc4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_id, new Variable("?id", (OAVObjectType)OAVJavaType.java_integer_type)));
        oc4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_name, new Variable("?n1", (OAVObjectType)OAVJavaType.java_integer_type)));
        NotCondition mk4 = new NotCondition((ICondition)oc4);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Integer id = (Integer)assignments.getVariableValue("?id");
                String n1 = (String)assignments.getVariableValue("?n1");
                Integer s = (Integer)assignments.getVariableValue("?s");
                if (Manners.print) {
                    System.out.println("Make path: " + id + " " + n1 + " " + s);
                }
                Object path = state.createRootObject(Manners.path_type);
                state.setAttributeValue(path, Manners.path_has_id, (Object)id);
                state.setAttributeValue(path, Manners.path_has_name, (Object)n1);
                state.setAttributeValue(path, Manners.path_has_seat, (Object)s);
            }
        };
        return new Rule("make path", (ICondition)new AndCondition(new ICondition[]{mk1, mk2, mk3, mk4}), action);
    }

    public IRule createPathDoneRule() {
        ObjectCondition pd1 = new ObjectCondition(Manners.context_type);
        pd1.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"make_path"));
        pd1.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f1", Manners.context_type)));
        ObjectCondition pd2 = new ObjectCondition(Manners.seating_type);
        pd2.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.seating_has_pathdone, (Object)Boolean.FALSE));
        pd2.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f2", Manners.seating_type)));
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                Object f2 = assignments.getVariableValue("?f2");
                if (Manners.print) {
                    System.out.println("Path done: " + f1 + " " + f2);
                }
                state.setAttributeValue(f2, Manners.seating_has_pathdone, (Object)Boolean.TRUE);
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"check_done");
            }
        };
        return new Rule("path done", (ICondition)new AndCondition(new ICondition[]{pd1, pd2}), action);
    }

    public IRule createAreWeDoneRule() {
        ObjectCondition awd1 = new ObjectCondition(Manners.context_type);
        awd1.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"check_done"));
        awd1.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f1", Manners.context_type)));
        ObjectCondition awd2 = new ObjectCondition(Manners.lastseat_type);
        awd2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.lastseat_has_seat, new Variable("?l_seat", (OAVObjectType)OAVJavaType.java_integer_type)));
        ObjectCondition awd3 = new ObjectCondition(Manners.seating_type);
        awd3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_seat2, new Variable("?l_seat", (OAVObjectType)OAVJavaType.java_integer_type)));
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                System.out.println("Yes, we are done!! " + f1);
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"print_results");
            }
        };
        return new Rule("are we done", (ICondition)new AndCondition(new ICondition[]{awd1, awd2, awd3}), action);
    }

    public IRule createContinueRule() {
        ObjectCondition c = new ObjectCondition(Manners.context_type);
        c.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"check_done"));
        c.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f1", Manners.context_type)));
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                if (Manners.print) {
                    System.out.println("Continue: " + f1);
                }
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"assign_seats");
            }
        };
        return new Rule("continue", (ICondition)c, action);
    }

    public IRule createPrintResultsRule() {
        ObjectCondition pr1 = new ObjectCondition(Manners.context_type);
        pr1.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"print_results"));
        ObjectCondition pr2 = new ObjectCondition(Manners.seating_type);
        pr2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_id, new Variable("?id", (OAVObjectType)OAVJavaType.java_integer_type)));
        pr2.addConstraint((IConstraint)new BoundConstraint((Object)Manners.seating_has_seat2, new Variable("?s2", (OAVObjectType)OAVJavaType.java_integer_type)));
        ObjectCondition pr3 = new ObjectCondition(Manners.lastseat_type);
        pr3.addConstraint((IConstraint)new BoundConstraint((Object)Manners.lastseat_has_seat, new Variable("?s2", (OAVObjectType)OAVJavaType.java_integer_type)));
        ObjectCondition pr4 = new ObjectCondition(Manners.path_type);
        pr4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_id, new Variable("?id", (OAVObjectType)OAVJavaType.java_integer_type)));
        pr4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_name, new Variable("?n", (OAVObjectType)OAVJavaType.java_string_type)));
        pr4.addConstraint((IConstraint)new BoundConstraint((Object)Manners.path_has_seat, new Variable("?s", (OAVObjectType)OAVJavaType.java_integer_type)));
        pr4.addConstraint((IConstraint)new BoundConstraint(null, new Variable("?f4", Manners.path_type)));
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f4 = assignments.getVariableValue("?f4");
                Object n = assignments.getVariableValue("?n");
                Object s = assignments.getVariableValue("?s");
                System.out.println("Result: guest=" + n + " seat=" + s);
                state.dropObject(f4);
            }
        };
        return new Rule("print results", (ICondition)new AndCondition(new ICondition[]{pr1, pr2, pr3, pr4}), action);
    }

    public IRule createAllDoneRule() {
        ObjectCondition ad = new ObjectCondition(Manners.context_type);
        ad.addConstraint((IConstraint)new LiteralConstraint((Object)Manners.context_has_state, (Object)"print_results"));
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                System.out.println("TERMINATED!!!");
            }
        };
        return new Rule("all done", (ICondition)ad, action);
    }
}

