/*
 * Decompiled with CFR 0.152.
 */
package jadex.rules.examples.manners;

import jadex.rules.examples.manners.IMannersRuleSet;
import jadex.rules.examples.manners.Manners;
import jadex.rules.parser.conditions.ParserHelper;
import jadex.rules.rulesystem.IAction;
import jadex.rules.rulesystem.ICondition;
import jadex.rules.rulesystem.IRule;
import jadex.rules.rulesystem.IVariableAssignments;
import jadex.rules.rulesystem.rules.Rule;
import jadex.rules.state.IOAVState;
import jadex.rules.state.OAVTypeModel;

public class MannersRulesClips
implements IMannersRuleSet {
    public IRule createAssignFirstSeatRule() {
        ICondition cond = ParserHelper.parseClipsCondition((String)"?f1 <- (context (context_has_state \"start\"))(guest (guest_has_name ?n))?f3 <- (count (count_has_c ?c))", (OAVTypeModel)Manners.manners_type_model);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                Object n = assignments.getVariableValue("?n");
                Object f3 = assignments.getVariableValue("?f3");
                Integer c = (Integer)assignments.getVariableValue("?c");
                System.out.println("Assign first seat: " + f1 + " " + n + " " + f3 + " " + c);
                Object seating = state.createRootObject(Manners.seating_type);
                state.setAttributeValue(seating, Manners.seating_has_seat1, (Object)new Integer(1));
                state.setAttributeValue(seating, Manners.seating_has_name1, n);
                state.setAttributeValue(seating, Manners.seating_has_name2, n);
                state.setAttributeValue(seating, Manners.seating_has_seat2, (Object)new Integer(1));
                state.setAttributeValue(seating, Manners.seating_has_id, (Object)c);
                state.setAttributeValue(seating, Manners.seating_has_pid, (Object)new Integer(0));
                state.setAttributeValue(seating, Manners.seating_has_pathdone, (Object)Boolean.TRUE);
                Object path = state.createRootObject(Manners.path_type);
                state.setAttributeValue(path, Manners.path_has_id, (Object)c);
                state.setAttributeValue(path, Manners.path_has_name, n);
                state.setAttributeValue(path, Manners.path_has_seat, (Object)new Integer(1));
                state.setAttributeValue(f3, Manners.count_has_c, (Object)new Integer(c + 1));
                System.out.println("seat 1: " + n + " " + n + " 1 " + c + " 0 1");
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"assign_seats");
            }
        };
        return new Rule("assign first seat", cond, action);
    }

    public IRule createFindSeatingRule() {
        ICondition cond = ParserHelper.parseClipsCondition((String)"?f1 <- (context (context_has_state \"assign_seats\"))(seating (seating_has_seat1 ?seat1) (seating_has_seat2 ?seat2) (seating_has_name2 ?n2) (seating_has_id ?id) (seating_has_pid ?pid) (seating_has_pathdone true))(guest (guest_has_name ?n2) (guest_has_sex ?s1) (guest_has_hobby ?h1))(guest (guest_has_name ?g2) (guest_has_sex ~?s1) (guest_has_hobby ?h1))?f5 <- (count (count_has_c ?c))(not (path (path_has_id ?id) (path_has_name ?g2)))(not (chosen (chosen_has_id ?id) (chosen_has_name ?g2) (chosen_has_hobby ?h1)))", (OAVTypeModel)Manners.manners_type_model);
        IAction fs_action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assigments) {
                Integer seat2 = (Integer)assigments.getVariableValue("?seat2");
                String n2 = (String)assigments.getVariableValue("?n2");
                String g2 = (String)assigments.getVariableValue("?g2");
                Integer c = (Integer)assigments.getVariableValue("?c");
                Integer id = (Integer)assigments.getVariableValue("?id");
                Integer pid = (Integer)assigments.getVariableValue("?pid");
                String h1 = (String)assigments.getVariableValue("?h1");
                Object f1 = assigments.getVariableValue("?f1");
                Object f5 = assigments.getVariableValue("?f5");
                Object seating = state.createRootObject(Manners.seating_type);
                state.setAttributeValue(seating, Manners.seating_has_seat1, (Object)seat2);
                state.setAttributeValue(seating, Manners.seating_has_name1, (Object)n2);
                state.setAttributeValue(seating, Manners.seating_has_name2, (Object)g2);
                state.setAttributeValue(seating, Manners.seating_has_seat2, (Object)new Integer(seat2 + 1));
                state.setAttributeValue(seating, Manners.seating_has_id, (Object)c);
                state.setAttributeValue(seating, Manners.seating_has_pid, (Object)id);
                Object path = state.createRootObject(Manners.path_type);
                state.setAttributeValue(path, Manners.path_has_id, (Object)c);
                state.setAttributeValue(path, Manners.path_has_name, (Object)g2);
                state.setAttributeValue(path, Manners.path_has_seat, (Object)new Integer(seat2 + 1));
                Object chosen = state.createRootObject(Manners.chosen_type);
                state.setAttributeValue(chosen, Manners.chosen_has_id, (Object)id);
                state.setAttributeValue(chosen, Manners.chosen_has_name, (Object)g2);
                state.setAttributeValue(chosen, Manners.chosen_has_hobby, (Object)h1);
                state.setAttributeValue(f5, Manners.count_has_c, (Object)new Integer(c + 1));
                if (Manners.print) {
                    System.out.println("find seating: seat2=" + seat2 + ", n2=" + n2 + ", g2=" + g2 + ", pid=" + pid);
                }
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"make_path");
            }
        };
        return new Rule("find seating", cond, fs_action);
    }

    public IRule createMakePathRule() {
        ICondition cond = ParserHelper.parseClipsCondition((String)"(context (context_has_state \"make_path\"))(seating (seating_has_id ?id) (seating_has_pid ?pid) (seating_has_pathdone false))(path (path_has_id ?pid) (path_has_name ?n1) (path_has_seat ?s))(not (path (path_has_id ?id) (path_has_name ?n1)))", (OAVTypeModel)Manners.manners_type_model);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Integer id = (Integer)assignments.getVariableValue("?id");
                String n1 = (String)assignments.getVariableValue("?n1");
                Integer s = (Integer)assignments.getVariableValue("?s");
                if (Manners.print) {
                    System.out.println("Make path: " + id + " " + n1 + " " + s);
                }
                Object path = state.createRootObject(Manners.path_type);
                state.setAttributeValue(path, Manners.path_has_id, (Object)id);
                state.setAttributeValue(path, Manners.path_has_name, (Object)n1);
                state.setAttributeValue(path, Manners.path_has_seat, (Object)s);
            }
        };
        return new Rule("make path", cond, action);
    }

    public IRule createPathDoneRule() {
        ICondition cond = ParserHelper.parseClipsCondition((String)"?f1 <- (context (context_has_state \"make_path\"))?f2 <- (seating (seating_has_pathdone false))", (OAVTypeModel)Manners.manners_type_model);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                Object f2 = assignments.getVariableValue("?f2");
                if (Manners.print) {
                    System.out.println("Path done: " + f1 + " " + f2);
                }
                state.setAttributeValue(f2, Manners.seating_has_pathdone, (Object)Boolean.TRUE);
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"check_done");
            }
        };
        return new Rule("path done", cond, action);
    }

    public IRule createAreWeDoneRule() {
        ICondition cond = ParserHelper.parseClipsCondition((String)"?f1 <- (context (context_has_state \"check_done\"))(lastseat (lastseat_has_seat ?l_seat))(seating (seating_has_seat2 ?l_seat))", (OAVTypeModel)Manners.manners_type_model);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                System.out.println("Yes, we are done!! " + f1);
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"print_results");
            }
        };
        return new Rule("are we done", cond, action);
    }

    public IRule createContinueRule() {
        ICondition c = ParserHelper.parseClipsCondition((String)"?f1 <- (context (context_has_state \"check_done\"))", (OAVTypeModel)Manners.manners_type_model);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f1 = assignments.getVariableValue("?f1");
                if (Manners.print) {
                    System.out.println("Continue: " + f1);
                }
                state.setAttributeValue(f1, Manners.context_has_state, (Object)"assign_seats");
            }
        };
        return new Rule("continue", c, action);
    }

    public IRule createPrintResultsRule() {
        ICondition cond = ParserHelper.parseClipsCondition((String)"(context (context_has_state \"print_results\"))(seating (seating_has_id ?id) (seating_has_seat2 ?s2))(lastseat (lastseat_has_seat ?s2))?f4 <- (path (path_has_id ?id) (path_has_name ?n) (path_has_seat ?s))", (OAVTypeModel)Manners.manners_type_model);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                Object f4 = assignments.getVariableValue("?f4");
                Object n = assignments.getVariableValue("?n");
                Object s = assignments.getVariableValue("?s");
                System.out.println("Result: guest=" + n + " seat=" + s);
                state.dropObject(f4);
            }
        };
        return new Rule("print results", cond, action);
    }

    public IRule createAllDoneRule() {
        ICondition ad = ParserHelper.parseClipsCondition((String)"(context (context_has_state \"print_results\"))", (OAVTypeModel)Manners.manners_type_model);
        IAction action = new IAction(){

            public void execute(IOAVState state, IVariableAssignments assignments) {
                System.out.println("TERMINATED!!!");
            }
        };
        return new Rule("all done", ad, action);
    }
}

