/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml;

import jadex.xml.AbstractInfo;
import jadex.xml.TypeInfo;
import jadex.xml.stax.QName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TypeInfoPathManager {
    protected Map typeinfos;

    public TypeInfoPathManager(Set typeinfos) {
        if (typeinfos != null) {
            Iterator it = typeinfos.iterator();
            while (it.hasNext()) {
                this.addTypeInfo((TypeInfo)it.next());
            }
        }
    }

    public synchronized TypeInfo getTypeInfo(QName tag, QName[] fullpath, Map rawattributes) {
        return this.findTypeInfo((Set)this.typeinfos.get(tag), fullpath, rawattributes);
    }

    public synchronized void addTypeInfo(TypeInfo typeinfo) {
        if (this.typeinfos == null) {
            this.typeinfos = new HashMap();
        }
        if (typeinfo.getXMLTag() == null) {
            throw new RuntimeException("XML tag must not be null: " + typeinfo);
        }
        TreeSet<TypeInfo> tiset = (TreeSet<TypeInfo>)this.typeinfos.get(typeinfo.getXMLTag());
        if (tiset == null) {
            tiset = new TreeSet<TypeInfo>(new AbstractInfo.SpecificityComparator());
            this.typeinfos.put(typeinfo.getXMLTag(), tiset);
        }
        tiset.add(typeinfo);
    }

    protected synchronized TypeInfo findTypeInfo(Set typeinfos, QName[] fullpath, Map rawattributes) {
        TypeInfo ret = null;
        if (typeinfos != null) {
            Iterator it = typeinfos.iterator();
            while (ret == null && it.hasNext()) {
                boolean ok;
                TypeInfo ti = (TypeInfo)it.next();
                QName[] tmp = ti.getXMLPathElements();
                boolean bl = ok = !(ti.getFilter() != null && !ti.getFilter().filter((Object)rawattributes) || tmp != null && tmp.length > fullpath.length);
                if (tmp != null) {
                    for (int i = 1; i <= tmp.length && ok; ++i) {
                        ok = tmp[tmp.length - i].equals(fullpath[fullpath.length - i]);
                    }
                }
                if (!ok) continue;
                ret = ti;
            }
        }
        return ret;
    }
}

