/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml;

import jadex.commons.IFilter;
import jadex.xml.IPreProcessor;
import jadex.xml.stax.QName;
import java.util.StringTokenizer;

public class XMLInfo {
    protected String xmlpath;
    protected QName[] xmlpathelements;
    protected IFilter filter;
    protected boolean createfromtag;
    protected IPreProcessor preprocessor;

    public XMLInfo(String xmlpath) {
        this(xmlpath, (IFilter)null);
    }

    public XMLInfo(QName xmltag) {
        this(new QName[]{xmltag}, (IFilter)null);
    }

    public XMLInfo(QName[] xmlpathelements) {
        this(xmlpathelements, (IFilter)null);
    }

    public XMLInfo(String xmlpath, IFilter filter) {
        this(xmlpath, filter, false);
    }

    public XMLInfo(QName xmltag, IFilter filter) {
        this(new QName[]{xmltag}, filter, false);
    }

    public XMLInfo(QName[] xmlpathelements, IFilter filter) {
        this(xmlpathelements, filter, false);
    }

    public XMLInfo(String xmlpath, IPreProcessor preprocessor) {
        this(xmlpath, null, false, preprocessor);
    }

    public XMLInfo(QName[] xmlpathelements, IPreProcessor preprocessor) {
        this(xmlpathelements, null, false, preprocessor);
    }

    public XMLInfo(String xmlpath, IFilter filter, boolean createfromtag) {
        this(xmlpath, filter, createfromtag, null);
    }

    public XMLInfo(String xmlpath, IFilter filter, boolean createfromtag, IPreProcessor preprocessor) {
        this.setXMLPath(xmlpath);
        this.filter = filter;
        this.createfromtag = createfromtag;
        this.preprocessor = preprocessor;
    }

    public XMLInfo(QName xmltag, IFilter filter, boolean createfromtag) {
        this(new QName[]{xmltag}, filter, createfromtag);
    }

    public XMLInfo(QName[] xmlpathelements, IFilter filter, boolean createfromtag) {
        this(xmlpathelements, filter, createfromtag, null);
    }

    public XMLInfo(QName[] xmlpathelements, IFilter filter, boolean createfromtag, IPreProcessor preprocessor) {
        this.setXMLPathElements(xmlpathelements);
        this.filter = filter;
        this.createfromtag = createfromtag;
        this.preprocessor = preprocessor;
    }

    public String getXMLPath() {
        return this.xmlpath;
    }

    protected void setXMLPath(String xmlpath) {
        this.xmlpath = xmlpath;
        StringTokenizer stok = new StringTokenizer(xmlpath, "/");
        this.xmlpathelements = new QName[stok.countTokens()];
        int i = 0;
        while (stok.hasMoreTokens()) {
            this.xmlpathelements[i] = QName.valueOf(stok.nextToken());
            ++i;
        }
    }

    public QName[] getXMLPathElements() {
        return this.xmlpathelements;
    }

    protected void setXMLPathElements(QName[] xmlpathelements) {
        this.xmlpathelements = xmlpathelements;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < xmlpathelements.length; ++i) {
            if (i > 0) {
                buf.append("/");
            }
            buf.append(xmlpathelements[i].getLocalPart());
        }
        this.xmlpath = buf.toString();
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public boolean isCreateFromTag() {
        return this.createfromtag;
    }

    public IPreProcessor getPreProcessor() {
        return this.preprocessor;
    }
}

