/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.writer;

import jadex.commons.collection.Tree;
import jadex.commons.collection.TreeNode;
import jadex.xml.stax.QName;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WriteObjectInfo {
    protected String comment;
    protected Map attributes;
    protected String content;
    protected Tree subobjects;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Object name, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap();
        } else if (this.attributes.containsKey(name)) {
            throw new RuntimeException("Duplicate attribute: " + name);
        }
        this.attributes.put(name, value);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Tree getSubobjects() {
        return this.subobjects;
    }

    public void addSubobject(QName[] pathname, Object subobject, boolean flatten) {
        if (this.subobjects == null) {
            this.subobjects = new Tree();
        }
        TreeNode node = this.subobjects.getRootNode();
        for (int i = 0; i < pathname.length; ++i) {
            node = this.getOrCreateChild(node, pathname[i], i + 1 == pathname.length ? false : flatten);
        }
        node.setData((Object)new Object[]{node.getData(), subobject});
    }

    protected TreeNode getOrCreateChild(TreeNode node, QName tag, boolean flatten) {
        List children;
        TreeNode ret = null;
        if (flatten && (children = node.getChildren()) != null) {
            for (int i = 0; i < children.size() && ret == null; ++i) {
                TreeNode tmp = (TreeNode)children.get(i);
                if (!tag.equals(tmp.getData())) continue;
                ret = tmp;
            }
        }
        if (ret == null) {
            ret = new TreeNode((Object)tag);
            node.addChild(ret);
        }
        return ret;
    }
}

