/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.reader;

import jadex.commons.collection.MultiCollection;
import jadex.xml.IContext;
import jadex.xml.StackElement;
import jadex.xml.TypeInfoPathManager;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.QName;
import jadex.xml.stax.XMLReporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AReadContext<T>
implements IContext {
    protected TypeInfoPathManager pathmanager;
    protected IObjectReaderHandler defaulthandler;
    protected T parser;
    protected XMLReporter reporter;
    protected ClassLoader classloader;
    protected Object rootobject;
    protected List stack;
    protected String comment;
    protected Map readobjects;
    protected int readignore;
    protected Object callcontext;
    protected MultiCollection postprocessors;
    protected Map arrayinfos;
    protected MultiCollection children;

    public AReadContext(TypeInfoPathManager pathmanager, IObjectReaderHandler handler, T parser, XMLReporter reporter, Object callcontext, ClassLoader classloader) {
        this(pathmanager, handler, parser, reporter, callcontext, classloader, null, new ArrayList(), null, null, new HashMap(), 0, new MultiCollection());
    }

    public AReadContext(TypeInfoPathManager pathmanager, IObjectReaderHandler handler, T parser, XMLReporter reporter, Object callcontext, ClassLoader classloader, Object root, List stack, StackElement topse, String comment, Map readobjects, int readignore, MultiCollection postprocessors) {
        this.pathmanager = pathmanager;
        this.defaulthandler = handler;
        this.parser = parser;
        this.reporter = reporter;
        this.callcontext = callcontext;
        this.classloader = classloader;
        this.stack = stack;
        this.comment = comment;
        this.readobjects = readobjects;
        this.readignore = readignore;
        this.postprocessors = postprocessors;
    }

    public T getParser() {
        return this.parser;
    }

    public TypeInfoPathManager getPathManager() {
        return this.pathmanager;
    }

    public IObjectReaderHandler getDefaultHandler() {
        return this.defaulthandler;
    }

    public XMLReporter getReporter() {
        return this.reporter;
    }

    @Override
    public Object getRootObject() {
        return this.rootobject != null ? this.rootobject : (this.stack != null && !this.stack.isEmpty() ? ((StackElement)this.stack.get(0)).getObject() : null);
    }

    public StackElement getStackElement(int pos) {
        return (StackElement)this.stack.get(pos);
    }

    public StackElement getTopStackElement() {
        StackElement ret = this.stack.isEmpty() ? null : (StackElement)this.stack.get(this.stack.size() - 1);
        return ret;
    }

    public void addStackElement(StackElement elem) {
        this.stack.add(elem);
    }

    public void setStackElement(StackElement elem, int pos) {
        this.stack.set(pos, elem);
    }

    public void removeStackElement() {
        StackElement elem = (StackElement)this.stack.remove(this.stack.size() - 1);
        if (this.stack.size() == 0) {
            this.rootobject = elem.getObject();
        }
    }

    public int getStackSize() {
        return this.stack.size();
    }

    public abstract ILocation getLocation();

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map getReadObjects() {
        return this.readobjects;
    }

    public void setReadObjects(Map readobjects) {
        this.readobjects = readobjects;
    }

    public int getReadIgnore() {
        return this.readignore;
    }

    public void setReadIgnore(int readignore) {
        this.readignore = readignore;
    }

    @Override
    public Object getUserContext() {
        return this.callcontext;
    }

    public void setCallContext(Object callcontext) {
        this.callcontext = callcontext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public MultiCollection getPostProcessors() {
        return this.postprocessors;
    }

    public void setPostProcessors(MultiCollection postprocessors) {
        this.postprocessors = postprocessors;
    }

    public int getArrayCount(Object parent) {
        int ret = 0;
        if (this.arrayinfos == null) {
            this.arrayinfos = new HashMap();
        }
        if (this.arrayinfos.containsKey(parent)) {
            ret = (Integer)this.arrayinfos.get(parent);
        }
        this.arrayinfos.put(parent, ret + 1);
        return ret;
    }

    public Object getChildren(Object key) {
        return this.children == null ? null : this.children.get(key);
    }

    public void addChild(Object key, Object value) {
        if (this.children == null) {
            this.children = new MultiCollection();
        }
        this.children.put(key, value);
    }

    public List removeChildren(Object key) {
        return this.children == null ? null : (List)this.children.remove(key);
    }

    public QName[] getXMLPath(QName tag) {
        QName[] ret = new QName[this.stack.size() + 1];
        for (int i = 0; i < this.stack.size(); ++i) {
            ret[i] = ((StackElement)this.stack.get(i)).getTag();
        }
        ret[ret.length - 1] = tag;
        return ret;
    }

    protected QName[] getXMLPath() {
        QName[] ret = new QName[this.stack.size()];
        for (int i = 0; i < this.stack.size(); ++i) {
            ret[i] = ((StackElement)this.stack.get(i)).getTag();
        }
        return ret;
    }

    public StackElement[] getStack() {
        return this.stack.toArray(new StackElement[this.stack.size()]);
    }
}

