/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.reader;

import jadex.commons.SUtil;
import jadex.xml.AttributeInfo;
import jadex.xml.IAttributeConverter;
import jadex.xml.IPostProcessor;
import jadex.xml.StackElement;
import jadex.xml.SubobjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.TypeInfoPathManager;
import jadex.xml.reader.AReader;
import jadex.xml.reader.IBulkObjectLinker;
import jadex.xml.reader.IObjectLinker;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.reader.IPostProcessorCall;
import jadex.xml.reader.LinkData;
import jadex.xml.reader.ReadContextDesktop;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.StaxLocationWrapper;
import jadex.xml.stax.StaxXMLReporterWrapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Reader
extends AReader {
    protected boolean bulklink;
    protected XMLInputFactory factory;

    public Reader() {
        this(false);
    }

    public Reader(boolean bulklink) {
        this(bulklink, false, null);
    }

    public Reader(boolean bulklink, boolean validate, XMLReporter reporter) {
        this(bulklink, validate, false, reporter);
    }

    public Reader(boolean bulklink, boolean validate, boolean coalescing, XMLReporter reporter) {
        this.bulklink = bulklink;
        this.factory = XMLInputFactory.newInstance();
        try {
            this.factory.setProperty("javax.xml.stream.isValidating", validate ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            System.err.println("Error setting validation to " + validate);
        }
        try {
            this.factory.setProperty("javax.xml.stream.isCoalescing", coalescing ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            System.err.println("Error setting coalescing to " + coalescing);
        }
        if (reporter != null) {
            this.factory.setProperty("javax.xml.stream.reporter", reporter);
        } else {
            this.factory.setProperty("javax.xml.stream.reporter", new XMLReporter(){

                @Override
                public void report(String message, String error, Object related, Location location) throws XMLStreamException {
                    throw new XMLStreamException(message, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, java.io.Reader input, ClassLoader classloader, Object callcontext) throws Exception {
        XMLStreamReader parser;
        XMLInputFactory xMLInputFactory = this.factory;
        synchronized (xMLInputFactory) {
            parser = this.factory.createXMLStreamReader(input);
        }
        return this.read(tipmanager, handler, parser, classloader, callcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, InputStream input, ClassLoader classloader, Object callcontext) throws Exception {
        XMLStreamReader parser;
        XMLInputFactory xMLInputFactory = this.factory;
        synchronized (xMLInputFactory) {
            parser = this.factory.createXMLStreamReader(input);
        }
        return this.read(tipmanager, handler, parser, classloader, callcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(TypeInfoPathManager tipmanager, IObjectReaderHandler handler, XMLStreamReader parser, ClassLoader classloader, Object callcontext) throws Exception {
        ReadContextDesktop readcontext = new ReadContextDesktop(tipmanager, handler, parser, StaxXMLReporterWrapper.fromXMLReporter(this.factory.getXMLReporter()), callcontext, classloader);
        READ_CONTEXT.set(readcontext);
        try {
            while (parser.hasNext()) {
                int next = parser.next();
                if (next == 5) {
                    this.handleComment(readcontext);
                    continue;
                }
                if (next == 4 || next == 12) {
                    this.handleContent(readcontext);
                    continue;
                }
                if (next == 1) {
                    this.handleStartElement(readcontext);
                    continue;
                }
                if (next != 2) continue;
                this.handleEndElement(readcontext);
            }
            int i = 1;
            while (readcontext.getPostProcessors().size() > 0) {
                List ps = (List)readcontext.getPostProcessors().remove((Object)i);
                if (ps != null) {
                    for (int j = 0; j < ps.size(); ++j) {
                        ((IPostProcessorCall)ps.get(j)).callPostProcessor();
                    }
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            ILocation loc = readcontext.getStackSize() > 0 ? readcontext.getTopStackElement().getLocation() : StaxLocationWrapper.fromLocation(parser.getLocation());
            readcontext.getReporter().report(e.toString(), "XML error", readcontext, loc);
        }
        finally {
            READ_CONTEXT.set(null);
            parser.close();
        }
        return readcontext.getRootObject() == NULL ? null : readcontext.getRootObject();
    }

    protected void handleComment(ReadContextDesktop readcontext) throws Exception {
        if (readcontext.getReadIgnore() == 0) {
            readcontext.setComment(((XMLStreamReader)readcontext.getParser()).getText());
        }
    }

    protected void handleContent(ReadContextDesktop readcontext) throws Exception {
        if (readcontext.getReadIgnore() == 0) {
            readcontext.getTopStackElement().addContent(((XMLStreamReader)readcontext.getParser()).getText());
        }
    }

    protected void handleStartElement(ReadContextDesktop readcontext) throws Exception {
        XMLStreamReader parser = (XMLStreamReader)readcontext.getParser();
        if (readcontext.getReadIgnore() > 0) {
            readcontext.setReadIgnore(readcontext.getReadIgnore() + 1);
        } else if (readcontext.getReadIgnore() == 0) {
            IObjectReaderHandler handler;
            HashMap<String, String> rawattrs = null;
            int attrcnt = parser.getAttributeCount();
            if (attrcnt > 0) {
                rawattrs = new HashMap<String, String>();
                for (int i = 0; i < attrcnt; ++i) {
                    String attrname = parser.getAttributeLocalName(i);
                    String attrval = parser.getAttributeValue(i);
                    rawattrs.put(attrname, attrval);
                }
            }
            Object object = null;
            jadex.xml.stax.QName localname = Reader.convertStaXQNameToQName(parser.getName());
            jadex.xml.stax.QName[] fullpath = readcontext.getXMLPath(localname);
            TypeInfo typeinfo = readcontext.getPathManager().getTypeInfo(localname, fullpath, rawattrs);
            IObjectReaderHandler iObjectReaderHandler = handler = typeinfo != null ? typeinfo.getReaderHandler() : null;
            if (handler == null) {
                if (readcontext.getTopStackElement() != null && readcontext.getTopStackElement().getReaderHandler() != null) {
                    handler = readcontext.getTopStackElement().getReaderHandler();
                } else if (readcontext.getDefaultHandler() != null) {
                    handler = readcontext.getDefaultHandler();
                } else {
                    readcontext.getReporter().report("No handler for element: " + localname, "type info error", readcontext, StaxLocationWrapper.fromLocation(parser.getLocation()));
                }
            }
            if (readcontext.getStackSize() > 0) {
                TypeInfo patypeinfo;
                SubobjectInfo linkinfo;
                StackElement pse = readcontext.getTopStackElement();
                ArrayList<jadex.xml.stax.QName> pathname = new ArrayList<jadex.xml.stax.QName>();
                pathname.add(localname);
                for (int i = readcontext.getStackSize() - 2; i >= 0 && pse.getObject() == null; --i) {
                    pse = readcontext.getStackElement(i);
                    pathname.add(0, readcontext.getStackElement(i + 1).getTag());
                }
                if (pse != null && (linkinfo = Reader.getSubobjectInfoRead(localname, fullpath, patypeinfo = pse.getTypeInfo(), readcontext.getTopStackElement() != null ? readcontext.getTopStackElement().getRawAttributes() : null)) != null && linkinfo.getAccessInfo().isIgnoreRead()) {
                    readcontext.setReadIgnore(readcontext.getReadIgnore() + 1);
                }
            }
            if (readcontext.getReadIgnore() == 0) {
                String idref;
                String string = idref = rawattrs != null ? (String)rawattrs.get("__IDREF") : null;
                if (idref != null) {
                    StackElement se;
                    if (readcontext.getReadObjects().containsKey(idref)) {
                        object = readcontext.getReadObjects().get(idref);
                        se = new StackElement(handler, localname, object, rawattrs, typeinfo, StaxLocationWrapper.fromLocation(parser.getLocation()));
                        readcontext.addStackElement(se);
                    } else {
                        se = new StackElement(handler, localname, null, rawattrs, typeinfo, StaxLocationWrapper.fromLocation(parser.getLocation()));
                        readcontext.addStackElement(se);
                        readcontext.getReporter().report("idref not contained: " + idref, "idref error", se, se.getLocation());
                    }
                } else {
                    Object commentinfo;
                    String id;
                    Object ti = typeinfo;
                    if (localname.getNamespaceURI().startsWith("typeinfo:") && (typeinfo == null || typeinfo.isCreateFromTag())) {
                        ti = localname;
                    }
                    try {
                        object = handler.createObject(ti, readcontext.getStackSize() == 0, readcontext, rawattrs);
                    }
                    catch (Exception e) {
                        readcontext.getReporter().report(e.toString(), "creation error", readcontext, StaxLocationWrapper.fromLocation(parser.getLocation()));
                        readcontext.removeStackElement();
                        readcontext.setReadIgnore(1);
                    }
                    if (typeinfo == null && object != null) {
                        typeinfo = handler.getTypeInfo(object, fullpath, readcontext);
                    }
                    String string2 = id = rawattrs != null ? (String)rawattrs.get("__ID") : null;
                    if (id != null && object != null) {
                        readcontext.getReadObjects().put(id, object);
                    }
                    readcontext.addStackElement(new StackElement(handler, localname, object, rawattrs, typeinfo, StaxLocationWrapper.fromLocation(parser.getLocation())));
                    int atcnt = attrcnt;
                    if (rawattrs != null) {
                        if (rawattrs.containsKey("__ID")) {
                            --atcnt;
                        }
                        if (rawattrs.containsKey("__len")) {
                            --atcnt;
                        }
                    }
                    if (atcnt > 0) {
                        ArrayList<jadex.xml.stax.QName> attrpath = null;
                        if (object == null) {
                            attrpath = new ArrayList<jadex.xml.stax.QName>();
                            attrpath.add(readcontext.getTopStackElement().getTag());
                            for (int i = readcontext.getStackSize() - 2; i >= 0 && object == null; --i) {
                                StackElement pse = readcontext.getStackElement(i);
                                attrpath.add(pse.getTag());
                                typeinfo = pse.getTypeInfo();
                                object = pse.getObject();
                            }
                        }
                        if (object != null) {
                            Set attrs = typeinfo == null ? Collections.EMPTY_SET : typeinfo.getXMLAttributeNames();
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                Object attrinfo;
                                jadex.xml.stax.QName attrname;
                                jadex.xml.stax.QName qName = attrname = parser.getAttributePrefix(i) == null || "".equals(parser.getAttributePrefix(i)) ? new jadex.xml.stax.QName(parser.getAttributeLocalName(i)) : new jadex.xml.stax.QName(parser.getAttributeNamespace(i), parser.getAttributeLocalName(i), parser.getAttributePrefix(i));
                                if ("__ID".equals(attrname.getLocalPart()) || "__len".equals(attrname.getLocalPart())) continue;
                                String attrval = parser.getAttributeValue(i);
                                attrs.remove(attrname);
                                Object object2 = attrinfo = typeinfo != null ? typeinfo.getAttributeInfo(attrname) : null;
                                if (attrinfo instanceof AttributeInfo && ((AttributeInfo)attrinfo).isIgnoreRead()) continue;
                                handler.handleAttributeValue(object, attrname, attrpath, attrval, attrinfo, readcontext);
                                if (!(attrinfo instanceof AttributeInfo) || !"id".equals(((AttributeInfo)attrinfo).getId())) continue;
                                readcontext.getReadObjects().put(attrval, object);
                            }
                            for (jadex.xml.stax.QName attrname : attrs) {
                                Object attrinfo = typeinfo.getAttributeInfo(attrname);
                                handler.handleAttributeValue(object, attrname, attrpath, null, attrinfo, readcontext);
                            }
                        } else {
                            StackElement se = readcontext.getTopStackElement();
                            readcontext.getReporter().report("No element on stack for attributes", "stack error", se, se.getLocation());
                        }
                    }
                    if (readcontext.getComment() != null && typeinfo != null && (commentinfo = typeinfo.getCommentInfo()) != null) {
                        handler.handleAttributeValue(object, null, null, readcontext.getComment(), commentinfo, readcontext);
                    }
                }
            }
            readcontext.setComment(null);
        }
    }

    protected void handleEndElement(final ReadContextDesktop readcontext) throws Exception {
        if (readcontext.getReadIgnore() == 0) {
            String id;
            IPostProcessor[] postprocs;
            XMLStreamReader parser = (XMLStreamReader)readcontext.getParser();
            StackElement topse = readcontext.getTopStackElement();
            jadex.xml.stax.QName localname = Reader.convertStaXQNameToQName(parser.getName());
            jadex.xml.stax.QName[] fullpath = readcontext.getXMLPath();
            TypeInfo typeinfo = readcontext.getPathManager().getTypeInfo(localname, fullpath, topse.getRawAttributes());
            if (topse.getObject() == null && topse.getContent() != null && topse.getContent().trim().length() > 0 || topse.getObject() == STRING_MARKER) {
                Object val;
                Object object = val = topse.getContent() != null ? topse.getContent() : topse.getObject();
                if (val instanceof String) {
                    if (typeinfo != null && typeinfo.getContentInfo() != null) {
                        IAttributeConverter conv;
                        Object coninfo = typeinfo.getContentInfo();
                        if (coninfo != null && coninfo instanceof AttributeInfo && (conv = ((AttributeInfo)coninfo).getConverter()) != null) {
                            val = conv.convertString((String)val, readcontext);
                        }
                    } else {
                        val = topse.getReaderHandler().convertContentObject((String)val, localname, readcontext);
                    }
                }
                topse = new StackElement(topse.getReaderHandler(), topse.getTag(), val, topse.getRawAttributes(), null, topse.getLocation());
                readcontext.setStackElement(topse, readcontext.getStackSize() - 1);
            }
            if (topse.getObject() != null && topse.getContent() != null && topse.getContent().trim().length() > 0) {
                if (typeinfo != null && typeinfo.getContentInfo() != null) {
                    topse.getReaderHandler().handleAttributeValue(topse.getObject(), null, null, topse.getContent(), typeinfo.getContentInfo(), readcontext);
                } else {
                    StackElement se = readcontext.getTopStackElement();
                    readcontext.getReporter().report("No content mapping for: " + topse.getContent() + " tag=" + topse.getTag(), "link error", se, se.getLocation());
                }
            }
            if ((postprocs = topse.getReaderHandler().getPostProcessors(topse.getObject(), typeinfo)) != null && postprocs.length > 0) {
                for (int i = 0; i < postprocs.length; ++i) {
                    if (postprocs[i].getPass() == 0) {
                        try {
                            Object changed = postprocs[i].postProcess(readcontext, topse.getObject());
                            if (changed == IPostProcessor.DISCARD_OBJECT) {
                                topse.setObject(null);
                                continue;
                            }
                            if (changed == null) continue;
                            topse.setObject(changed);
                        }
                        catch (RuntimeException e) {
                            readcontext.getReporter().report("Error during postprocessing: " + e, "postprocessor error", topse, topse.getLocation());
                        }
                        continue;
                    }
                    final StackElement ftopse = topse;
                    final StackElement[] stack = readcontext.getStack();
                    final int fi = i;
                    readcontext.getPostProcessors().put((Object)postprocs[i].getPass(), (Object)new IPostProcessorCall(){

                        @Override
                        public void callPostProcessor() throws Exception {
                            try {
                                Object check = postprocs[fi].postProcess(readcontext, ftopse.getObject());
                                if (check != null) {
                                    readcontext.getReporter().report("Object replacement only possible in first pass.", "postprocessor error", ftopse, ftopse.getLocation());
                                }
                            }
                            catch (Exception e) {
                                readcontext.getReporter().report("Error during postprocessing: " + e, "postprocessor error", stack, ftopse != null ? ftopse.getLocation() : readcontext.getLocation());
                            }
                        }
                    });
                }
            }
            String string = id = topse.getRawAttributes() != null ? (String)topse.getRawAttributes().get("__ID") : null;
            if (id != null && topse.getObject() != null) {
                readcontext.getReadObjects().put(id, topse.getObject());
            }
            if (topse.getObject() != null) {
                List childs;
                boolean bulklink;
                boolean bl = bulklink = typeinfo != null ? typeinfo.isBulkLink() : this.bulklink;
                if (readcontext.getStackSize() > 0 && bulklink && (childs = readcontext.removeChildren(topse.getObject())) != null) {
                    IBulkObjectLinker linker = (IBulkObjectLinker)(typeinfo != null && typeinfo.getLinker() != null ? typeinfo.getLinker() : topse.getReaderHandler());
                    linker.bulkLinkObjects(topse.getObject(), childs, readcontext);
                }
                if (readcontext.getStackSize() > 1) {
                    StackElement pse = readcontext.getStackElement(readcontext.getStackSize() - 2);
                    ArrayList<jadex.xml.stax.QName> pathname = new ArrayList<jadex.xml.stax.QName>();
                    pathname.add(localname);
                    for (int i = readcontext.getStackSize() - 3; i >= 0 && pse.getObject() == null; --i) {
                        pse = readcontext.getStackElement(i);
                        pathname.add(0, readcontext.getStackElement(i + 1).getTag());
                    }
                    if (pse.getObject() != null) {
                        TypeInfo patypeinfo = pse.getTypeInfo();
                        SubobjectInfo linkinfo = Reader.getSubobjectInfoRead(localname, fullpath, patypeinfo, topse.getRawAttributes());
                        boolean bl2 = bulklink = patypeinfo != null ? patypeinfo.isBulkLink() : this.bulklink;
                        if (!bulklink) {
                            IObjectLinker linker = (IObjectLinker)(patypeinfo != null && patypeinfo.getLinker() != null ? patypeinfo.getLinker() : pse.getReaderHandler());
                            linker.linkObject(topse.getObject(), pse.getObject(), linkinfo == null ? null : linkinfo, pathname.toArray(new jadex.xml.stax.QName[pathname.size()]), readcontext);
                        } else {
                            readcontext.addChild(pse.getObject(), new LinkData(topse.getObject(), linkinfo == null ? null : linkinfo, pathname.toArray(new jadex.xml.stax.QName[pathname.size()])));
                        }
                    } else {
                        StackElement se = readcontext.getTopStackElement();
                        readcontext.getReporter().report("No parent object found for: " + SUtil.arrayToString((Object)fullpath), "link error", se, se.getLocation());
                    }
                }
            }
            readcontext.removeStackElement();
        } else {
            readcontext.setReadIgnore(readcontext.getReadIgnore() - 1);
        }
    }

    private static jadex.xml.stax.QName convertStaXQNameToQName(QName qname) {
        return new jadex.xml.stax.QName(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix());
    }
}

