/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.writer;

import jadex.xml.writer.IObjectWriterHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public abstract class AWriter {
    public static final String XML_INCLUDE_FIELDS = "XML_INCLUDE_FIELDS";

    public void write(IObjectWriterHandler handler, Object object, OutputStream out, ClassLoader classloader, Object context) throws Exception {
        this.write(handler, object, "utf-8", out, classloader, context);
    }

    public abstract void write(IObjectWriterHandler var1, Object var2, String var3, OutputStream var4, ClassLoader var5, Object var6) throws Exception;

    public static String objectToXML(AWriter writer, Object val, ClassLoader classloader, IObjectWriterHandler handler) {
        try {
            return new String(AWriter.objectToByteArray(writer, val, classloader, handler), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Warning: no UTF-8 available");
            return new String(AWriter.objectToByteArray(writer, val, classloader, handler));
        }
    }

    public static String objectToXML(AWriter writer, Object val, ClassLoader classloader, Object context, IObjectWriterHandler handler) {
        try {
            return new String(AWriter.objectToByteArray(writer, val, classloader, context, handler), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Warning: no UTF-8 available");
            return new String(AWriter.objectToByteArray(writer, val, classloader, context, handler));
        }
    }

    public static byte[] objectToByteArray(AWriter writer, Object val, ClassLoader classloader, IObjectWriterHandler handler) {
        return AWriter.objectToByteArray(writer, val, classloader, null, handler);
    }

    public static byte[] objectToByteArray(AWriter writer, Object val, ClassLoader classloader, Object context, IObjectWriterHandler handler) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            writer.write(handler, val, bos, classloader, context);
            byte[] ret = bos.toByteArray();
            bos.close();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void objectToOutputStream(AWriter writer, Object val, OutputStream os, ClassLoader classloader, Object context, IObjectWriterHandler handler) {
        try {
            writer.write(handler, val, os, classloader, context);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

