/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.server.transport;

import jakarta.persistence.OptimisticLockException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.sourceforge.jbizmo.commons.exception.ExceptionHelper;
import net.sourceforge.jbizmo.commons.exchange.DataExportException;
import net.sourceforge.jbizmo.commons.exchange.DataImportException;
import net.sourceforge.jbizmo.commons.property.PropertyService;
import net.sourceforge.jbizmo.commons.reflect.MethodFinder;
import net.sourceforge.jbizmo.commons.repository.ConcurrentEntityModificationException;
import net.sourceforge.jbizmo.commons.repository.DuplicateCollectionEntryException;
import net.sourceforge.jbizmo.commons.repository.UniqueConstraintViolationException;
import net.sourceforge.jbizmo.commons.search.exception.GeneralSearchException;
import net.sourceforge.jbizmo.commons.stream.StreamWorker;
import net.sourceforge.jbizmo.commons.transport.MarshalledInvocation;
import net.sourceforge.jbizmo.commons.transport.MarshalledInvocationResult;
import net.sourceforge.jbizmo.commons.transport.RemoteOperationException;
import net.sourceforge.jbizmo.commons.validation.PropertyConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInvocationServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = -7111710755336680642L;
    private static final boolean PERFORM_AUTHENTICATION = new PropertyService().getBooleanProperty("jbizmo.application.transport.authentication.enabled");
    private static final String SECRET = new PropertyService().getStringProperty("jbizmo.application.transport.secret");
    private static final String MSG_NO_INFO = "Further information is not available!";

    protected abstract Object lookup(Class<?> var1);

    protected abstract boolean login(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4);

    protected abstract void logout(HttpServletRequest var1);

    protected Throwable convertException(Throwable rootCause) {
        boolean convert = true;
        if (rootCause.getClass() == ConcurrentEntityModificationException.class || rootCause.getClass() == PropertyConstraintViolationException.class) {
            convert = false;
        }
        if (rootCause.getClass() == UniqueConstraintViolationException.class || rootCause.getClass() == DuplicateCollectionEntryException.class) {
            convert = false;
        }
        if (rootCause.getClass() == GeneralSearchException.class) {
            convert = false;
        }
        if (rootCause.getClass() == DataImportException.class || rootCause.getClass() == DataExportException.class) {
            convert = false;
        }
        if (!convert) {
            return rootCause;
        }
        ConcurrentEntityModificationException convertedThrowable = null;
        if (rootCause.getClass() == OptimisticLockException.class) {
            OptimisticLockException lockException = (OptimisticLockException)rootCause;
            convertedThrowable = new ConcurrentEntityModificationException(lockException.getMessage());
        } else if (rootCause.getClass() == ConstraintViolationException.class) {
            ConstraintViolationException c = (ConstraintViolationException)rootCause;
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation constraintViolation : c.getConstraintViolations()) {
                msg.append(constraintViolation.getMessage());
                msg.append("\n");
            }
            convertedThrowable = new RemoteOperationException(msg.toString());
        } else {
            convertedThrowable = rootCause.getMessage() == null || rootCause.getMessage().isEmpty() ? new RemoteOperationException(MSG_NO_INFO) : new RemoteOperationException(rootCause.getMessage());
        }
        return convertedThrowable;
    }

    public MarshalledInvocationResult invoke(String serviceName, String methodName, Object ... args) {
        try {
            Class<?> serviceInterface = Class.forName(serviceName);
            Method m = MethodFinder.findMethod(serviceInterface, (String)methodName, (Object[])args);
            Object bean = this.lookup(serviceInterface);
            logger.debug("Invoke method '{}' of service '{}'", (Object)methodName, (Object)serviceName);
            Serializable result = (Serializable)m.invoke(bean, args);
            return new MarshalledInvocationResult(result);
        }
        catch (Exception e) {
            logger.error("Error while invoking method '{}' of service '{}'!", new Object[]{methodName, serviceName, e});
            Throwable convertedThrowable = this.convertException(ExceptionHelper.getRootCause((Throwable)e));
            return new MarshalledInvocationResult(convertedThrowable);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StreamWorker streamWorker = new StreamWorker(SECRET);
        String propertyEncrypt = request.getHeader("encrypt");
        Boolean encrypted = Boolean.valueOf(propertyEncrypt);
        logger.debug("Process invocation request from '{}'", (Object)request.getRemoteAddr());
        try {
            MarshalledInvocation mi = (MarshalledInvocation)streamWorker.readObjectFromStream((InputStream)request.getInputStream(), encrypted.booleanValue());
            if (mi == null) {
                RemoteOperationException illegalContentException = new RemoteOperationException("Invocation data is either missing or incorrect!");
                streamWorker.writeObjectToStream((Serializable)new MarshalledInvocationResult((Throwable)illegalContentException), (OutputStream)response.getOutputStream(), encrypted.booleanValue());
                return;
            }
            if (PERFORM_AUTHENTICATION && !this.login(request, response, mi.getUserName(), mi.getPassword())) {
                streamWorker.writeObjectToStream((Serializable)new MarshalledInvocationResult((Throwable)new SecurityException("Authentication failed!")), (OutputStream)response.getOutputStream(), encrypted.booleanValue());
                return;
            }
            MarshalledInvocationResult resultObject = this.invoke(mi.getServiceInterfaceName(), mi.getMethodName(), mi.getArguments());
            streamWorker.writeObjectToStream((Serializable)resultObject, (OutputStream)response.getOutputStream(), encrypted.booleanValue());
            if (PERFORM_AUTHENTICATION) {
                this.logout(request);
            }
        }
        catch (Exception ex) {
            logger.error("Error while processing invocation request from '{}'!", (Object)request.getRemoteAddr(), (Object)ex);
            try {
                RemoteOperationException unexpectedError = new RemoteOperationException("The server encountered an unexpected error! Message: " + ex.getMessage());
                streamWorker.writeObjectToStream((Serializable)new MarshalledInvocationResult((Throwable)unexpectedError), (OutputStream)response.getOutputStream(), encrypted.booleanValue());
            }
            catch (Exception e) {
                logger.error("Could not create invocation result object!", (Throwable)e);
                response.sendError(500, e.getMessage());
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.processRequest(req, resp);
        }
        catch (IOException e) {
            logger.error("An internal error occurred while processing the GET request!", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.processRequest(req, resp);
        }
        catch (IOException e) {
            logger.error("An internal error occurred while processing the POST request!", (Throwable)e);
        }
    }
}

