/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.server.transport;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import net.sourceforge.jbizmo.commons.property.PropertyService;
import net.sourceforge.jbizmo.commons.stream.StreamWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/download"}, name="FileDownloadServlet")
public class FileDownloadServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = -1100249810905720275L;
    private static final String SECRET = new PropertyService().getStringProperty("jbizmo.application.transport.secret");

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = null;
        File downloadFile = null;
        StreamWorker streamWorker = null;
        String propertyEncrypt = request.getHeader("encrypt");
        Boolean encrypted = Boolean.valueOf(propertyEncrypt);
        logger.debug("Process file download request");
        try {
            streamWorker = new StreamWorker(SECRET);
            path = (String)streamWorker.readObjectFromStream((InputStream)request.getInputStream(), encrypted.booleanValue());
            if (path == null) {
                logger.warn("Download operation failed. The request contained no path!");
                response.sendError(400, "Unexpected content in request!");
                return;
            }
            downloadFile = new File(path);
            if (!downloadFile.exists()) {
                logger.warn("Download operation failed. The file '{}' could not be found!", (Object)path);
                response.sendError(404, "Requested file doesn't exist!");
                return;
            }
            logger.debug("Download file '{}'", (Object)path);
            response.setContentLength((int)downloadFile.length());
            try (FileInputStream fin = new FileInputStream(downloadFile);){
                streamWorker.writeToOutput((InputStream)fin, (OutputStream)response.getOutputStream(), encrypted.booleanValue(), false);
            }
        }
        catch (Exception e) {
            logger.error("Error while performing download operation!", (Throwable)e);
            this.sendError(response, e.getMessage());
        }
    }

    private void sendError(HttpServletResponse response, String message) {
        try {
            response.sendError(500, message);
        }
        catch (Exception e) {
            logger.error("Failed to send error code!", (Throwable)e);
        }
    }
}

