/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.server.transport;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import net.sourceforge.jbizmo.commons.property.PropertyService;
import net.sourceforge.jbizmo.commons.stream.StreamWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/upload"}, name="FileUploadServlet")
public class FileUploadServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = -8792320718931743029L;
    private static final String FILE_EXCHANGE_FOLDER = new PropertyService().getStringProperty("jbizmo.application.file-exchange-folder");
    private static final String SECRET = new PropertyService().getStringProperty("jbizmo.application.transport.secret");

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = "";
        try {
            File tempFile;
            StreamWorker streamWorker = new StreamWorker(SECRET);
            String propertyEncrypt = request.getHeader("encrypt");
            Boolean encrypted = Boolean.valueOf(propertyEncrypt);
            fileName = request.getHeader("filename");
            logger.debug("Upload file '{}'", (Object)fileName);
            if (!FILE_EXCHANGE_FOLDER.isEmpty()) {
                tempFile = new File(FILE_EXCHANGE_FOLDER + fileName + System.currentTimeMillis());
                if (!tempFile.createNewFile()) {
                    throw new IllegalStateException("The file " + tempFile.getName() + " already exists!");
                }
            } else {
                tempFile = File.createTempFile(fileName, Long.toString(System.currentTimeMillis()));
            }
            try (FileOutputStream fout = new FileOutputStream(tempFile);){
                streamWorker.writeToOutput((InputStream)request.getInputStream(), (OutputStream)fout, false, encrypted.booleanValue());
                streamWorker.writeObjectToStream((Serializable)((Object)tempFile.getAbsolutePath()), (OutputStream)response.getOutputStream(), encrypted.booleanValue());
            }
        }
        catch (Exception e) {
            logger.error("Error while performing file upload operation!", (Throwable)e);
            this.sendError(response, e.getMessage());
        }
    }

    private void sendError(HttpServletResponse response, String message) {
        try {
            response.sendError(500, message);
        }
        catch (Exception e) {
            logger.error("Failed to send error code!", (Throwable)e);
        }
    }
}

