/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.control;

import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.AbstractLOVDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;

public abstract class AbstractLOVField<T, X>
extends GridPane {
    private final AbstractLOVDialog<X> lovDialog;
    private T selectedItem;
    private TextField txtValue;
    private Button cmdOpen;
    private boolean editable = true;

    public AbstractLOVField(AbstractLOVDialog<X> lovDialog) {
        this.lovDialog = lovDialog;
        this.initialize();
    }

    public abstract String getItemText(T var1);

    public T convertSelection(X selectedItem) {
        return null;
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(T selectedItem) {
        this.selectedItem = selectedItem;
        if (selectedItem != null) {
            this.txtValue.setText(this.getItemText(selectedItem));
        } else {
            this.txtValue.setText("");
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.cmdOpen.setDisable(!editable);
    }

    private void openLOV() {
        if (!this.editable) {
            return;
        }
        DialogButtonType returnCode = this.lovDialog.open();
        if (returnCode == DialogButtonType.OK) {
            this.setSelectedItem(this.convertSelection(this.lovDialog.getSelection()));
        } else if (returnCode == DialogButtonType.RESET) {
            this.setSelectedItem(null);
        }
    }

    private void initialize() {
        this.setHgap(5.0);
        this.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        this.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        this.txtValue = new TextField();
        this.txtValue.setEditable(false);
        this.txtValue.setOnMouseClicked(e -> this.openLOV());
        this.cmdOpen = new Button();
        this.cmdOpen.setGraphic((Node)new ImageView(ImageLoader.getImage("lov.png")));
        this.cmdOpen.setOnAction(e -> this.openLOV());
        this.cmdOpen.setTooltip(new Tooltip(I18NJavaFX.getTranslation("abstract_lov_field.cmd_open")));
        this.add((Node)this.txtValue, 0, 0);
        this.add((Node)this.cmdOpen, 1, 0);
    }

    public void setTooltip(Tooltip tooltip) {
        this.txtValue.setTooltip(tooltip);
    }
}

