/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.control;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.Cursor;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Popup;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;

public abstract class AbstractProposalTextField<T>
extends TextField {
    private static final long AUTO_COMPLETE_DELAY = 250L;
    private static final int ITEM_HEIGHT = 26;
    private static final int MAX_POPUP_HEIGHT = 130;
    private static final int DEFAULT_ITEM_LIMIT = 6;
    private ListView<T> listView;
    private Popup popup;
    private int limit;
    private long autoCompleteDelay;
    private T selectedItem;
    private DataFetchTask dataFetchTask;
    private FilterInputChangeListener inputChangeListener;

    public AbstractProposalTextField() {
        this(6, 250L);
    }

    public AbstractProposalTextField(int itemLimit, long autoCompleteDelay) {
        this.limit = itemLimit;
        this.autoCompleteDelay = autoCompleteDelay;
        this.listView = new ListView();
        this.listView.setOnMouseReleased(e -> this.selectItem());
        this.listView.itemsProperty().addListener((value, oldValue, newValue) -> {
            if (this.listView.getItems() != null && !this.listView.getItems().isEmpty()) {
                this.showPopup();
            } else {
                this.hidePopup();
            }
        });
        this.listView.setOnKeyReleased(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.selectItem();
            }
        });
        this.listView.setCellFactory(p -> new ListCell<T>(){

            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (item != null) {
                    this.setText(AbstractProposalTextField.this.getProposalText(item));
                } else {
                    this.setText("");
                }
            }
        });
        this.inputChangeListener = new FilterInputChangeListener();
        this.textProperty().addListener((ChangeListener)this.inputChangeListener);
        this.popup = new Popup();
        this.popup.setAutoHide(true);
        this.popup.getContent().add(this.listView);
    }

    public List<T> getProposalItems(String textEntered) throws Exception {
        return new ArrayList();
    }

    public abstract String getProposalText(T var1);

    public void applySelection(T item) {
        this.selectedItem = item;
        this.textProperty().removeListener((ChangeListener)this.inputChangeListener);
        if (item != null) {
            this.setText(this.getProposalText(item));
        } else {
            this.setText("");
        }
        this.textProperty().addListener((ChangeListener)this.inputChangeListener);
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(T selectedItem) {
        this.selectedItem = selectedItem;
        this.applySelection(selectedItem);
    }

    private void selectItem() {
        this.applySelection(this.listView.getSelectionModel().getSelectedItem());
        if (this.selectedItem == null) {
            return;
        }
        this.listView.getItems().clear();
        this.requestFocus();
        this.requestLayout();
        this.end();
        this.hidePopup();
    }

    public void showPopup() {
        int itemCount = this.listView.getItems().size();
        this.listView.setPrefWidth(this.getWidth());
        this.listView.setPrefHeight(itemCount * 26 > 130 ? 130.0 : (double)(itemCount * 26));
        double xPos = this.getScene().getWindow().getX() + this.localToScene(0.0, 0.0).getX() + this.getScene().getX();
        double yPos = this.getScene().getWindow().getY() + this.localToScene(0.0, 0.0).getY() + this.getScene().getY() + 26.0;
        this.popup.show(this.getScene().getWindow(), xPos, yPos);
        this.listView.getSelectionModel().clearSelection();
        this.listView.getFocusModel().focus(-1);
    }

    public void hidePopup() {
        this.popup.hide();
    }

    private class FilterInputChangeListener
    implements ChangeListener<String> {
        private FilterInputChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observable, String newValue, String oldValue) {
            if (AbstractProposalTextField.this.getText().length() > 0) {
                if (AbstractProposalTextField.this.dataFetchTask != null && AbstractProposalTextField.this.dataFetchTask.isRunning()) {
                    AbstractProposalTextField.this.dataFetchTask.cancel();
                }
                new Thread((Runnable)((Object)(AbstractProposalTextField.this.dataFetchTask = new DataFetchTask(AbstractProposalTextField.this.getText())))).start();
            } else {
                AbstractProposalTextField.this.hidePopup();
            }
        }
    }

    private class DataFetchTask
    extends Task<Void> {
        private final String filterText;

        public DataFetchTask(String filterText) {
            this.filterText = filterText;
        }

        protected void scheduled() {
            AbstractProposalTextField.this.getScene().setCursor(Cursor.WAIT);
        }

        protected Void call() throws Exception {
            long startTime = System.currentTimeMillis();
            ObservableList list = AbstractProposalTextField.this.getProposalItems(this.filterText).stream().limit(AbstractProposalTextField.this.limit).collect(Collectors.toCollection(FXCollections::observableArrayList));
            long sleepTime = startTime + AbstractProposalTextField.this.autoCompleteDelay - System.currentTimeMillis();
            if (sleepTime > 0L && !this.isDone()) {
                Thread.sleep(sleepTime);
            }
            if (this.isDone()) {
                return null;
            }
            Platform.runLater(() -> {
                if (list != null && !list.isEmpty()) {
                    AbstractProposalTextField.this.listView.setItems(list);
                    AbstractProposalTextField.this.showPopup();
                } else {
                    AbstractProposalTextField.this.hidePopup();
                }
            });
            return null;
        }

        protected void done() {
            Platform.runLater(() -> AbstractProposalTextField.this.getScene().setCursor(Cursor.DEFAULT));
        }

        protected void failed() {
            DialogUtil.openErrorDialog(null, I18NJavaFX.getTranslation("data_fetch_action.msg_query_failed"), this.getException());
        }
    }
}

