/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;

public abstract class AbstractSelectionListPanel<T>
extends VBox {
    private static final long INPUT_DELAY = 250L;
    private ListView<T> sourceListView;
    private ListView<T> targetListView;
    private TextField txtFilter;
    private DataFetchTask task;
    private boolean addSearchField;

    public AbstractSelectionListPanel() {
        this.initialize(null, false);
    }

    public AbstractSelectionListPanel(String title) {
        this.initialize(title, false);
    }

    public AbstractSelectionListPanel(String title, boolean addSearchField) {
        this.addSearchField = addSearchField;
        this.initialize(title, addSearchField);
    }

    public abstract String getItemText(T var1);

    public abstract List<T> searchItems(String var1) throws Exception;

    public List<T> getAvailableItems() {
        return this.sourceListView.getItems().stream().collect(Collectors.toList());
    }

    public void setAvailableItems(Collection<T> availableItems) {
        this.sourceListView.getItems().clear();
        this.sourceListView.getItems().addAll((Collection)availableItems.stream().filter(f -> !this.getSelectedItems().contains(f)).collect(Collectors.toList()));
    }

    public List<T> getSelectedItems() {
        return this.targetListView.getItems().stream().collect(Collectors.toList());
    }

    public void setSelectedItems(Collection<T> selectedItems) {
        this.targetListView.getItems().clear();
        this.targetListView.getItems().addAll(selectedItems);
    }

    private void moveToTarget() {
        this.move(this.sourceListView, this.targetListView);
        this.sourceListView.getSelectionModel().clearSelection();
    }

    private void moveAllToTarget() {
        this.move(this.sourceListView, this.targetListView, new ArrayList(this.sourceListView.getItems()));
        this.sourceListView.getSelectionModel().clearSelection();
    }

    private void moveToSource() {
        this.move(this.targetListView, this.sourceListView);
        this.targetListView.getSelectionModel().clearSelection();
    }

    private void moveAllToSource() {
        this.move(this.targetListView, this.sourceListView, new ArrayList(this.targetListView.getItems()));
        this.targetListView.getSelectionModel().clearSelection();
    }

    private void move(ListView<T> fromList, ListView<T> toList) {
        ArrayList selectedItems = new ArrayList(fromList.getSelectionModel().getSelectedItems());
        this.move(fromList, toList, selectedItems);
    }

    private void move(ListView<T> fromList, ListView<T> toList, List<T> items) {
        items.forEach(item -> {
            fromList.getItems().remove(item);
            toList.getItems().add(item);
        });
    }

    private void refresh() {
        if (this.task != null && this.task.isRunning()) {
            this.task.cancel();
        }
        this.task = new DataFetchTask(this.txtFilter.getText());
        new Thread((Runnable)((Object)this.task)).start();
    }

    private void initialize(String title, boolean addSearchField) {
        GridPane panFilter = null;
        if (addSearchField) {
            panFilter = new GridPane();
            panFilter.setHgap(5.0);
            panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
            panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
            panFilter.add((Node)new Label(I18NJavaFX.getTranslation("selection_list_panel.lbl_search_elements")), 0, 0);
            this.txtFilter = new TextField();
            panFilter.add((Node)this.txtFilter, 1, 0);
            panFilter.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
            this.txtFilter.textProperty().addListener((observable, oldValue, newValue) -> this.refresh());
        }
        GridPane panLists = new GridPane();
        panLists.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panLists.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.CENTER, false));
        panLists.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panLists.setHgap(5.0);
        panLists.setVgap(5.0);
        panLists.setPrefHeight(150.0);
        panLists.setMaxHeight(Double.MAX_VALUE);
        panLists.setMaxWidth(Double.MAX_VALUE);
        Label lblSource = new Label(I18NJavaFX.getTranslation("selection_list_panel.lbl_source_list"));
        Label lblTarget = new Label(I18NJavaFX.getTranslation("selection_list_panel.lbl_target_list"));
        this.sourceListView = new ListView();
        this.sourceListView.setCellFactory((Callback)new InternalCallback());
        this.targetListView = new ListView();
        this.targetListView.setCellFactory((Callback)new InternalCallback());
        this.sourceListView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
                this.moveToTarget();
            }
        });
        this.targetListView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
                this.moveToSource();
            }
        });
        VBox panButtons = new VBox(5.0);
        panButtons.setFillWidth(true);
        Button cmdSelectItem = new Button("", (Node)new ImageView(ImageLoader.getImage("select_item.png")));
        cmdSelectItem.setOnAction(e -> this.moveToTarget());
        Button cmdSelectAllItems = new Button("", (Node)new ImageView(ImageLoader.getImage("select_all.png")));
        cmdSelectAllItems.setOnAction(e -> this.moveAllToTarget());
        Button cmdDeselectItem = new Button("", (Node)new ImageView(ImageLoader.getImage("deselect_item.png")));
        cmdDeselectItem.setOnAction(e -> this.moveToSource());
        Button cmdDeselectAllItems = new Button("", (Node)new ImageView(ImageLoader.getImage("deselect_all.png")));
        cmdDeselectAllItems.setOnAction(e -> this.moveAllToSource());
        panButtons.getChildren().addAll((Object[])new Node[]{cmdSelectItem, cmdSelectAllItems, cmdDeselectItem, cmdDeselectAllItems});
        panLists.add((Node)lblSource, 0, 0);
        panLists.add((Node)lblTarget, 2, 0);
        panLists.add(this.sourceListView, 0, 1);
        panLists.add((Node)panButtons, 1, 1);
        panLists.add(this.targetListView, 2, 1);
        GridPane.setValignment((Node)panButtons, (VPos)VPos.CENTER);
        GridPane.setVgrow((Node)panButtons, (Priority)Priority.NEVER);
        GridPane.setVgrow(this.sourceListView, (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.targetListView, (Priority)Priority.ALWAYS);
        if (title != null) {
            VBox panTitleContent = new VBox();
            if (panFilter != null) {
                panTitleContent.getChildren().add((Object)panFilter);
            }
            panTitleContent.getChildren().add((Object)panLists);
            TitledPane panTitle = new TitledPane(title, (Node)panTitleContent);
            panTitle.setCollapsible(false);
            panTitle.setMaxHeight(Double.MAX_VALUE);
            panTitle.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().add((Object)panTitle);
            VBox.setVgrow((Node)panTitleContent, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)panLists, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)panTitle, (Priority)Priority.ALWAYS);
        } else {
            if (panFilter != null) {
                this.getChildren().add((Object)panFilter);
            }
            this.getChildren().add((Object)panLists);
            VBox.setVgrow((Node)panLists, (Priority)Priority.ALWAYS);
        }
    }

    public void setTooltip(Tooltip tooltip) {
        this.targetListView.setTooltip(tooltip);
    }

    private class InternalCallback
    implements Callback<ListView<T>, ListCell<T>> {
        private InternalCallback() {
        }

        public ListCell<T> call(ListView<T> arg0) {
            return new ListCell<T>(){

                protected void updateItem(T t, boolean bln) {
                    super.updateItem(t, bln);
                    if (t != null) {
                        this.setText(AbstractSelectionListPanel.this.getItemText(t));
                    } else {
                        this.setText("");
                    }
                }
            };
        }
    }

    private class DataFetchTask
    extends Task<Void> {
        private final String filter;

        public DataFetchTask(String filter) {
            this.filter = filter;
        }

        protected void scheduled() {
            AbstractSelectionListPanel.this.getScene().setCursor(Cursor.WAIT);
        }

        public Void call() throws Exception {
            long sleepTime;
            long startTime = System.currentTimeMillis();
            List data = AbstractSelectionListPanel.this.searchItems(this.filter);
            if (AbstractSelectionListPanel.this.addSearchField && (sleepTime = startTime + 250L - System.currentTimeMillis()) > 0L && !this.isDone()) {
                Thread.sleep(sleepTime);
            }
            if (this.isDone()) {
                return null;
            }
            if (data != null) {
                Platform.runLater(() -> AbstractSelectionListPanel.this.setAvailableItems(data));
            }
            return null;
        }

        protected void done() {
            Platform.runLater(() -> AbstractSelectionListPanel.this.getScene().setCursor(Cursor.DEFAULT));
        }

        protected void failed() {
            DialogUtil.openErrorDialog(null, I18NJavaFX.getTranslation("data_fetch_action.msg_query_failed"), this.getException());
        }
    }
}

