/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.control;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.View;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.ViewGroup;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;
import net.sourceforge.jbizmo.commons.richclient.search.event.SearchDTOChangeController;
import net.sourceforge.jbizmo.commons.richclient.search.event.SearchDTOChangeListener;
import net.sourceforge.jbizmo.commons.richclient.search.util.SearchManager;
import net.sourceforge.jbizmo.commons.search.dto.SearchDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchListDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewNavigator
extends TreeView<View>
implements SearchDTOChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TreeItem<View> rootItem;
    private TreeItem<View> savedQueriesItem;
    private final TabPane viewParent;

    public AbstractViewNavigator(TabPane viewParent) {
        this.viewParent = viewParent;
        SearchDTOChangeController.addSearchDTOChangeListener((SearchDTOChangeListener)this);
    }

    public void onNewSavedQuery(SearchListDTO savedSearch) {
        this.addSavedSearch(savedSearch);
    }

    public abstract void addTreeItems(TreeItem<View> var1);

    protected void addRootItem() {
        this.rootItem = new TreeItem((Object)new ViewGroup(I18NJavaFX.getTranslation("abstract_view_navigator.root_item_label")));
        this.rootItem.setGraphic((Node)new ImageView(ImageLoader.getImage("folder.png")));
        this.setRoot(this.rootItem);
        this.rootItem.setExpanded(true);
    }

    private void addSavedSearch(SearchListDTO savedSearch) {
        try {
            Class<?> cl = Class.forName(savedSearch.getViewName());
            Constructor<?> cons = cl.getConstructor(String.class, SearchDTO.class, Integer.class);
            View view = (View)cons.newInstance(savedSearch.getName(), SearchManager.getSavedSearch((int)savedSearch.getId()), savedSearch.getId());
            TreeItem treeItem = new TreeItem((Object)view);
            treeItem.setGraphic((Node)new ImageView(ImageLoader.getImage("view.png")));
            this.savedQueriesItem.getChildren().add((Object)treeItem);
        }
        catch (Exception e) {
            logger.error("Could not add saved search to navigator tree view!", (Throwable)e);
        }
    }

    private void addSavedQueries() {
        this.savedQueriesItem = new TreeItem((Object)new ViewGroup(I18NJavaFX.getTranslation("abstract_view_navigator.saved_queries_label")));
        this.savedQueriesItem.setGraphic((Node)new ImageView(ImageLoader.getImage("folder.png")));
        this.rootItem.getChildren().add(this.savedQueriesItem);
        SearchManager.getAllSavedSearchObjects().forEach(this::addSavedSearch);
        this.savedQueriesItem.setExpanded(true);
    }

    private void deleteSavedQuery() {
        String message = I18NJavaFX.getTranslation("abstract_view_navigator.msg_delete_query");
        String title = I18NJavaFX.getTranslation("abstract_view_navigator.msg_delete_query_title");
        if (DialogButtonType.YES != DialogUtil.openConfirmationDialog(null, title, message)) {
            return;
        }
        TreeItem selectedItem = (TreeItem)this.getSelectionModel().getSelectedItem();
        Integer id = ((View)selectedItem.getValue()).getSavedQueryId();
        SearchManager.deleteSavedSearchObject((int)id);
        this.savedQueriesItem.getChildren().remove((Object)selectedItem);
    }

    public void initialize() {
        this.addRootItem();
        this.addTreeItems(this.rootItem);
        this.addSavedQueries();
        ContextMenu mnuTree = new ContextMenu();
        MenuItem mniDelete = new MenuItem(I18NJavaFX.getTranslation("action_delete.title"));
        mniDelete.setOnAction(e -> this.deleteSavedQuery());
        mnuTree.getItems().add((Object)mniDelete);
        this.setOnContextMenuRequested(event -> {
            mnuTree.hide();
            this.setContextMenu(null);
            if (this.getSelectionModel().getSelectedItem() == null) {
                return;
            }
            if (((View)((TreeItem)this.getSelectionModel().getSelectedItem()).getValue()).getTab() == null) {
                return;
            }
            if (((View)((TreeItem)this.getSelectionModel().getSelectedItem()).getValue()).getSavedQueryId() == null) {
                return;
            }
            this.setContextMenu(mnuTree);
            mnuTree.show((Node)this, event.getScreenX(), event.getScreenY());
        });
        this.setOnMouseClicked(e -> {
            if (e.getClickCount() != 2) {
                return;
            }
            if (this.getSelectionModel().getSelectedItem() == null) {
                return;
            }
            View view = (View)((TreeItem)this.getSelectionModel().getSelectedItem()).getValue();
            if (view == null || view.getTab() == null) {
                return;
            }
            if (!this.viewParent.getTabs().contains((Object)view.getTab())) {
                this.viewParent.getTabs().add((Object)view.getTab());
                view.getTab().setText(((View)((TreeItem)this.getSelectionModel().getSelectedItem()).getValue()).toString());
                view.initialize();
            }
            this.viewParent.getSelectionModel().select((Object)view.getTab());
        });
    }
}

