/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.control;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class Action
implements EventHandler<ActionEvent> {
    protected String title;
    protected Image image;
    private final List<MenuItem> menuItems = new ArrayList<MenuItem>();
    private final List<Button> buttons = new ArrayList<Button>();

    public MenuItem createMenuItem() {
        return this.createMenuItem(null);
    }

    public MenuItem createMenuItem(KeyCodeCombination keyCodeCombination) {
        if (!this.isEnabled()) {
            return null;
        }
        MenuItem item = new MenuItem();
        item.setText(this.title);
        item.setOnAction((EventHandler)this);
        item.setGraphic((Node)new ImageView(this.image));
        item.setAccelerator((KeyCombination)keyCodeCombination);
        this.menuItems.add(item);
        return item;
    }

    public Button createButton() {
        if (!this.isEnabled()) {
            return null;
        }
        Button button = new Button(this.title);
        button.setOnAction((EventHandler)this);
        this.buttons.add(button);
        return button;
    }

    public Button createToolbarButton() {
        if (!this.isEnabled()) {
            return null;
        }
        Button button = new Button("", (Node)new ImageView(this.image));
        button.setTooltip(new Tooltip(this.title));
        button.setOnAction((EventHandler)this);
        this.buttons.add(button);
        return button;
    }

    public void setEnabled(boolean enable) {
        this.buttons.forEach(b -> b.setDisable(!enable));
        this.menuItems.forEach(m -> m.setDisable(!enable));
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isEnabled() {
        return true;
    }

    public void handle() {
    }

    public void handle(ActionEvent event) {
        this.handle();
    }
}

