/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.control;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.util.StringConverter;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;

public class LocalDateConverter
extends StringConverter<LocalDate> {
    private final FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(this.userFormat.getDateFormat()).withZone(ZoneId.systemDefault());

    public String toString(LocalDate date) {
        if (date != null) {
            return this.dateFormatter.format(date);
        }
        return "";
    }

    public LocalDate fromString(String string) {
        if (string != null && !string.isEmpty()) {
            return LocalDate.parse(string, this.dateFormatter);
        }
        return null;
    }
}

