/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;

public abstract class AbstractBaseDialog
extends Stage {
    private static final double DEFAULT_WIDTH = 500.0;
    private static final double DEFAULT_HEIGHT = 500.0;
    protected DialogButtonType returnCode = DialogButtonType.CANCEL;
    private HBox panButtons;

    public AbstractBaseDialog(Window owner) {
        this(owner, null);
    }

    public AbstractBaseDialog(Window owner, String title) {
        this.setTitle(title);
        this.initOwner(owner);
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    protected abstract Node createDialogArea();

    protected void createButtons() {
        this.addButton(DialogButtonType.OK, I18NJavaFX.getTranslation("cmd_ok"), true, false);
        this.addButton(DialogButtonType.CANCEL, I18NJavaFX.getTranslation("cmd_cancel"), false, true);
    }

    protected Button addButton(DialogButtonType type, String label, boolean defaultButton, boolean cancelButton) {
        Button button = new Button(label);
        button.setDefaultButton(defaultButton);
        button.setCancelButton(cancelButton);
        button.setOnAction(e -> this.buttonPressed(type));
        this.panButtons.getChildren().add((Object)button);
        return button;
    }

    protected Button addButton(DialogButtonType type, String label) {
        return this.addButton(type, label, false, false);
    }

    protected void buttonPressed(DialogButtonType type) {
        this.returnCode = type;
        if (type == DialogButtonType.OK) {
            this.onOKPressed();
        } else if (type == DialogButtonType.CANCEL) {
            this.onCancelPressed();
        }
    }

    protected void onOKPressed() {
        this.close();
    }

    protected void onCancelPressed() {
        this.close();
    }

    protected void setReturnCode(DialogButtonType returnCode) {
        this.returnCode = returnCode;
    }

    protected Node createButtonBar() {
        this.panButtons = new HBox(10.0);
        this.panButtons.setPadding(new Insets(10.0));
        Region spacer = new Region();
        this.panButtons.getChildren().add((Object)spacer);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.createButtons();
        return this.panButtons;
    }

    protected Parent createContents() {
        VBox panRoot = new VBox();
        VBox panMainContent = new VBox();
        panMainContent.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Node panDialogArea = this.createDialogArea();
        panRoot.getChildren().add((Object)panMainContent);
        VBox.setVgrow((Node)panMainContent, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)panRoot, (Priority)Priority.ALWAYS);
        panMainContent.getChildren().add((Object)panDialogArea);
        VBox.setVgrow((Node)panDialogArea, (Priority)Priority.ALWAYS);
        panRoot.getChildren().add((Object)new Separator());
        panRoot.getChildren().add((Object)this.createButtonBar());
        this.setOnCloseRequest(e -> this.onClose());
        return panRoot;
    }

    public void onOpen() {
    }

    public void onClose() {
    }

    public DialogButtonType open(boolean block) {
        Parent content = this.createContents();
        Scene scene = new Scene(content, 500.0, 500.0);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/resource/css/application.css").toExternalForm());
        this.setScene(scene);
        this.onOpen();
        if (block) {
            this.showAndWait();
        } else {
            this.show();
        }
        return this.returnCode;
    }

    public DialogButtonType open() {
        return this.open(true);
    }
}

