/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.TitleAreaDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;

public abstract class AbstractChangePasswordDialog
extends TitleAreaDialog {
    protected static final int MIN_PASSWORD_LENGTH = 4;
    protected PasswordField txtOldPassword;
    protected PasswordField txtNewPassword;
    protected PasswordField txtNewPasswordConfirm;

    public AbstractChangePasswordDialog(Window owner) {
        super(owner, I18NJavaFX.getTranslation("abstract_change_password_dialog.title"));
        this.setSize(350, 250);
        this.setResizable(false);
        this.initStyle(StageStyle.UTILITY);
    }

    public abstract boolean saveNewPassword(String var1, String var2, String var3);

    @Override
    protected Node createDialogArea() {
        this.setTitleMessage(I18NJavaFX.getTranslation("abstract_change_password_dialog.title_message"));
        this.setTitleImage(ImageLoader.getImage("edit_data_title.png"));
        GridPane panContent = new GridPane();
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false));
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panContent.setHgap(5.0);
        panContent.setVgap(5.0);
        panContent.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("abstract_change_password_dialog.lbl_old_password")), 0, 0);
        this.txtOldPassword = new PasswordField();
        panContent.add((Node)this.txtOldPassword, 1, 0);
        panContent.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("abstract_change_password_dialog.lbl_new_password")), 0, 1);
        this.txtNewPassword = new PasswordField();
        panContent.add((Node)this.txtNewPassword, 1, 1);
        panContent.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("abstract_change_password_dialog.lbl_password_confirm")), 0, 2);
        this.txtNewPasswordConfirm = new PasswordField();
        panContent.add((Node)this.txtNewPasswordConfirm, 1, 2);
        return panContent;
    }

    private boolean validateFormData() {
        String fieldLabel = "";
        String inputToCheck = "";
        this.setErrorMessage("");
        inputToCheck = this.txtNewPassword.getText();
        fieldLabel = I18NJavaFX.getTranslation("abstract_change_password_dialog.lbl_new_password");
        if (inputToCheck.length() < 4) {
            this.setErrorMessage(I18NJavaFX.getTranslation("msg_err_min_field_length", fieldLabel, 4));
            this.txtNewPassword.requestFocus();
            return false;
        }
        fieldLabel = I18NJavaFX.getTranslation("abstract_change_password_dialog.lbl_password_confirm");
        if (!this.txtNewPassword.getText().equals(this.txtNewPasswordConfirm.getText())) {
            this.setErrorMessage(I18NJavaFX.getTranslation("msg_err_passwords_not_equal", fieldLabel));
            this.txtNewPasswordConfirm.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void onOKPressed() {
        if (!this.validateFormData()) {
            return;
        }
        if (!this.saveNewPassword(this.txtOldPassword.getText(), this.txtNewPassword.getText(), this.txtNewPasswordConfirm.getText())) {
            return;
        }
        this.returnCode = DialogButtonType.OK;
        this.close();
    }
}

